/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.tree.BaseElement;
import org.dom4j.tree.DefaultDocument;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.render.RenderUtil;
import org.springframework.extensions.surf.types.AdvancedComponent;
import org.springframework.extensions.surf.types.AdvancedComponentImpl;
import org.springframework.extensions.surf.types.Customization;
import org.springframework.extensions.surf.types.XMLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionModule {
    private static final Log logger = LogFactory.getLog(ExtensionModule.class);
    public static final String ID = "id";
    public static final String AUTO_DEPLOY = "auto-deploy";
    public static final String DESCRIPTION = "description";
    public static final String EVALUATOR = "evaluator";
    public static final String EVALUATOR_TYPE = "type";
    public static final String EVALUATOR_PROPS = "params";
    public static final String COMPONENTS = "components";
    public static final String COMPONENT = "component";
    public static final String CUSTOMIZATIONS = "customizations";
    public static final String CUSTOMIZATION = "customization";
    private ModelPersisterInfo key = null;
    private String id = null;
    private boolean autoDeploy = false;
    private String description = null;
    private String evaluator = null;
    private Map<String, String> evaluatorProperties = new HashMap<String, String>();
    private List<Customization> customizations = new ArrayList<Customization>();
    public HashMap<String, AdvancedComponent> advancedComponents = new HashMap();

    public ModelPersisterInfo getKeyPath() {
        return this.key;
    }

    public ExtensionModule(Element element, ModelPersisterInfo key) {
        this.id = XMLHelper.getStringData(ID, element, true);
        this.autoDeploy = Boolean.valueOf(XMLHelper.getStringData(AUTO_DEPLOY, element, false));
        this.key = key;
        if (this.id != null) {
            this.description = XMLHelper.getStringData(DESCRIPTION, element, false);
            Element evaluatorEl = element.element(EVALUATOR);
            if (evaluatorEl != null) {
                this.evaluator = evaluatorEl.attributeValue(EVALUATOR_TYPE);
                this.evaluatorProperties = XMLHelper.getProperties(EVALUATOR_PROPS, evaluatorEl);
            }
            List customizationsList = element.elements(CUSTOMIZATIONS);
            for (Element customizationsEl : customizationsList) {
                List customizationList = customizationsEl.elements(CUSTOMIZATION);
                for (Element customizationEl : customizationList) {
                    this.customizations.add(new Customization(customizationEl));
                }
            }
            List componentsList = element.elements(COMPONENTS);
            for (Element componentsEl : componentsList) {
                List componentList = componentsEl.elements(COMPONENT);
                for (Element componentEl : componentList) {
                    String componentId = componentEl.attributeValue(ID);
                    if (componentId == null) {
                        String scope = XMLHelper.getStringData("scope", componentEl, false);
                        String region = XMLHelper.getStringData("region-id", componentEl, false);
                        String source = XMLHelper.getStringData("source-id", componentEl, false);
                        componentId = RenderUtil.generateComponentId(scope, region, source);
                    }
                    if (componentId != null) {
                        AdvancedComponentImpl advancedComponent = new AdvancedComponentImpl(componentId, this.key, (Document)new DefaultDocument((Element)new BaseElement("dummy")));
                        advancedComponent.applyConfig(componentEl);
                        this.advancedComponents.put(componentId, advancedComponent);
                        continue;
                    }
                    if (!logger.isErrorEnabled()) continue;
                    logger.error((Object)("A <component> element was found with no identification in <module> '" + this.id + "'"));
                }
            }
        } else if (logger.isErrorEnabled()) {
            logger.error((Object)"A <module> was found with no identification");
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isAutoDeploy() {
        return this.autoDeploy;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEvaluator() {
        return this.evaluator;
    }

    public Map<String, String> getEvaluatorProperties() {
        return this.evaluatorProperties;
    }

    public List<Customization> getCustomizations() {
        return this.customizations;
    }

    public HashMap<String, AdvancedComponent> getAdvancedComponents() {
        return this.advancedComponents;
    }
}

