/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.uri;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.webscripts.UriTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriTemplateListIndex {
    private List<UriTemplate> uriTemplates;

    public UriTemplateListIndex(List<UriTemplate> uriTemplates) {
        this.uriTemplates = uriTemplates;
    }

    public UriTemplateListIndex(ConfigElement config) {
        List uriElements = config.getChildren("uri-template");
        if (uriElements != null) {
            this.uriTemplates = new ArrayList<UriTemplate>(uriElements.size());
            for (ConfigElement uriElement : uriElements) {
                String template = uriElement.getValue();
                if (template == null || template.trim().length() == 0) {
                    throw new IllegalArgumentException("<uri-template> config element must contain a value.");
                }
                UriTemplate uriTemplate = new UriTemplate(template);
                this.uriTemplates.add(uriTemplate);
            }
        } else {
            this.uriTemplates = Collections.emptyList();
        }
    }

    public Map<String, String> findMatch(String uri) {
        UriTemplate template;
        Map match = null;
        Iterator<UriTemplate> i$ = this.uriTemplates.iterator();
        while (i$.hasNext() && (match = (template = i$.next()).match(uri)) == null) {
        }
        return match;
    }
}

