/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.uri;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.extensions.webscripts.URLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UriUtils {
    private static Log logger = LogFactory.getLog(UriUtils.class);
    public static Pattern pattern = Pattern.compile("\\{[A-Za-z0-9_\\-]*\\}");
    private static Pattern URI_PATTERN = Pattern.compile("^(?:(?![^:@]+:[^:@/]*@)([^:/?#.]+):)?(?://)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:/?#]*)(?::(\\d*))?)(((/(?:[^?#](?![^?#/]*\\.[^?#/.]+(?:[?#]|$)))*/?)?([^?#/]*))(?:\\?([^#]*))?(?:#(.*))?)");
    private static String[] URI_PARTS = new String[]{"source", "protocol", "authority", "userInfo", "user", "password", "host", "port", "relative", "path", "directory", "file", "query", "ref"};

    private UriUtils() {
    }

    public static List<Map<String, String>> getTokenMaps(RequestContext context) {
        ArrayList<Map<String, String>> tokenMaps = new ArrayList<Map<String, String>>();
        if (context != null) {
            TemplateInstance template;
            Page page;
            Map<String, Serializable> contextAttributes;
            Object o;
            Map<String, Object> model;
            Map<String, String> contextParams;
            Map<String, String> uriTokens = context.getUriTokens();
            if (uriTokens != null) {
                tokenMaps.add(uriTokens);
            }
            if ((contextParams = context.getParameters()) != null) {
                tokenMaps.add(contextParams);
            }
            if ((model = context.getModel()) != null && (o = model.get("url")) instanceof URLHelper) {
                Map<String, String> templateArgs;
                URLHelper urlHelper = (URLHelper)o;
                Map<String, String> urlArgs = urlHelper.getArgs();
                if (urlArgs != null) {
                    tokenMaps.add(urlArgs);
                }
                if ((templateArgs = urlHelper.getTemplateArgs()) != null) {
                    tokenMaps.add(templateArgs);
                }
            }
            if ((contextAttributes = context.getAttributes()) != null) {
                tokenMaps.add(UriUtils.convertModelObjectProps(contextAttributes));
            }
            if ((page = context.getPage()) != null && page.getCustomProperties() != null) {
                tokenMaps.add(UriUtils.convertModelObjectProps(page.getCustomProperties()));
            }
            if ((template = context.getTemplate()) != null && template.getCustomProperties() != null) {
                tokenMaps.add(UriUtils.convertModelObjectProps(template.getCustomProperties()));
            }
        }
        return tokenMaps;
    }

    private static Map<String, String> convertModelObjectProps(Map<String, Serializable> modelProps) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<String, Serializable> pageProp : modelProps.entrySet()) {
            props.put(pageProp.getKey(), pageProp.getValue() != null ? pageProp.getValue().toString() : null);
        }
        return props;
    }

    public static String replaceTokens(String s, RequestContext context) {
        StringBuffer result = new StringBuffer();
        if (s != null && context != null && s.contains("{")) {
            List<Map<String, String>> tokenMaps;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Replacing tokens in: '" + s + "'"));
            }
            if ((tokenMaps = UriUtils.getTokenMaps(context)).isEmpty()) {
                result.append(s);
            } else {
                Matcher m = pattern.matcher(s);
                while (m.find()) {
                    String group = m.group();
                    String key = group.substring(1, group.length() - 1);
                    String token = null;
                    Iterator<Map<String, String>> i = tokenMaps.iterator();
                    while (token == null && i.hasNext()) {
                        token = i.next().get(key);
                    }
                    if (token == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Could not find token for: '" + key + "'"));
                        }
                        m.appendReplacement(result, "");
                        continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Replacing token: '" + key + "' with: '" + token + "'"));
                    }
                    m.appendReplacement(result, Matcher.quoteReplacement(token));
                }
                m.appendTail(result);
            }
        } else {
            result.append(s);
        }
        return result.toString();
    }

    public static String replaceUriTokens(String s, Map<String, String> tokens) {
        int delimIndex;
        String result = s;
        int preIndex = 0;
        if (s != null && (delimIndex = s.indexOf(123)) != -1) {
            StringBuilder buf = new StringBuilder(s.length() + 16);
            do {
                buf.append(s.substring(preIndex, delimIndex));
                if (s.length() < delimIndex + 2) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Failed to replace context tokens - malformed input: " + s));
                    }
                    return s;
                }
                int endDelimIndex = s.indexOf(125, delimIndex + 2);
                if (endDelimIndex == -1) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Failed to replace context tokens - malformed input: " + s));
                    }
                    return s;
                }
                String token = s.substring(delimIndex + 1, endDelimIndex);
                String replacement = tokens.get(token);
                if (replacement == null) {
                    replacement = "";
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Replacing token '" + token + "' with: '" + replacement + "'"));
                }
                buf.append(replacement);
                preIndex = endDelimIndex + 1;
                delimIndex = s.indexOf(123, preIndex);
                if (delimIndex != -1 || s.length() <= preIndex) continue;
                buf.append(s.substring(preIndex));
            } while (delimIndex != -1);
            result = buf.toString();
        }
        return result;
    }

    public static String relativeUri(String uri) {
        HashMap<String, String> tempUri = new HashMap<String, String>(16);
        Matcher matcher = URI_PATTERN.matcher(uri);
        if (matcher.find()) {
            for (int i = 0; i < URI_PARTS.length; ++i) {
                String match;
                try {
                    match = matcher.group(i);
                }
                catch (Exception ex) {
                    match = "*";
                }
                tempUri.put(URI_PARTS[i], match == null ? "*" : match);
            }
        }
        return (String)tempUri.get("relative");
    }
}

