/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.RequestDispatchException;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.SubComponentEvaluation;
import org.springframework.extensions.surf.extensibility.impl.ExtensibilityDebugData;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.types.SubComponent;
import org.springframework.extensions.webscripts.RenderServiceFreeMarkerDirective;

public class ChromeIncludeFreeMarkerDirective
extends RenderServiceFreeMarkerDirective {
    public ChromeIncludeFreeMarkerDirective(String directiveName, RequestContext context, ModelObject object, RenderService renderService) {
        super(directiveName, context, object, renderService);
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        try {
            RequestContext context = this.getRequestContext();
            this.getRenderService().renderChromeInclude(context, this.getObject());
            if (Boolean.parseBoolean((String)((Object)context.getValue("surfBugEnabled")))) {
                this.postProcessSurfBugData(context, env);
            }
        }
        catch (RequestDispatchException e) {
            throw new TemplateException((Exception)e, env);
        }
    }

    private void postProcessSurfBugData(RequestContext context, Environment env) {
        ExtensibilityModel extModel = context.getCurrentExtensibilityModel();
        if (extModel != null && extModel.getChildDebugData() != null) {
            ExtensibilityDebugData data = extModel.getChildDebugData();
            HashMap directiveToIdToDataMap = new HashMap();
            for (String directive : data.getDirectives()) {
                HashMap idToDataMap = new HashMap();
                directiveToIdToDataMap.put(directive, idToDataMap);
                for (ExtensibilityDebugData.Data currData : data.getDirectiveData(directive)) {
                    HashMap<String, String> directiveData = new HashMap<String, String>();
                    directiveData.put("id", currData.getId());
                    directiveData.put("directive", currData.getDirective());
                    StringBuilder sources = new StringBuilder();
                    for (String source : currData.getPaths()) {
                        sources.append(source);
                        sources.append(", ");
                    }
                    if (sources.length() > 0) {
                        sources.delete(sources.lastIndexOf(","), sources.length() - 1);
                    }
                    directiveData.put("sources", sources.toString());
                    idToDataMap.put(currData.getId(), directiveData);
                }
            }
            SimpleHash model = new SimpleHash(directiveToIdToDataMap);
            env.setVariable("renderedExtensibilityArtefacts", (TemplateModel)model);
        }
        if ("tagLibSubComponentRendering".equals(context.getValue("tagLibRenderType"))) {
            RenderService.SubComponentData subComponentData = (RenderService.SubComponentData)context.getValue("sub-component");
            SubComponent.RenderData renderData = this.getRequestContext().getSubComponentDebugData(subComponentData.getSubComponent().getId());
            HashMap<String, String> renderDataMap = new HashMap<String, String>();
            if (renderData != null) {
                renderDataMap.put("Evaluated URI", renderData.getUri());
                SubComponentEvaluation evaluation = renderData.getEvaluation();
                if (evaluation != null) {
                    renderDataMap.put("Evaluated By", evaluation.getId());
                } else {
                    renderDataMap.put("Evaluated By", "");
                }
            }
            SimpleHash subCompRenderData = new SimpleHash(renderDataMap);
            env.setVariable("subCompRenderData", (TemplateModel)subCompRenderData);
            if (renderData != null) {
                SimpleHash subCompRenderProperties = new SimpleHash(renderData.getProperties());
                env.setVariable("subCompEvaluatedProps", (TemplateModel)subCompRenderProperties);
            }
        }
    }
}

