/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.LocalWebScriptContext;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.WebScriptResponseImpl;

public class LocalWebScriptResponse
extends WebScriptResponseImpl {
    private Writer out;
    private Runtime runtime;
    private LocalWebScriptContext context;
    private String scriptUrlPrefix = null;

    public LocalWebScriptResponse(Runtime runtime, LocalWebScriptContext context, Writer out) {
        super(runtime);
        this.context = context;
        this.runtime = runtime;
        this.out = out;
    }

    public String encodeScriptUrl(String url) {
        if (this.scriptUrlPrefix == null) {
            StringBuffer buf = new StringBuffer(128);
            buf.append(this.context.getRequestContext().getUri());
            boolean first = true;
            for (Map.Entry<String, String> entry : this.context.getTokens().entrySet()) {
                String key = entry.getKey();
                if ("_wsUrl".equals(key) || "_wsId".equals(key)) continue;
                String value = entry.getValue();
                buf.append(first ? (char)'?' : '&').append(key).append('=').append(URLEncoder.encode((String)value));
                first = false;
            }
            this.scriptUrlPrefix = buf.toString();
        }
        return this.scriptUrlPrefix + (this.context.getTokens().size() != 0 ? (char)'&' : '?') + "_wsUrl" + "=" + URLEncoder.encode((String)url) + "&" + "_wsId" + "=" + this.context.getModelObject().getId();
    }

    public String getEncodeScriptUrlFunction(String name) {
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public Writer getWriter() throws IOException {
        return this.out;
    }

    public void reset() {
    }

    public void setCache(Cache cache) {
    }

    public void setHeader(String name, String value) {
    }

    public void addHeader(String name, String value) {
    }

    public void setContentType(String contentType) {
    }

    public void setContentEncoding(String contentEncoding) {
    }

    public void setStatus(int status) {
    }
}

