/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.impl.ModelWriter;
import org.springframework.extensions.surf.render.AbstractProcessor;
import org.springframework.extensions.surf.render.ProcessorContext;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.extensions.surf.util.DataUtil;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.ScriptProcessor;
import org.springframework.extensions.webscripts.ScriptProcessorRegistry;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.extensions.webscripts.TemplateProcessorRegistry;
import org.springframework.extensions.webscripts.WebScriptException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebTemplateProcessor
extends AbstractProcessor {
    private static final Log logger = LogFactory.getLog(WebTemplateProcessor.class);
    public static final String PREFIX_CLASSPATH = "classpath:";
    private static final String SCRIPT_RESULTS = "webTemplateRendererScriptResults";
    private TemplateProcessorRegistry templateProcessorRegistry;
    private ScriptProcessorRegistry scriptProcessorRegistry;
    private Map<String, Object> scriptObjects;
    private Map<String, String> templateScripts = new ConcurrentHashMap<String, String>(256);
    private static final String TEMPLATE_URIPATH_SENTINEL = "<none>";
    private WebFrameworkConfigElement webFrameworkConfigElement;

    public void setWebFrameworkConfigElement(WebFrameworkConfigElement webFrameworkConfigElement) {
        this.webFrameworkConfigElement = webFrameworkConfigElement;
    }

    public void setTemplateProcessorRegistry(TemplateProcessorRegistry templateProcessorRegistry) {
        this.templateProcessorRegistry = templateProcessorRegistry;
    }

    public TemplateProcessorRegistry getTemplateProcessorRegistry() {
        return this.templateProcessorRegistry;
    }

    public void setScriptProcessorRegistry(ScriptProcessorRegistry scriptProcessorRegistry) {
        this.scriptProcessorRegistry = scriptProcessorRegistry;
    }

    public ScriptProcessorRegistry getScriptProcessorRegistry() {
        return this.scriptProcessorRegistry;
    }

    public void setScriptObjects(Map<String, Object> scriptObjects) {
        this.scriptObjects = scriptObjects;
    }

    @Override
    public void executeHeader(ProcessorContext pc, ModelObject object) throws RendererExecutionException {
        RequestContext context = pc.getRequestContext();
        String uri = this.getProperty(pc, "uri");
        String templatePath = this.getProperty(pc, "template-path");
        String format = context.getFormatId();
        if (uri != null) {
            StringBuilder templateName = new StringBuilder(uri);
            int extensionIndex = templateName.lastIndexOf(".");
            String defaultFormat = this.webFrameworkConfigElement.getDefaultFormatId();
            if (format != null && format.length() > 0 && !format.equals(defaultFormat)) {
                templateName.delete(extensionIndex, templateName.length());
                templateName.append(".head.");
                templateName.append(format);
            } else {
                templateName.insert(extensionIndex, ".head");
            }
            String validTemplatePath = this.getTemplateProcessorRegistry().findValidTemplatePath(templateName.toString());
            if (validTemplatePath != null) {
                try {
                    HashMap<String, Object> model = new HashMap<String, Object>(32);
                    this.processorModelHelper.populateTemplateModel(context, model, object);
                    TemplateProcessor templateProcessor = this.getTemplateProcessorRegistry().getTemplateProcessor(validTemplatePath);
                    templateProcessor.process(validTemplatePath, model, (Writer)context.getResponse().getWriter());
                }
                catch (UnsupportedEncodingException uee) {
                    throw new RendererExecutionException(uee);
                }
                catch (IOException ioe) {
                    throw new RendererExecutionException(ioe);
                }
            }
        } else if (templatePath != null) {
            String templateString = null;
            try {
                templateString = this.loadTemplateStringFromPath(templatePath);
                HashMap<String, Object> model = new HashMap<String, Object>(32);
                this.processorModelHelper.populateTemplateModel(context, model, object);
                TemplateProcessor templateProcessor = this.getTemplateProcessorRegistry().getTemplateProcessorByExtension("ftl");
                templateProcessor.processString(templateString, model, (Writer)context.getResponse().getWriter());
            }
            catch (UnsupportedEncodingException uee) {
                throw new RendererExecutionException(uee);
            }
            catch (IOException ioe) {
                throw new RendererExecutionException(ioe);
            }
        }
    }

    public void executeScriptBodyExtensions(RequestContext context, String scriptPath, Map<String, Object> scriptModel, Map<String, Object> resultModel, ModelObject object) {
        for (String moduleScriptPath : context.getExtendingModuleFiles(scriptPath)) {
            String validExtScriptPath = this.getScriptProcessorRegistry().findValidScriptPath(moduleScriptPath);
            if (validExtScriptPath == null) continue;
            ScriptProcessor scriptProcessor = this.getScriptProcessorRegistry().getScriptProcessor(validExtScriptPath);
            ScriptContent scriptContent = scriptProcessor.findScript(validExtScriptPath);
            if (scriptModel == null) {
                scriptModel = this.buildScriptModel(context, object, resultModel);
            }
            scriptProcessor.executeScript(scriptContent, scriptModel);
        }
    }

    private Map<String, Object> buildScriptModel(RequestContext context, ModelObject object, Map<String, Object> resultModel) {
        HashMap<String, Object> scriptModel = new HashMap<String, Object>(32);
        this.processorModelHelper.populateScriptModel(context, scriptModel, object);
        if (this.scriptObjects != null) {
            scriptModel.putAll(this.scriptObjects);
        }
        scriptModel.put("model", resultModel);
        return scriptModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBody(ProcessorContext pc, ModelObject object) throws RendererExecutionException {
        RequestContext context = pc.getRequestContext();
        String uri = this.getProperty(pc, "uri");
        String templatePath = this.getProperty(pc, "template-path");
        String format = context.getFormatId();
        ExtensibilityModel extModel = context.openExtensibilityModel();
        extModel.addUnboundContent();
        PrintWriter writer = null;
        try {
            ScriptProcessor scriptProcessor;
            String validScriptPath;
            writer = context.getResponse().getWriter();
            HashMap<String, Object> resultModel = null;
            if (object instanceof TemplateInstance) {
                if (!context.hasValue(SCRIPT_RESULTS)) {
                    resultModel = new HashMap<String, Object>(4, 1.0f);
                    boolean scriptExecuted = false;
                    if (uri != null) {
                        validScriptPath = this.findValidScriptPath(uri);
                        if (validScriptPath != null) {
                            scriptProcessor = this.getScriptProcessorRegistry().getScriptProcessor(validScriptPath);
                            ScriptContent script = scriptProcessor.findScript(validScriptPath);
                            if (script != null) {
                                Map<String, Object> scriptModel = this.buildScriptModel(context, object, resultModel);
                                try {
                                    scriptProcessor.executeScript(script, scriptModel);
                                    this.executeScriptBodyExtensions(context, validScriptPath, scriptModel, resultModel, object);
                                    scriptExecuted = true;
                                }
                                catch (WebScriptException we) {
                                    throw new RendererExecutionException((Exception)((Object)we));
                                }
                            }
                        } else {
                            this.executeScriptBodyExtensions(context, uri, null, resultModel, object);
                            scriptExecuted = true;
                        }
                        if (scriptExecuted && context.isPassiveMode()) {
                            context.setValue(SCRIPT_RESULTS, resultModel);
                        }
                    }
                } else {
                    resultModel = (HashMap<String, Object>)context.getValue(SCRIPT_RESULTS);
                }
            }
            HashMap<String, Object> templateModel = new HashMap<String, Object>(32, 1.0f);
            this.processorModelHelper.populateTemplateModel(context, templateModel, object);
            if (resultModel != null && (validScriptPath = this.findValidScriptPath(uri)) != null) {
                scriptProcessor = this.getScriptProcessorRegistry().getScriptProcessor(validScriptPath);
                for (Map.Entry entry : resultModel.entrySet()) {
                    Object value = entry.getValue();
                    Object templateValue = scriptProcessor.unwrapValue(value);
                    templateModel.put((String)entry.getKey(), templateValue);
                }
            }
            TemplateProcessor templateProcessor = null;
            String validTemplatePath = null;
            if (uri != null) {
                if (format != null && format.length() != 0 && !this.webFrameworkConfigElement.getDefaultFormatId().equals(format)) {
                    validTemplatePath = this.getTemplateProcessorRegistry().findValidTemplatePath(uri + "." + format);
                }
                if (validTemplatePath == null) {
                    validTemplatePath = this.getTemplateProcessorRegistry().findValidTemplatePath(uri);
                }
                if (validTemplatePath != null) {
                    templateProcessor = this.getTemplateProcessorRegistry().getTemplateProcessor(validTemplatePath);
                } else {
                    logger.warn((Object)("Unable to find a valid template path for uri: " + uri));
                }
            } else if (templatePath != null) {
                validTemplatePath = this.loadTemplateStringFromPath(templatePath);
                templateProcessor = this.getTemplateProcessorRegistry().getTemplateProcessorByExtension("ftl");
            } else {
                logger.warn((Object)"No valid template path or uri to resolve template!");
            }
            if (templateProcessor != null && validTemplatePath != null) {
                if (!context.isPassiveMode()) {
                    String dependencies = context.getExtendingModuleDependencies(validTemplatePath, templateModel);
                    String currentHead = (String)templateModel.get("head");
                    if (currentHead == null) {
                        templateModel.put("head", dependencies);
                    } else {
                        currentHead = currentHead + dependencies;
                        templateModel.put("head", currentHead);
                    }
                }
                ModelWriter extModelWriter = extModel.getWriter();
                context.setFileBeingProcessed(validTemplatePath);
                templateProcessor.process(validTemplatePath, templateModel, (Writer)extModelWriter);
                extModel.switchToExtensionProcessing();
                for (String moduleTemplatePath : context.getExtendingModuleFiles(validTemplatePath)) {
                    String modulePath = this.getTemplateProcessorRegistry().findValidTemplatePath(moduleTemplatePath);
                    if (modulePath == null) continue;
                    context.setFileBeingProcessed(modulePath);
                    templateProcessor.process(modulePath, templateModel, (Writer)extModelWriter);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof RendererExecutionException) {
                throw (RendererExecutionException)ex;
            }
            if (uri != null) {
                throw new RendererExecutionException("WebTemplateProcessor failed to process template uri: " + uri, ex);
            }
            if (templatePath != null) {
                throw new RendererExecutionException("WebTemplateProcessor failed to process template path: " + templatePath, ex);
            }
        }
        finally {
            context.closeExtensibilityModel(extModel, writer);
        }
    }

    private String findValidScriptPath(String uri) {
        String validScriptPath = this.templateScripts.get(uri);
        if (validScriptPath == null) {
            validScriptPath = this.getScriptProcessorRegistry().findValidScriptPath(uri);
            if (validScriptPath != null) {
                this.templateScripts.put(uri, validScriptPath);
            } else {
                this.templateScripts.put(uri, TEMPLATE_URIPATH_SENTINEL);
            }
        }
        if (validScriptPath == TEMPLATE_URIPATH_SENTINEL) {
            validScriptPath = null;
        }
        return validScriptPath;
    }

    @Override
    public boolean exists(ProcessorContext pc, ModelObject object) {
        RequestContext context = pc.getRequestContext();
        String uri = this.getProperty(pc, "uri");
        String format = context.getFormatId();
        String validTemplatePath = null;
        if (format != null && format.length() != 0 && !this.webFrameworkConfigElement.getDefaultFormatId().equals(format)) {
            validTemplatePath = this.getTemplateProcessorRegistry().findValidTemplatePath(uri + "." + format);
        }
        if (validTemplatePath == null) {
            validTemplatePath = this.getTemplateProcessorRegistry().findValidTemplatePath(uri);
        }
        return validTemplatePath != null;
    }

    protected String loadTemplateStringFromPath(String templatePath) throws IOException {
        String templateString = null;
        if (templatePath.startsWith(PREFIX_CLASSPATH)) {
            templatePath = templatePath.substring(10);
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(templatePath);
            templateString = DataUtil.copyToString(is, null, true);
        }
        return templateString;
    }
}

