/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.alfresco.solr.AclReport;
import org.alfresco.solr.NodeReport;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.tracker.CoreTracker;
import org.alfresco.solr.tracker.CoreWatcherJob;
import org.alfresco.solr.tracker.IndexHealthReport;
import org.alfresco.util.CachingDateFormat;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.json.JSONException;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfrescoCoreAdminHandler
extends CoreAdminHandler {
    protected static final Logger log = LoggerFactory.getLogger(AlfrescoCoreAdminHandler.class);
    Scheduler scheduler = null;
    ConcurrentHashMap<String, CoreTracker> trackers = new ConcurrentHashMap();

    public AlfrescoCoreAdminHandler() {
    }

    public AlfrescoCoreAdminHandler(CoreContainer coreContainer) {
        super(coreContainer);
        try {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            Properties properties = new Properties();
            properties.setProperty("org.quartz.scheduler.instanceName", "SolrTrackerScheduler");
            properties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
            properties.setProperty("org.quartz.threadPool.threadCount", "3");
            properties.setProperty("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
            factory.initialize(properties);
            this.scheduler = factory.getScheduler();
            this.scheduler.start();
            JobDetail job = new JobDetail("CoreWatcher", "Solr", CoreWatcherJob.class);
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put((Object)"ADMIN_HANDLER", (Object)this);
            job.setJobDataMap(jobDataMap);
            try {
                CronTrigger trigger = new CronTrigger("CoreWatcherTrigger", "Solr", "0/20 * * * * ? *");
                this.scheduler.scheduleJob(job, (Trigger)trigger);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public ConcurrentHashMap<String, CoreTracker> getTrackers() {
        return this.trackers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleCustomAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        String a = params.get("action");
        try {
            if (a.equalsIgnoreCase("CHECK")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    if (tracker == null) return false;
                    tracker.setCheck(true);
                    return false;
                } else {
                    for (String trackerName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(trackerName);
                        tracker.setCheck(true);
                    }
                }
                return false;
            }
            if (a.equalsIgnoreCase("NODEREPORT")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    Long dbid = null;
                    if (params.get("dbid") == null) throw new AlfrescoRuntimeException("No dbid parameter set");
                    dbid = Long.valueOf(params.get("dbid"));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    report.add(cname, this.buildNodeReport(tracker, dbid));
                    rsp.add("report", (Object)report);
                    return false;
                } else {
                    Long dbid = null;
                    if (params.get("dbid") == null) throw new AlfrescoRuntimeException("No dbid parameter set");
                    dbid = Long.valueOf(params.get("dbid"));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    for (String trackerName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(trackerName);
                        report.add(trackerName, this.buildNodeReport(tracker, dbid));
                    }
                    rsp.add("report", (Object)report);
                }
                return false;
            }
            if (a.equalsIgnoreCase("ACLREPORT")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    Long aclid = null;
                    if (params.get("aclid") == null) throw new AlfrescoRuntimeException("No aclid parameter set");
                    aclid = Long.valueOf(params.get("aclid"));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    report.add(cname, this.buildAclReport(tracker, aclid));
                    rsp.add("report", (Object)report);
                    return false;
                } else {
                    Long aclid = null;
                    if (params.get("aclid") == null) throw new AlfrescoRuntimeException("No dbid parameter set");
                    aclid = Long.valueOf(params.get("aclid"));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    for (String trackerName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(trackerName);
                        report.add(trackerName, this.buildAclReport(tracker, aclid));
                    }
                    rsp.add("report", (Object)report);
                }
                return false;
            }
            if (a.equalsIgnoreCase("TXREPORT")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    Long txid = null;
                    if (params.get("txid") == null) throw new AlfrescoRuntimeException("No txid parameter set");
                    txid = Long.valueOf(params.get("txid"));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    report.add(cname, this.buildTxReport(tracker, txid));
                    rsp.add("report", (Object)report);
                    return false;
                } else {
                    Long txid = null;
                    if (params.get("txid") == null) throw new AlfrescoRuntimeException("No txid parameter set");
                    txid = Long.valueOf(params.get("txid"));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    for (String trackerName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(trackerName);
                        report.add(trackerName, this.buildTxReport(tracker, txid));
                    }
                    rsp.add("report", (Object)report);
                }
                return false;
            }
            if (a.equalsIgnoreCase("ACLTXREPORT")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    Long acltxid = null;
                    if (params.get("acltxid") == null) throw new AlfrescoRuntimeException("No acltxid parameter set");
                    acltxid = Long.valueOf(params.get("acltxid"));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    report.add(cname, this.buildAclTxReport(tracker, acltxid));
                    rsp.add("report", (Object)report);
                    return false;
                } else {
                    Long acltxid = null;
                    if (params.get("acltxid") == null) throw new AlfrescoRuntimeException("No acltxid parameter set");
                    acltxid = Long.valueOf(params.get("acltxid"));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    for (String trackerName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(trackerName);
                        report.add(trackerName, this.buildAclTxReport(tracker, acltxid));
                    }
                    rsp.add("report", (Object)report);
                }
                return false;
            }
            if (a.equalsIgnoreCase("REPORT")) {
                if (cname != null) {
                    Long fromTime = null;
                    if (params.get("fromTime") != null) {
                        fromTime = Long.valueOf(params.get("fromTime"));
                    }
                    Long toTime = null;
                    if (params.get("toTime") != null) {
                        toTime = Long.valueOf(params.get("toTime"));
                    }
                    Long fromTx = null;
                    if (params.get("fromTx") != null) {
                        fromTx = Long.valueOf(params.get("fromTx"));
                    }
                    Long toTx = null;
                    if (params.get("toTx") != null) {
                        toTx = Long.valueOf(params.get("toTx"));
                    }
                    Long fromAclTx = null;
                    if (params.get("fromAclTx") != null) {
                        fromAclTx = Long.valueOf(params.get("fromAclTx"));
                    }
                    Long toAclTx = null;
                    if (params.get("toAclTx") != null) {
                        toAclTx = Long.valueOf(params.get("toAclTx"));
                    }
                    CoreTracker tracker = this.trackers.get(cname);
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    if (tracker != null) {
                        report.add(cname, this.buildTrackerReport(tracker, fromTx, toTx, fromAclTx, toAclTx, fromTime, toTime));
                    } else {
                        report.add(cname, (Object)"Core unknown");
                    }
                    rsp.add("report", (Object)report);
                    return false;
                } else {
                    Long fromTime = null;
                    if (params.get("fromTime") != null) {
                        fromTime = Long.valueOf(params.get("fromTime"));
                    }
                    Long toTime = null;
                    if (params.get("toTime") != null) {
                        toTime = Long.valueOf(params.get("toTime"));
                    }
                    Long fromTx = null;
                    if (params.get("fromTx") != null) {
                        fromTx = Long.valueOf(params.get("fromTx"));
                    }
                    Long toTx = null;
                    if (params.get("toTx") != null) {
                        toTx = Long.valueOf(params.get("toTx"));
                    }
                    Long fromAclTx = null;
                    if (params.get("fromAclTx") != null) {
                        fromAclTx = Long.valueOf(params.get("fromAclTx"));
                    }
                    Long toAclTx = null;
                    if (params.get("toAclTx") != null) {
                        toAclTx = Long.valueOf(params.get("toAclTx"));
                    }
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    for (String coreName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(coreName);
                        report.add(coreName, this.buildTrackerReport(tracker, fromTx, toTx, fromAclTx, toAclTx, fromTime, toTime));
                    }
                    rsp.add("report", (Object)report);
                }
                return false;
            }
            if (a.equalsIgnoreCase("PURGE")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    if (params.get("txid") != null) {
                        Long txid = Long.valueOf(params.get("txid"));
                        tracker.addTransactionToPurge(txid);
                    }
                    if (params.get("acltxid") != null) {
                        Long acltxid = Long.valueOf(params.get("acltxid"));
                        tracker.addAclChangeSetToPurge(acltxid);
                    }
                    if (params.get("nodeid") != null) {
                        Long nodeid = Long.valueOf(params.get("nodeid"));
                        tracker.addNodeToPurge(nodeid);
                    }
                    if (params.get("aclid") == null) return false;
                    Long aclid = Long.valueOf(params.get("aclid"));
                    tracker.addAclToPurge(aclid);
                    return false;
                } else {
                    for (String coreName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(coreName);
                        if (params.get("txid") != null) {
                            Long txid = Long.valueOf(params.get("txid"));
                            tracker.addTransactionToPurge(txid);
                        }
                        if (params.get("acltxid") != null) {
                            Long acltxid = Long.valueOf(params.get("acltxid"));
                            tracker.addAclChangeSetToPurge(acltxid);
                        }
                        if (params.get("nodeid") != null) {
                            Long nodeid = Long.valueOf(params.get("nodeid"));
                            tracker.addNodeToPurge(nodeid);
                        }
                        if (params.get("aclid") == null) continue;
                        Long aclid = Long.valueOf(params.get("aclid"));
                        tracker.addAclToPurge(aclid);
                    }
                }
                return false;
            }
            if (a.equalsIgnoreCase("REINDEX")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    if (params.get("txid") != null) {
                        Long txid = Long.valueOf(params.get("txid"));
                        tracker.addTransactionToReindex(txid);
                    }
                    if (params.get("acltxid") != null) {
                        Long acltxid = Long.valueOf(params.get("acltxid"));
                        tracker.addAclChangeSetToReindex(acltxid);
                    }
                    if (params.get("nodeid") != null) {
                        Long nodeid = Long.valueOf(params.get("nodeid"));
                        tracker.addNodeToReindex(nodeid);
                    }
                    if (params.get("aclid") == null) return false;
                    Long aclid = Long.valueOf(params.get("aclid"));
                    tracker.addAclToReindex(aclid);
                    return false;
                } else {
                    for (String coreName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(coreName);
                        if (params.get("txid") != null) {
                            Long txid = Long.valueOf(params.get("txid"));
                            tracker.addTransactionToReindex(txid);
                        }
                        if (params.get("acltxid") != null) {
                            Long acltxid = Long.valueOf(params.get("acltxid"));
                            tracker.addAclChangeSetToReindex(acltxid);
                        }
                        if (params.get("nodeid") != null) {
                            Long nodeid = Long.valueOf(params.get("nodeid"));
                            tracker.addNodeToReindex(nodeid);
                        }
                        if (params.get("aclid") == null) continue;
                        Long aclid = Long.valueOf(params.get("aclid"));
                        tracker.addAclToReindex(aclid);
                    }
                }
                return false;
            }
            if (a.equalsIgnoreCase("INDEX")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    if (params.get("txid") != null) {
                        Long txid = Long.valueOf(params.get("txid"));
                        tracker.addTransactionToIndex(txid);
                    }
                    if (params.get("acltxid") != null) {
                        Long acltxid = Long.valueOf(params.get("acltxid"));
                        tracker.addAclChangeSetToIndex(acltxid);
                    }
                    if (params.get("nodeid") != null) {
                        Long nodeid = Long.valueOf(params.get("nodeid"));
                        tracker.addNodeToIndex(nodeid);
                    }
                    if (params.get("aclid") == null) return false;
                    Long aclid = Long.valueOf(params.get("aclid"));
                    tracker.addAclToIndex(aclid);
                    return false;
                } else {
                    for (String coreName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(coreName);
                        if (params.get("txid") != null) {
                            Long txid = Long.valueOf(params.get("txid"));
                            tracker.addTransactionToIndex(txid);
                        }
                        if (params.get("acltxid") != null) {
                            Long acltxid = Long.valueOf(params.get("acltxid"));
                            tracker.addAclChangeSetToIndex(acltxid);
                        }
                        if (params.get("nodeid") != null) {
                            Long nodeid = Long.valueOf(params.get("nodeid"));
                            tracker.addNodeToIndex(nodeid);
                        }
                        if (params.get("aclid") == null) continue;
                        Long aclid = Long.valueOf(params.get("aclid"));
                        tracker.addAclToIndex(aclid);
                    }
                }
                return false;
            }
            if (a.equalsIgnoreCase("FIX")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    IndexHealthReport indexHealthReport = tracker.checkIndex(null, null, null, null, null, null);
                    OpenBitSet toReindex = indexHealthReport.getTxInIndexButNotInDb();
                    toReindex.or(indexHealthReport.getDuplicatedTxInIndex());
                    toReindex.or(indexHealthReport.getMissingTxFromIndex());
                    long current = -1L;
                    while ((current = toReindex.nextSetBit(current + 1L)) != -1L) {
                        tracker.addTransactionToReindex(current);
                    }
                    toReindex = indexHealthReport.getAclTxInIndexButNotInDb();
                    toReindex.or(indexHealthReport.getDuplicatedAclTxInIndex());
                    toReindex.or(indexHealthReport.getMissingAclTxFromIndex());
                    current = -1L;
                    while ((current = toReindex.nextSetBit(current + 1L)) != -1L) {
                        tracker.addAclChangeSetToReindex(current);
                    }
                    return false;
                } else {
                    for (String coreName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(coreName);
                        IndexHealthReport indexHealthReport = tracker.checkIndex(null, null, null, null, null, null);
                        OpenBitSet toReindex = indexHealthReport.getTxInIndexButNotInDb();
                        toReindex.or(indexHealthReport.getDuplicatedTxInIndex());
                        toReindex.or(indexHealthReport.getMissingTxFromIndex());
                        long current = -1L;
                        while ((current = toReindex.nextSetBit(current + 1L)) != -1L) {
                            tracker.addTransactionToReindex(current);
                        }
                        toReindex = indexHealthReport.getAclTxInIndexButNotInDb();
                        toReindex.or(indexHealthReport.getDuplicatedAclTxInIndex());
                        toReindex.or(indexHealthReport.getMissingAclTxFromIndex());
                        current = -1L;
                        while ((current = toReindex.nextSetBit(current + 1L)) != -1L) {
                            tracker.addAclChangeSetToReindex(current);
                        }
                    }
                }
                return false;
            }
            if (!a.equalsIgnoreCase("SUMMARY")) return super.handleCustomAction(req, rsp);
            if (cname != null) {
                CoreTracker tracker = this.trackers.get(cname);
                SimpleOrderedMap report = new SimpleOrderedMap();
                if (tracker != null) {
                    SimpleOrderedMap coreSummary = new SimpleOrderedMap();
                    long lastIndexCommitTime = tracker.getLastIndexedCommitTime();
                    long lastTxOnServer = tracker.getLastTxOnServer();
                    Date lastIndexCommitDate = new Date(lastIndexCommitTime);
                    Date lastTxOnServerDate = new Date(lastTxOnServer);
                    Duration lag = new Duration(lastIndexCommitDate, lastTxOnServerDate);
                    coreSummary.add("Last Index Commit Time", (Object)lastIndexCommitTime);
                    coreSummary.add("Last Index Commit Date", (Object)lastIndexCommitDate);
                    coreSummary.add("Lag", (Object)((lastTxOnServer - lastIndexCommitTime) / 1000L + " s"));
                    coreSummary.add("Duration", (Object)lag.toString());
                    coreSummary.add("Active", (Object)tracker.isRunning());
                    coreSummary.add("Timestamp for last TX on server", (Object)lastTxOnServer);
                    coreSummary.add("Date for last TX on server", (Object)lastTxOnServerDate);
                    report.add(cname, (Object)coreSummary);
                } else {
                    report.add(cname, (Object)"Core unknown");
                }
                rsp.add("Summary", (Object)report);
                return false;
            } else {
                SimpleOrderedMap report = new SimpleOrderedMap();
                for (String coreName : this.trackers.keySet()) {
                    CoreTracker tracker = this.trackers.get(coreName);
                    if (tracker != null) {
                        SimpleOrderedMap coreSummary = new SimpleOrderedMap();
                        long lastIndexCommitTime = tracker.getLastIndexedCommitTime();
                        long lastTxOnServer = tracker.getLastTxOnServer();
                        Date lastIndexCommitDate = new Date(lastIndexCommitTime);
                        Date lastTxOnServerDate = new Date(lastTxOnServer);
                        Duration lag = new Duration(lastIndexCommitDate, lastTxOnServerDate);
                        coreSummary.add("Last Index Commit Time", (Object)lastIndexCommitTime);
                        coreSummary.add("Last Index Commit Date", (Object)lastIndexCommitDate);
                        coreSummary.add("Lag", (Object)((lastTxOnServer - lastIndexCommitTime) / 1000L + " s"));
                        coreSummary.add("Duration", (Object)lag.toString());
                        coreSummary.add("Active", (Object)tracker.isRunning());
                        coreSummary.add("Timestamp for last TX on server", (Object)lastTxOnServer);
                        coreSummary.add("Date for last TX on server", (Object)lastTxOnServerDate);
                        report.add(coreName, (Object)coreSummary);
                        continue;
                    }
                    report.add(cname, (Object)"Core unknown");
                }
                rsp.add("Summary", (Object)report);
            }
            return false;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error executing implementation of admin request " + a, (Throwable)ex);
        }
    }

    private NamedList<Object> buildAclTxReport(CoreTracker tracker, Long acltxid) throws AuthenticationException, IOException, JSONException {
        SimpleOrderedMap nr = new SimpleOrderedMap();
        nr.add("TXID", (Object)acltxid);
        nr.add("transaction", this.buildTrackerReport(tracker, 0L, 0L, acltxid, acltxid, null, null));
        SimpleOrderedMap nodes = new SimpleOrderedMap();
        List<Long> dbAclIds = tracker.getAclsForDbAclTransaction(acltxid);
        for (Long aclid : dbAclIds) {
            nodes.add("ACLID " + aclid, this.buildAclReport(tracker, aclid));
        }
        nr.add("aclTxDbAclCount", (Object)dbAclIds.size());
        nr.add("nodes", (Object)nodes);
        return nr;
    }

    private NamedList<Object> buildAclReport(CoreTracker tracker, Long aclid) throws IOException, JSONException {
        AclReport aclReport = tracker.checkAcl(aclid);
        SimpleOrderedMap nr = new SimpleOrderedMap();
        nr.add("Acl Id", (Object)aclReport.getAclId());
        nr.add("Acl doc in index", (Object)aclReport.getIndexAclDoc());
        if (aclReport.getIndexAclDoc() != null) {
            nr.add("Acl tx in Index", (Object)aclReport.getIndexAclTx());
        }
        return nr;
    }

    private NamedList<Object> buildTxReport(CoreTracker tracker, Long txid) throws AuthenticationException, IOException, JSONException {
        SimpleOrderedMap nr = new SimpleOrderedMap();
        nr.add("TXID", (Object)txid);
        nr.add("transaction", this.buildTrackerReport(tracker, txid, txid, 0L, 0L, null, null));
        SimpleOrderedMap nodes = new SimpleOrderedMap();
        List<Node> dbNodes = tracker.getFullNodesForDbTransaction(txid);
        for (Node node : dbNodes) {
            nodes.add("DBID " + node.getId(), this.buildNodeReport(tracker, node));
        }
        nr.add("txDbNodeCount", (Object)dbNodes.size());
        nr.add("nodes", (Object)nodes);
        return nr;
    }

    private NamedList<Object> buildNodeReport(CoreTracker tracker, Node node) throws IOException, JSONException {
        NodeReport nodeReport = tracker.checkNode(node);
        SimpleOrderedMap nr = new SimpleOrderedMap();
        nr.add("Node DBID", (Object)nodeReport.getDbid());
        nr.add("DB TX", (Object)nodeReport.getDbTx());
        nr.add("DB TX status", (Object)nodeReport.getDbNodeStatus().toString());
        nr.add("Leaf doc in Index", (Object)nodeReport.getIndexLeafDoc());
        nr.add("Aux doc in Index", (Object)nodeReport.getIndexAuxDoc());
        if (nodeReport.getIndexLeafDoc() != null) {
            nr.add("Leaf tx in Index", (Object)nodeReport.getIndexLeafTx());
        }
        if (nodeReport.getIndexAuxDoc() != null) {
            nr.add("Aux tx in Index", (Object)nodeReport.getIndexAuxTx());
        }
        return nr;
    }

    private NamedList<Object> buildNodeReport(CoreTracker tracker, Long dbid) throws IOException, JSONException {
        NodeReport nodeReport = tracker.checkNode(dbid);
        SimpleOrderedMap nr = new SimpleOrderedMap();
        nr.add("Node DBID", (Object)nodeReport.getDbid());
        nr.add("DB TX", (Object)nodeReport.getDbTx());
        nr.add("DB TX status", (Object)nodeReport.getDbNodeStatus().toString());
        nr.add("Leaf doc in Index", (Object)nodeReport.getIndexLeafDoc());
        nr.add("Aux doc in Index", (Object)nodeReport.getIndexAuxDoc());
        if (nodeReport.getIndexLeafDoc() != null) {
            nr.add("Leaf tx in Index", (Object)nodeReport.getIndexLeafTx());
        }
        if (nodeReport.getIndexAuxDoc() != null) {
            nr.add("Aux tx in Index", (Object)nodeReport.getIndexAuxTx());
        }
        return nr;
    }

    private NamedList<Object> buildTrackerReport(CoreTracker tracker, Long fromTx, Long toTx, Long fromAclTx, Long toAclTx, Long fromTime, Long toTime) throws IOException, JSONException, AuthenticationException {
        IndexHealthReport indexHealthReport = tracker.checkIndex(fromTx, toTx, fromAclTx, toAclTx, fromTime, toTime);
        SimpleOrderedMap ihr = new SimpleOrderedMap();
        ihr.add("DB transaction count", (Object)indexHealthReport.getDbTransactionCount());
        ihr.add("DB acl transaction count", (Object)indexHealthReport.getDbAclTransactionCount());
        ihr.add("Count of duplicated transactions in the index", (Object)indexHealthReport.getDuplicatedTxInIndex().cardinality());
        if (indexHealthReport.getDuplicatedTxInIndex().cardinality() > 0L) {
            ihr.add("First duplicate", (Object)indexHealthReport.getDuplicatedTxInIndex().nextSetBit(0L));
        }
        ihr.add("Count of duplicated acl transactions in the index", (Object)indexHealthReport.getDuplicatedAclTxInIndex().cardinality());
        if (indexHealthReport.getDuplicatedAclTxInIndex().cardinality() > 0L) {
            ihr.add("First duplicate acl tx", (Object)indexHealthReport.getDuplicatedAclTxInIndex().nextSetBit(0L));
        }
        ihr.add("Count of transactions in the index but not the DB", (Object)indexHealthReport.getTxInIndexButNotInDb().cardinality());
        if (indexHealthReport.getTxInIndexButNotInDb().cardinality() > 0L) {
            ihr.add("First transaction in the index but not the DB", (Object)indexHealthReport.getTxInIndexButNotInDb().nextSetBit(0L));
        }
        ihr.add("Count of acl transactions in the index but not the DB", (Object)indexHealthReport.getAclTxInIndexButNotInDb().cardinality());
        if (indexHealthReport.getAclTxInIndexButNotInDb().cardinality() > 0L) {
            ihr.add("First acl transaction in the index but not the DB", (Object)indexHealthReport.getAclTxInIndexButNotInDb().nextSetBit(0L));
        }
        ihr.add("Count of missing transactions from the Index", (Object)indexHealthReport.getMissingTxFromIndex().cardinality());
        if (indexHealthReport.getMissingTxFromIndex().cardinality() > 0L) {
            ihr.add("First transaction missing from the Index", (Object)indexHealthReport.getMissingTxFromIndex().nextSetBit(0L));
        }
        ihr.add("Count of missing acl transactions from the Index", (Object)indexHealthReport.getMissingAclTxFromIndex().cardinality());
        if (indexHealthReport.getMissingAclTxFromIndex().cardinality() > 0L) {
            ihr.add("First acl transaction missing from the Index", (Object)indexHealthReport.getMissingAclTxFromIndex().nextSetBit(0L));
        }
        ihr.add("Index transaction count", (Object)indexHealthReport.getTransactionDocsInIndex());
        ihr.add("Index acl transaction count", (Object)indexHealthReport.getAclTransactionDocsInIndex());
        ihr.add("Index unique transaction count", (Object)indexHealthReport.getTransactionDocsInIndex());
        ihr.add("Index unique acl transaction count", (Object)indexHealthReport.getAclTransactionDocsInIndex());
        ihr.add("Index leaf count", (Object)indexHealthReport.getLeafDocCountInIndex());
        ihr.add("Count of duplicate leaves in the index", (Object)indexHealthReport.getDuplicatedLeafInIndex().cardinality());
        if (indexHealthReport.getDuplicatedLeafInIndex().cardinality() > 0L) {
            ihr.add("First duplicate leaf in the index", (Object)("LEAF-" + indexHealthReport.getDuplicatedLeafInIndex().nextSetBit(0L)));
        }
        ihr.add("Last index commit time", (Object)indexHealthReport.getLastIndexedCommitTime());
        Date lastDate = new Date(indexHealthReport.getLastIndexedCommitTime());
        ihr.add("Last Index commit date", (Object)CachingDateFormat.getDateFormat().format(lastDate));
        ihr.add("Last TX id before holes", (Object)indexHealthReport.getLastIndexedIdBeforeHoles());
        return ihr;
    }
}

