/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.IOException;
import java.util.Set;
import org.alfresco.service.cmr.search.SearchParameters;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextAwareQuery
extends Query {
    protected static final Logger log = LoggerFactory.getLogger(ContextAwareQuery.class);
    private Query luceneQuery;
    private SearchParameters searchParameters;

    public ContextAwareQuery(Query luceneQuery, SearchParameters searchParameters) {
        this.luceneQuery = luceneQuery;
        this.searchParameters = searchParameters;
    }

    public void setBoost(float b) {
        this.luceneQuery.setBoost(b);
    }

    public float getBoost() {
        return this.luceneQuery.getBoost();
    }

    public String toString(String field) {
        return this.luceneQuery.toString(field);
    }

    public String toString() {
        return this.luceneQuery.toString();
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return this.luceneQuery.createWeight(searcher);
    }

    public Weight weight(Searcher searcher) throws IOException {
        return this.luceneQuery.weight(searcher);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this.luceneQuery.rewrite(reader);
    }

    public Query combine(Query[] queries) {
        return this.luceneQuery.combine(queries);
    }

    public void extractTerms(Set terms) {
        this.luceneQuery.extractTerms(terms);
    }

    public Similarity getSimilarity(Searcher searcher) {
        return this.luceneQuery.getSimilarity(searcher);
    }

    public Object clone() {
        return this.luceneQuery.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.luceneQuery == null ? 0 : this.luceneQuery.hashCode());
        result = 31 * result + (this.searchParameters == null ? 0 : this.searchParameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ContextAwareQuery other = (ContextAwareQuery)((Object)obj);
        if (this.luceneQuery == null ? other.luceneQuery != null : !this.luceneQuery.equals((Object)other.luceneQuery)) {
            return false;
        }
        return !(this.searchParameters == null ? other.searchParameters != null : !this.searchParameters.equals((Object)other.searchParameters));
    }
}

