/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.client;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.alfresco.encryption.DefaultEncryptionUtils;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.encryption.KeyStoreParameters;
import org.alfresco.encryption.MACUtils;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.httpclient.EncryptionService;
import org.alfresco.httpclient.MD5EncryptionParameters;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.AlfrescoModel;
import org.alfresco.solr.client.AlfrescoModelDiff;
import org.alfresco.solr.client.GetNodesParameters;
import org.alfresco.solr.client.MultiPropertyValue;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.NodeMetaDataParameters;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.client.Transactions;
import org.alfresco.util.Pair;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOLRAPIClientTest
extends TestCase {
    private static Log logger = LogFactory.getLog(SOLRAPIClientTest.class);
    private static final String TEST_MODEL = "org/alfresco/repo/dictionary/dictionarydaotest_model.xml";
    private EncryptionService invalidKeyEncryptionService;
    private TamperWithEncryptionService tamperWithEncryptionService;
    private SOLRAPIClient client;
    private SOLRAPIClient invalidKeyClient;
    private SOLRAPIClient tamperWithClient;
    private M2Model testModel;

    private void loadModel(Map<String, M2Model> modelMap, HashSet<String> loadedModels, M2Model model) {
        String modelName = model.getName();
        if (!loadedModels.contains(modelName)) {
            for (M2Namespace importNamespace : model.getImports()) {
                M2Model importedModel = modelMap.get(importNamespace.getUri());
                if (importedModel == null) continue;
                this.loadModel(modelMap, loadedModels, importedModel);
            }
            AlfrescoSolrDataModel.getInstance("test").putModel(model);
            loadedModels.add(modelName);
        }
    }

    public void setUp() throws Exception {
        boolean inRepoContext = true;
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        if (inRepoContext) {
            bootstrapModels.add("alfresco/model/applicationModel.xml");
            bootstrapModels.add("alfresco/model/blogIntegrationModel.xml");
            bootstrapModels.add("alfresco/model/calendarModel.xml");
            bootstrapModels.add("alfresco/model/contentModel.xml");
            bootstrapModels.add("alfresco/model/datalistModel.xml");
            bootstrapModels.add("alfresco/model/emailServerModel.xml");
            bootstrapModels.add("alfresco/model/forumModel.xml");
            bootstrapModels.add("alfresco/model/imapModel.xml");
            bootstrapModels.add("alfresco/model/linksModel.xml");
            bootstrapModels.add("alfresco/model/siteModel.xml");
            bootstrapModels.add("alfresco/model/systemModel.xml");
            bootstrapModels.add("alfresco/model/transferModel.xml");
            bootstrapModels.add("alfresco/model/wcmAppModel.xml");
            bootstrapModels.add("alfresco/model/wcmModel.xml");
        } else {
            bootstrapModels.add(TEST_MODEL);
        }
        HashMap<String, M2Model> modelMap = new HashMap<String, M2Model>();
        for (String bootstrapModel : bootstrapModels) {
            logger.debug((Object)("Loading ..." + bootstrapModel));
            InputStream modelStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(bootstrapModel);
            M2Model model = M2Model.createModel((InputStream)modelStream);
            for (M2Namespace namespace : model.getNamespaces()) {
                modelMap.put(namespace.getUri(), model);
            }
        }
        HashSet<String> loadedModels = new HashSet<String>();
        for (M2Model model : modelMap.values()) {
            this.loadModel(modelMap, loadedModels, model);
        }
        AlfrescoSolrDataModel model = AlfrescoSolrDataModel.getInstance("test");
        TestNamespaceDAO namespaceDAO = new TestNamespaceDAO();
        ClasspathKeyResourceLoader keyResourceLoader = new ClasspathKeyResourceLoader();
        KeyStoreParameters keyStoreParameters = new KeyStoreParameters("test", "JCEKS", null, "keystore-passwords.properties", "org/alfresco/solr/client/.keystore");
        MD5EncryptionParameters encryptionParameters = new MD5EncryptionParameters("DESede/CBC/PKCS5Padding", Long.valueOf(2000L), "HmacSHA1");
        this.client = new SOLRAPIClient(null, model.getDictionaryService(), namespaceDAO);
        InputStream modelStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/solr/client/testModel.xml");
        this.testModel = M2Model.createModel((InputStream)modelStream);
    }

    public void testGetAcls() throws Exception {
        List<AclChangeSet> aclChangeSets = null;
        aclChangeSets = this.client.getAclChangeSets(null, null, null, null, 50);
        SOLRAPIClientTest.assertTrue((String)"Too many results", (aclChangeSets.size() <= 50 ? 1 : 0) != 0);
        if (aclChangeSets.size() < 2) {
            return;
        }
        AclChangeSet aclChangeSetCheck = null;
        AclChangeSet aclChangeSet0 = aclChangeSets.get(0);
        AclChangeSet aclChangeSet1 = aclChangeSets.get(1);
        long id0 = aclChangeSet0.getId();
        long commitTimeMs0 = aclChangeSet0.getCommitTimeMs();
        Long nextId = id0 + 1L;
        aclChangeSets = this.client.getAclChangeSets(commitTimeMs0, nextId, null, null, 1);
        SOLRAPIClientTest.assertEquals((int)1, (int)aclChangeSets.size());
        aclChangeSetCheck = aclChangeSets.get(0);
        SOLRAPIClientTest.assertEquals((Object)aclChangeSet1, (Object)aclChangeSetCheck);
        HashMap<Long, AclChangeSet> aclChangeSetsById = new HashMap<Long, AclChangeSet>();
        for (AclChangeSet aclChangeSet : aclChangeSets) {
            aclChangeSetsById.put(aclChangeSet.getId(), aclChangeSet);
        }
        HashSet<Long> aclIdUniqueCheck = new HashSet<Long>(1000);
        Long minAclChangeSetId = null;
        Long fromCommitTimeMs = null;
        for (int i = 0; i < 100 && (aclChangeSets = this.client.getAclChangeSets(fromCommitTimeMs, minAclChangeSetId, null, null, 10)).size() != 0; ++i) {
            List<Acl> acls;
            Long nextAclId = null;
            while ((acls = this.client.getAcls(aclChangeSets, nextAclId, 1000)).size() != 0) {
                HashSet<Long> aclIds = new HashSet<Long>(1000);
                for (Acl acl : acls) {
                    long aclId = acl.getId();
                    aclIds.add(aclId);
                    if (!aclIdUniqueCheck.add(aclId)) {
                        SOLRAPIClientTest.fail((String)("ACL already processed: " + aclId));
                    }
                    if (nextAclId != null) {
                        SOLRAPIClientTest.assertTrue((String)("ACL IDs must be ascending: " + aclId), (nextAclId <= aclId ? 1 : 0) != 0);
                    }
                    nextAclId = aclId + 1L;
                }
                List<AclReaders> aclsReaders = this.client.getAclReaders(acls);
                for (AclReaders aclReaders : aclsReaders) {
                    Long aclId = aclReaders.getId();
                    aclIds.remove(aclId);
                }
                SOLRAPIClientTest.assertTrue((String)("Some ACL IDs were not covered: " + aclIds), (aclIds.size() == 0 ? 1 : 0) != 0);
            }
            AclChangeSet lastAclChangeSet = aclChangeSets.get(aclChangeSets.size() - 1);
            fromCommitTimeMs = lastAclChangeSet.getCommitTimeMs();
            minAclChangeSetId = lastAclChangeSet.getId() + 1L;
        }
    }

    public void testGetTransactions() throws Exception {
        Transactions transactions = this.client.getTransactions(1298288417234L, null, null, null, 5);
        transactions = this.client.getTransactions(null, 1L, null, null, 5);
        ArrayList<Long> transactionIds = new ArrayList<Long>(transactions.getTransactions().size());
        for (Transaction info : transactions.getTransactions()) {
            logger.debug((Object)info);
            transactionIds.add(info.getId());
        }
        GetNodesParameters params = new GetNodesParameters();
        params.setTransactionIds(transactionIds);
        List<Node> nodes = this.client.getNodes(params, 5);
        for (Node info : nodes) {
            logger.debug((Object)info);
        }
        params = new GetNodesParameters();
        params.setTransactionIds(transactionIds);
        params.setFromNodeId(nodes.get(nodes.size() - 1).getId());
        nodes = this.client.getNodes(params, 3);
        ArrayList<Long> nodeIds = new ArrayList<Long>(nodes.size());
        for (Node info : nodes) {
            logger.debug((Object)info);
            nodeIds.add(info.getId());
        }
        NodeMetaDataParameters metaParams = new NodeMetaDataParameters();
        metaParams.setNodeIds(nodeIds);
        List<NodeMetaData> metadata = this.client.getNodesMetaData(metaParams, 3);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
        }
    }

    public void testMetaData() throws AuthenticationException, IOException, JSONException {
        NodeMetaDataParameters metaParams = new NodeMetaDataParameters();
        ArrayList<Long> nodeIds = new ArrayList<Long>(1);
        nodeIds.add(1L);
        metaParams.setNodeIds(nodeIds);
        List<NodeMetaData> metadata = this.client.getNodesMetaData(metaParams, 3);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
        }
        metaParams = new NodeMetaDataParameters();
        nodeIds = new ArrayList(1);
        nodeIds.add(9L);
        metaParams.setNodeIds(nodeIds);
        metadata = this.client.getNodesMetaData(metaParams, 3);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
        }
        metaParams = new NodeMetaDataParameters();
        nodeIds = new ArrayList(1);
        nodeIds.add(19L);
        metaParams.setNodeIds(nodeIds);
        metadata = this.client.getNodesMetaData(metaParams, 3);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
        }
        metaParams = new NodeMetaDataParameters();
        nodeIds = new ArrayList(1);
        nodeIds.add(49437L);
        metaParams.setNodeIds(nodeIds);
        metadata = this.client.getNodesMetaData(metaParams, 3);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
        }
        metaParams = new NodeMetaDataParameters();
        nodeIds = new ArrayList(1);
        nodeIds.add(49431L);
        metaParams.setNodeIds(nodeIds);
        metadata = this.client.getNodesMetaData(metaParams, 3);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
            MultiPropertyValue multi = (MultiPropertyValue)info.getProperties().get(QName.createQName((String)"{http://www.alfresco.org/model/content/1.0}taggable"));
            for (PropertyValue propValue : multi.getValues()) {
                logger.debug((Object)("multi property values = " + propValue));
            }
        }
        metaParams = new NodeMetaDataParameters();
        nodeIds = new ArrayList(1);
        nodeIds.add(117630L);
        metaParams.setNodeIds(nodeIds);
        metadata = this.client.getNodesMetaData(metaParams, 3);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
        }
        metaParams = new NodeMetaDataParameters();
        nodeIds = new ArrayList(1);
        nodeIds.add(117678L);
        metaParams.setNodeIds(nodeIds);
        metadata = this.client.getNodesMetaData(metaParams, 3);
        for (NodeMetaData info : metadata) {
            logger.debug((Object)info);
        }
    }

    public void testGetModel() throws AuthenticationException, IOException, JSONException {
        AlfrescoModel alfModel = this.client.getModel(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"contentmodel"));
        M2Model model = alfModel.getModel();
        SOLRAPIClientTest.assertNotNull((Object)model);
        SOLRAPIClientTest.assertEquals((String)"Returned model has incorrect name", (String)"cm:contentmodel", (String)model.getName());
        SOLRAPIClientTest.assertNotNull((Object)alfModel.getChecksum());
    }

    public void testGetModelDiffs() throws AuthenticationException, IOException, JSONException {
        List<AlfrescoModelDiff> diffs = this.client.getModelsDiff(Collections.EMPTY_LIST);
        SOLRAPIClientTest.assertTrue((diffs.size() > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMAC() throws IOException, JSONException {
        Transactions transactions;
        try {
            transactions = this.invalidKeyClient.getTransactions(1298288417234L, null, null, null, 5);
        }
        catch (AuthenticationException e) {
            SOLRAPIClientTest.assertEquals((String)"Should have caught unathorised request", (int)e.getMethod().getStatusCode(), (int)401);
        }
        try {
            try {
                this.tamperWithEncryptionService.setOverrideTimestamp(true);
                transactions = this.tamperWithClient.getTransactions(1298288417234L, null, null, null, 5);
            }
            catch (AuthenticationException e) {
                SOLRAPIClientTest.assertEquals((String)"Should have caught unathorised request", (int)e.getMethod().getStatusCode(), (int)401);
                Object var3_6 = null;
                this.tamperWithEncryptionService.setOverrideTimestamp(false);
            }
            Object var3_5 = null;
            this.tamperWithEncryptionService.setOverrideTimestamp(false);
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.tamperWithEncryptionService.setOverrideTimestamp(false);
            throw throwable;
        }
        try {
            try {
                this.tamperWithEncryptionService.setOverrideMAC(true);
                transactions = this.tamperWithClient.getTransactions(1298288417234L, null, null, null, 5);
            }
            catch (AuthenticationException e) {
                SOLRAPIClientTest.assertEquals((String)"Should have caught unathorised request", (int)e.getMethod().getStatusCode(), (int)401);
                Object var5_10 = null;
                this.tamperWithEncryptionService.setOverrideMAC(false);
            }
            Object var5_9 = null;
            this.tamperWithEncryptionService.setOverrideMAC(false);
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.tamperWithEncryptionService.setOverrideMAC(false);
            throw throwable;
        }
    }

    private void outputTextContent(SOLRAPIClient.GetTextContentResponse response) throws IOException {
        InputStream in = response.getContent();
        if (in != null) {
            logger.debug((Object)"Text content:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                logger.debug((Object)line);
            }
        }
    }

    private static class TamperWithEncryptionService
    extends EncryptionService {
        TamperWithEncryptionService(String alfrescoHost, int alfrescoPort, KeyResourceLoader keyResourceLoader, KeyStoreParameters keyStoreParameters, MD5EncryptionParameters encryptionParameters) {
            super(alfrescoHost, alfrescoPort, keyResourceLoader, keyStoreParameters, encryptionParameters);
        }

        protected void setupEncryptionUtils() {
            this.encryptionUtils = new TestEncryptionUtils();
            TestEncryptionUtils testEncryptionUtils = (TestEncryptionUtils)this.encryptionUtils;
            testEncryptionUtils.setEncryptor(this.getEncryptor());
            testEncryptionUtils.setMacUtils(this.getMacUtils());
            testEncryptionUtils.setMessageTimeout(this.encryptionParameters.getMessageTimeout());
            testEncryptionUtils.setRemoteIP(this.alfrescoHost);
        }

        public void setOverrideTimestamp(boolean overrideTimestamp) {
            ((TestEncryptionUtils)this.encryptionUtils).setOverrideTimestamp(overrideTimestamp);
        }

        public void setOverrideMAC(boolean overrideMAC) {
            ((TestEncryptionUtils)this.encryptionUtils).setOverrideMAC(overrideMAC);
        }
    }

    private static class TestEncryptionUtils
    extends DefaultEncryptionUtils {
        private boolean overrideMAC = false;
        private boolean overrideTimestamp = false;

        private TestEncryptionUtils() {
        }

        public void setOverrideMAC(boolean overrideMAC) {
            this.overrideMAC = overrideMAC;
        }

        public void setOverrideTimestamp(boolean overrideTimestamp) {
            this.overrideTimestamp = overrideTimestamp;
        }

        public void setRequestAuthentication(HttpMethod method, byte[] message) throws IOException {
            if (method instanceof PostMethod) {
                Pair encrypted = this.encryptor.encrypt("solr", null, message);
                this.setRequestAlgorithmParameters(method, (AlgorithmParameters)encrypted.getSecond());
                ((PostMethod)method).setRequestEntity((RequestEntity)new ByteArrayRequestEntity((byte[])encrypted.getFirst(), "application/octet-stream"));
            }
            long requestTimestamp = System.currentTimeMillis();
            byte[] mac = this.macUtils.generateMAC("solr", new MACUtils.MACInput(message, requestTimestamp, this.getLocalIPAddress()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setting MAC " + mac + " on HTTP request " + method.getPath()));
                logger.debug((Object)("Setting timestamp " + requestTimestamp + " on HTTP request " + method.getPath()));
            }
            if (this.overrideMAC) {
                mac[0] = (byte)(mac[0] + 1);
            }
            this.setRequestMac(method, mac);
            if (this.overrideTimestamp) {
                requestTimestamp += 60000L;
            }
            this.setRequestTimestamp(method, requestTimestamp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestNamespaceDAO
    implements NamespaceDAO {
        private Map<String, String> prefixMappings = new HashMap<String, String>(10);
        private Map<String, List<String>> prefixReverseMappings = new HashMap<String, List<String>>(10);

        TestNamespaceDAO() {
            this.prefixMappings.put("cm", "http://www.alfresco.org/model/content/1.0");
            this.prefixMappings.put("sys", "http://www.alfresco.org/model/system/1.0");
            this.prefixMappings.put("", "");
            this.prefixMappings.put("d", "http://www.alfresco.org/model/dictionary/1.0");
            this.prefixMappings.put("app", "http://www.alfresco.org/model/application/1.0");
            this.prefixMappings.put("ver", "http://www.alfresco.org/model/versionstore/1.0");
            this.prefixMappings.put("ver2", "http://www.alfresco.org/model/versionstore/2.0");
            this.prefixReverseMappings.put("http://www.alfresco.org/model/content/1.0", Arrays.asList("cm"));
            this.prefixReverseMappings.put("sys", Arrays.asList("http://www.alfresco.org/model/system/1.0"));
            this.prefixReverseMappings.put("", Arrays.asList(""));
            this.prefixReverseMappings.put("d", Arrays.asList("http://www.alfresco.org/model/dictionary/1.0"));
            this.prefixReverseMappings.put("app", Arrays.asList("http://www.alfresco.org/model/application/1.0"));
            this.prefixReverseMappings.put("ver", Arrays.asList("http://www.alfresco.org/model/versionstore/1.0"));
            this.prefixReverseMappings.put("ver2", Arrays.asList("http://www.alfresco.org/model/versionstore/2.0"));
        }

        public String getNamespaceURI(String prefix) throws NamespaceException {
            return this.prefixMappings.get(prefix);
        }

        public Collection<String> getPrefixes(String namespaceURI) throws NamespaceException {
            return this.prefixReverseMappings.get(namespaceURI);
        }

        public Collection<String> getPrefixes() {
            return null;
        }

        public Collection<String> getURIs() {
            return null;
        }

        public void addURI(String uri) {
        }

        public void removeURI(String uri) {
        }

        public void addPrefix(String prefix, String uri) {
        }

        public void removePrefix(String prefix) {
        }

        public void init() {
        }

        public void afterDictionaryInit() {
        }

        public void destroy() {
        }

        public void registerDictionary(DictionaryDAO dictionaryDAO) {
        }
    }

    private class ClasspathKeyResourceLoader
    implements KeyResourceLoader {
        private ClasspathKeyResourceLoader() {
        }

        public InputStream getKeyStore(String location) throws FileNotFoundException {
            return this.getClass().getClassLoader().getResourceAsStream(location);
        }

        public Properties loadKeyMetaData(String location) throws IOException {
            Properties p = new Properties();
            p.load(this.getClass().getClassLoader().getResourceAsStream(location));
            return p;
        }
    }
}

