/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.HashSet;
import org.alfresco.solr.AlfrescoSolrEventListener;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.alfresco.solr.query.SolrCachingOwnerQuery;
import org.alfresco.solr.query.SolrCachingReaderQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrCachingAuthorityScorer
extends AbstractSolrCachingScorer {
    SolrCachingAuthorityScorer(Similarity similarity, DocSet in, SolrIndexReader solrIndexReader) {
        super(similarity, in, solrIndexReader);
    }

    public static SolrCachingAuthorityScorer createAuthorityScorer(SolrIndexSearcher searcher, Similarity similarity, String authority, SolrIndexReader reader) throws IOException {
        HashSet globalReaders = (HashSet)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_GLOBAL_READERS);
        if (globalReaders.contains(authority)) {
            OpenBitSet allLeafDocs = (OpenBitSet)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_ALL_LEAF_DOCS);
            return new SolrCachingAuthorityScorer(similarity, (DocSet)new BitDocSet(allLeafDocs), reader);
        }
        DocSet readableDocSet = searcher.getDocSet((Query)new SolrCachingReaderQuery(authority));
        if (globalReaders.contains("ROLE_OWNER")) {
            DocSet authorityOwnedDocs = searcher.getDocSet((Query)new SolrCachingOwnerQuery(authority));
            return new SolrCachingAuthorityScorer(similarity, readableDocSet.union(authorityOwnedDocs), reader);
        }
        DocSet ownerReadableDocSet = searcher.getDocSet((Query)new SolrCachingReaderQuery("ROLE_OWNER"));
        DocSet authorityOwnedDocs = searcher.getDocSet((Query)new SolrCachingOwnerQuery(authority));
        DocSet docsAuthorityOwnsAndCanRead = ownerReadableDocSet.intersection(authorityOwnedDocs);
        return new SolrCachingAuthorityScorer(similarity, readableDocSet.union(docsAuthorityOwnsAndCanRead), reader);
    }
}

