/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.repo.search.impl.lucene.query.StructuredFieldPosition;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class SolrContainerScorer
extends Scorer {
    Weight weight;
    TermPositions root;
    StructuredFieldPosition[] positions;
    byte[] norms;
    int min = 0;
    int max = 0;
    int rootDoc = 0;
    boolean more = true;
    float freq = 0.0f;

    public SolrContainerScorer(Weight weight, TermPositions root, StructuredFieldPosition[] positions, Similarity similarity, byte[] norms) {
        super(similarity);
        this.weight = weight;
        this.positions = positions;
        this.norms = norms;
        this.root = root;
    }

    public boolean next() throws IOException {
        if (!this.more) {
            return false;
        }
        if (this.max == 0) {
            this.doNextOnAll();
            if (this.found()) {
                return true;
            }
        }
        return this.findNext();
    }

    private boolean findNext() throws IOException {
        while (this.more) {
            this.move();
            if (!this.found()) continue;
            return true;
        }
        return false;
    }

    private boolean found() throws IOException {
        if (this.positions.length == 0) {
            return true;
        }
        if (!this.more) {
            return false;
        }
        if (this.min != this.max) {
            return false;
        }
        if (this.rootDoc != this.max) {
            return false;
        }
        int count = this.root.freq();
        int start = 0;
        int end = -1;
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                start = 0;
                end = this.root.nextPosition();
            } else {
                start = end + 1;
                end = this.root.nextPosition();
            }
            if (!this.check(start, end)) continue;
            return true;
        }
        return false;
    }

    private boolean check(int start, int end) throws IOException {
        int offset = this.checkTail(start, end, 0, 0, true);
        return offset != -1;
    }

    private int checkTail(int start, int end, int currentPosition, int currentOffset, boolean checkLastMatch) throws IOException {
        StructuredFieldPosition last;
        if (checkLastMatch && end - start > 1 && (last = this.getLastPositionNotSelfCheck()) != null && last.matches(start, end, end - start - 2) == -1) {
            return -1;
        }
        int offset = currentOffset;
        int l = this.positions.length;
        for (int i = currentPosition; i < l; ++i) {
            if ((offset = this.positions[i].matches(start, end, offset)) == -1) {
                return -1;
            }
            if (!this.positions[i].isDescendant()) continue;
            for (int j = offset; j < end - start; j += 2) {
                int newOffset = this.checkTail(start, end, i + 1, j, false);
                if (newOffset == -1) continue;
                return newOffset;
            }
            return -1;
        }
        if (start + offset + 1 == end) {
            return offset;
        }
        return -1;
    }

    private StructuredFieldPosition getLastPositionNotSelfCheck() {
        for (int i = this.positions.length - 1; i >= 0; --i) {
            if (this.positions[i].linkSelf()) continue;
            return this.positions[i];
        }
        return null;
    }

    private void move() throws IOException {
        if (this.min == this.max) {
            this.doNextOnAll();
        } else {
            this.skipToMax();
        }
    }

    private void doNextOnAll() throws IOException {
        boolean first = true;
        int l = this.positions.length;
        for (int i = 0; i < l; ++i) {
            if (this.positions[i].getCachingTermPositions() == null) continue;
            if (this.positions[i].getCachingTermPositions().next()) {
                int current = this.positions[i].getCachingTermPositions().doc();
                this.adjustMinMax(current, first);
                first = false;
                continue;
            }
            this.more = false;
            return;
        }
        if (this.root.next()) {
            this.rootDoc = this.root.doc();
            if (first) {
                this.adjustMinMax(this.rootDoc, first);
            }
        } else {
            this.more = false;
            return;
        }
        if (this.root.doc() < this.max) {
            if (this.root.skipTo(this.max)) {
                this.rootDoc = this.root.doc();
            } else {
                this.more = false;
                return;
            }
        }
    }

    private void skipToMax() throws IOException {
        int l = this.positions.length;
        for (int i = 0; i < l; ++i) {
            if (i == 0) {
                this.min = this.max;
            }
            if (this.positions[i].getCachingTermPositions() == null || this.positions[i].getCachingTermPositions().doc() >= this.max) continue;
            if (this.positions[i].getCachingTermPositions().skipTo(this.max)) {
                int current = this.positions[i].getCachingTermPositions().doc();
                this.adjustMinMax(current, false);
                continue;
            }
            this.more = false;
            return;
        }
        if (this.root.doc() < this.max) {
            if (this.root.skipTo(this.max)) {
                this.rootDoc = this.root.doc();
            } else {
                this.more = false;
                return;
            }
        }
    }

    private void adjustMinMax(int doc, boolean setMin) {
        if (this.max < doc) {
            this.max = doc;
        }
        if (setMin) {
            this.min = doc;
        } else if (this.min > doc) {
            this.min = doc;
        }
    }

    public int doc() {
        return this.max;
    }

    public float score() throws IOException {
        return 1.0f;
    }

    public boolean skipTo(int target) throws IOException {
        this.max = target;
        return this.findNext();
    }

    public Explanation explain(int doc) throws IOException {
        Explanation tfExplanation = new Explanation();
        while (this.next() && this.doc() < doc) {
        }
        float phraseFreq = this.doc() == doc ? this.freq : 0.0f;
        tfExplanation.setValue(this.getSimilarity().tf(phraseFreq));
        tfExplanation.setDescription("tf(phraseFreq=" + phraseFreq + ")");
        return tfExplanation;
    }
}

