/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.util;

import java.io.UnsupportedEncodingException;

public final class URLDecoder {
    public static String decode(String s) {
        int len = s.length();
        StringBuilder sb = null;
        int i = 0;
        byte[] bytes = null;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '%') {
                try {
                    if (sb == null) {
                        String soFar = s.substring(0, i);
                        sb = new StringBuilder(len + 16);
                        sb.append(soFar);
                    }
                    if (bytes == null) {
                        bytes = new byte[(len - i) / 3];
                    }
                    int pos = 0;
                    while (i + 2 < len && c == '%') {
                        bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                        if ((i += 3) >= len) continue;
                        c = s.charAt(i);
                    }
                    if (i < len && c == '%') {
                        throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                    }
                    sb.append(new String(bytes, 0, pos, "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException encErr) {
                    throw new IllegalStateException("URLDecoder: Unable to generate UTF-8 String");
                }
                catch (NumberFormatException numErr) {
                    throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + numErr.getMessage());
                }
            }
            ++i;
            if (sb == null) continue;
            sb.append(c);
        }
        return sb != null ? sb.toString() : s;
    }
}

