/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.config;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.config.SystemPropertiesSetterBean;

public class SystemPropertiesSetterBeanTest
extends TestCase {
    private static final String KEY_A = "SystemPropertiesSetterBeanTest.A";
    private static final String KEY_B = "SystemPropertiesSetterBeanTest.B";
    private static final String KEY_C = "SystemPropertiesSetterBeanTest.C";
    private static final String KEY_EXISTING = "SystemPropertiesSetterBeanTest.EXISTING ";
    private static final String KEY_PLACEHOLDER = "SystemPropertiesSetterBeanTest.PLACEHOLDER";
    private static final String KEY_EMPTY_STRING = "SystemPropertiesSetterBeanTest.EMPTY_STRING";
    private static final String KEY_NULL = "SystemPropertiesSetterBeanTest.NULL";
    private static final String VALUE_A = "A";
    private static final String VALUE_B = "B";
    private static final String VALUE_C = "C";
    private static final String VALUE_EXISTING = "EXISTING";
    private static final String VALUE_PLACEHOLDER = "${OOPS}";
    private static final String VALUE_EMPTY_STRING = "";
    private static final String VALUE_NULL = null;
    SystemPropertiesSetterBean setter;
    private Map<String, String> propertyMap;

    public void setUp() throws Exception {
        System.setProperty(KEY_EXISTING, VALUE_EXISTING);
        this.propertyMap = new HashMap<String, String>(7);
        this.propertyMap.put(KEY_A, VALUE_A);
        this.propertyMap.put(KEY_B, VALUE_B);
        this.propertyMap.put(KEY_C, VALUE_C);
        this.propertyMap.put(KEY_EXISTING, "SHOULD NOT HAVE OVERRIDDEN EXISTING PROPERTY");
        this.propertyMap.put(KEY_PLACEHOLDER, VALUE_PLACEHOLDER);
        this.propertyMap.put(KEY_EMPTY_STRING, VALUE_EMPTY_STRING);
        this.propertyMap.put(KEY_NULL, VALUE_NULL);
        this.setter = new SystemPropertiesSetterBean();
        this.setter.setPropertyMap(this.propertyMap);
    }

    public void testSetUp() {
        SystemPropertiesSetterBeanTest.assertEquals((String)VALUE_EXISTING, (String)System.getProperty(KEY_EXISTING));
        SystemPropertiesSetterBeanTest.assertNull((Object)System.getProperty(KEY_A));
        SystemPropertiesSetterBeanTest.assertNull((Object)System.getProperty(KEY_B));
        SystemPropertiesSetterBeanTest.assertNull((Object)System.getProperty(KEY_C));
    }

    public void testSettingOfSystemProperties() {
        this.setter.init();
        SystemPropertiesSetterBeanTest.assertEquals((String)VALUE_A, (String)System.getProperty(KEY_A));
        SystemPropertiesSetterBeanTest.assertEquals((String)VALUE_B, (String)System.getProperty(KEY_B));
        SystemPropertiesSetterBeanTest.assertEquals((String)VALUE_C, (String)System.getProperty(KEY_C));
        SystemPropertiesSetterBeanTest.assertEquals((String)VALUE_EXISTING, (String)System.getProperty(KEY_EXISTING));
        SystemPropertiesSetterBeanTest.assertNull((String)"Property placeholder not detected", (Object)System.getProperty(KEY_PLACEHOLDER));
        SystemPropertiesSetterBeanTest.assertNull((String)"Empty string not detected", (Object)System.getProperty(KEY_EMPTY_STRING));
        SystemPropertiesSetterBeanTest.assertNull((String)"Null string not detected", (Object)System.getProperty(KEY_NULL));
    }
}

