/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.io.InputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import org.alfresco.encryption.Encryptor;
import org.alfresco.encryption.FallbackEncryptor;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFallbackEncryptor
implements FallbackEncryptor {
    private Encryptor fallback;
    private Encryptor main;

    public DefaultFallbackEncryptor() {
    }

    public DefaultFallbackEncryptor(Encryptor main, Encryptor fallback) {
        this();
        this.main = main;
        this.fallback = fallback;
    }

    public void setFallback(Encryptor fallback) {
        this.fallback = fallback;
    }

    public void setMain(Encryptor main) {
        this.main = main;
    }

    @Override
    public Pair<byte[], AlgorithmParameters> encrypt(String keyAlias, AlgorithmParameters params, byte[] input) {
        Pair<byte[], AlgorithmParameters> ret = this.main.encrypt(keyAlias, params, input);
        return ret;
    }

    @Override
    public byte[] decrypt(String keyAlias, AlgorithmParameters params, byte[] input) {
        byte[] ret;
        try {
            ret = this.main.decrypt(keyAlias, params, input);
        }
        catch (Throwable e) {
            ret = this.fallback.decrypt(keyAlias, params, input);
        }
        return ret;
    }

    @Override
    public InputStream decrypt(String keyAlias, AlgorithmParameters params, InputStream in) {
        InputStream ret;
        try {
            ret = this.main.decrypt(keyAlias, params, in);
        }
        catch (Throwable e) {
            ret = this.fallback.decrypt(keyAlias, params, in);
        }
        return ret;
    }

    @Override
    public Pair<byte[], AlgorithmParameters> encryptObject(String keyAlias, AlgorithmParameters params, Object input) {
        Pair<byte[], AlgorithmParameters> ret = this.main.encryptObject(keyAlias, params, input);
        return ret;
    }

    @Override
    public Object decryptObject(String keyAlias, AlgorithmParameters params, byte[] input) {
        Object ret;
        try {
            ret = this.main.decryptObject(keyAlias, params, input);
        }
        catch (Throwable e) {
            ret = this.fallback.decryptObject(keyAlias, params, input);
        }
        return ret;
    }

    @Override
    public Serializable sealObject(String keyAlias, AlgorithmParameters params, Serializable input) {
        Serializable ret = this.main.sealObject(keyAlias, params, input);
        return ret;
    }

    @Override
    public Serializable unsealObject(String keyAlias, Serializable input) throws InvalidKeyException {
        Serializable ret;
        try {
            ret = this.main.unsealObject(keyAlias, input);
        }
        catch (Throwable e) {
            ret = this.fallback.unsealObject(keyAlias, input);
        }
        return ret;
    }

    @Override
    public AlgorithmParameters decodeAlgorithmParameters(byte[] encoded) {
        AlgorithmParameters ret;
        try {
            ret = this.main.decodeAlgorithmParameters(encoded);
        }
        catch (AlfrescoRuntimeException e) {
            ret = this.fallback.decodeAlgorithmParameters(encoded);
        }
        return ret;
    }

    @Override
    public boolean keyAvailable(String keyAlias) {
        return this.main.keyAvailable(keyAlias);
    }

    @Override
    public boolean backupKeyAvailable(String keyAlias) {
        return this.fallback.keyAvailable(keyAlias);
    }
}

