/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.ISO8601DateFormat;

public class ISO8601DateFormatTest
extends TestCase {
    public void testConversion() {
        String test = "2005-09-16T17:01:03.456+01:00";
        Date date = ISO8601DateFormat.parse(test);
        String strDate = ISO8601DateFormat.format(date);
        Date dateAfter = ISO8601DateFormat.parse(strDate);
        ISO8601DateFormatTest.assertEquals((Object)date, (Object)dateAfter);
    }

    public void testMiliseconds() {
        String testA = "2005-09-16T17:01:03.456+01:00";
        String testB = "2005-09-16T17:01:03+01:00";
        String testBms = "2005-09-16T17:01:03.000+01:00";
        Date dateA = ISO8601DateFormat.parse(testA);
        Date dateB = ISO8601DateFormat.parse(testB);
        ISO8601DateFormatTest.assertEquals((String)testA, (String)ISO8601DateFormat.format(dateA));
        ISO8601DateFormatTest.assertEquals((String)testBms, (String)ISO8601DateFormat.format(dateB));
    }

    public void testTimezones() {
        Date date = null;
        date = ISO8601DateFormat.parse("2011-02-04T12:13:14Z");
        try {
            ISO8601DateFormat.parse("2011-02-04T12:13:14");
            ISO8601DateFormatTest.fail((String)"TimeZones are required");
        }
        catch (AlfrescoRuntimeException e) {
            // empty catch block
        }
        TimeZone tz = TimeZone.getTimeZone("Europe/London");
        date = ISO8601DateFormat.parse("2011-02-04T12:13:14", tz);
        tz = TimeZone.getTimeZone("Australia/Sydney");
        String testSydney = "2011-02-04T16:13:14";
        String testUTC = "2011-02-04T05:13:14.000Z";
        date = ISO8601DateFormat.parse(testSydney, tz);
        ISO8601DateFormatTest.assertEquals((String)testUTC, (String)ISO8601DateFormat.format(date));
        date = ISO8601DateFormat.parse(testSydney + ".000", tz);
        ISO8601DateFormatTest.assertEquals((String)testUTC, (String)ISO8601DateFormat.format(date));
    }
}

