/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.PathMapper;

public class PathMapperTest
extends TestCase {
    private PathMapper mapper;

    protected void setUp() throws Exception {
        this.mapper = new PathMapper();
        this.mapper.addPathMap("/a/b/c", "/1/2/3");
        this.mapper.addPathMap("/a/b/c", "/one/two/three");
        this.mapper.addPathMap("/a/c/c", "/1/3/3");
        this.mapper.addPathMap("/a/c/c", "/one/three/three");
        this.mapper.addPathMap("/A/B/C", "/1/2/3");
        this.mapper.addPathMap("/A/B/C", "/ONE/TWO/THREE");
        this.mapper.addPathMap("/A/C/C", "/1/3/3");
        this.mapper.addPathMap("/A/C/C", "/ONE/THREE/THREE");
    }

    public void testConvertValueMap() {
        HashMap<String, Integer> inputMap = new HashMap<String, Integer>(5);
        inputMap.put("/a/a/a/111", 111);
        inputMap.put("/a/b/c/123", 123);
        inputMap.put("/a/b/b/122", 122);
        inputMap.put("/a/c/c/133", 133);
        inputMap.put("/A/A/A/111", 111);
        inputMap.put("/A/B/C/123", 123);
        inputMap.put("/A/B/B/122", 122);
        inputMap.put("/A/C/C/133", 133);
        HashMap<String, Integer> expectedOutputMap = new HashMap<String, Integer>(5);
        expectedOutputMap.put("/1/2/3/123", 123);
        expectedOutputMap.put("/one/two/three/123", 123);
        expectedOutputMap.put("/1/3/3/133", 133);
        expectedOutputMap.put("/one/three/three/133", 133);
        expectedOutputMap.put("/1/2/3/123", 123);
        expectedOutputMap.put("/ONE/TWO/THREE/123", 123);
        expectedOutputMap.put("/1/3/3/133", 133);
        expectedOutputMap.put("/ONE/THREE/THREE/133", 133);
        Map outputMap = this.mapper.convertMap(inputMap);
        String diff = EqualsHelper.getMapDifferenceReport(outputMap, expectedOutputMap);
        if (diff != null) {
            PathMapperTest.fail((String)diff);
        }
    }

    public void testPathMatchesExact() {
        Set<String> mappedPaths = this.mapper.getMappedPaths("/a/b/c");
        PathMapperTest.assertEquals((String)"Exact matches expected", (int)2, (int)mappedPaths.size());
        mappedPaths = this.mapper.getMappedPaths("/a");
        PathMapperTest.assertEquals((String)"Exact match NOT expected", (int)0, (int)mappedPaths.size());
    }

    public void testPathMatchesPartial() {
        Set<String> mappedPaths = this.mapper.getMappedPathsWithPartialMatch("/a");
        PathMapperTest.assertEquals((String)"Partial matches expected", (int)4, (int)mappedPaths.size());
    }
}

