/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.Date;
import org.alfresco.util.AbstractTriggerBean;
import org.alfresco.util.TriggerBeanSPI;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class TriggerBean
extends AbstractTriggerBean
implements TriggerBeanSPI {
    public long startDelay = 0L;
    public long repeatInterval = 0L;
    public int repeatCount = -1;

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public long getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public void setRepeatIntervalMinutes(long repeatIntervalMinutes) {
        this.repeatInterval = repeatIntervalMinutes * 60L * 1000L;
    }

    public long getStartDelay() {
        return this.startDelay;
    }

    public void setStartDelay(long startDelay) {
        this.startDelay = startDelay;
    }

    public void setStartDelayMinutes(long startDelayMinutes) {
        this.startDelay = startDelayMinutes * 60L * 1000L;
    }

    public Trigger getTrigger() throws Exception {
        if (this.repeatInterval <= 0L && this.repeatCount != 0) {
            logger.error((Object)("Job " + this.getBeanName() + " - repeatInterval/repeatIntervalMinutes cannot be 0 (or -ve) unless repeatCount is also 0"));
            return null;
        }
        SimpleTrigger trigger = new SimpleTrigger(this.getBeanName(), "DEFAULT");
        trigger.setStartTime(new Date(System.currentTimeMillis() + this.startDelay));
        trigger.setRepeatCount(this.repeatCount);
        trigger.setRepeatInterval(this.repeatInterval);
        return trigger;
    }
}

