/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmShutdownListener {
    private Log logger = LogFactory.getLog(VmShutdownListener.class);
    private volatile boolean vmShuttingDown = false;

    public VmShutdownListener(final String name) {
        Runnable shutdownRunnable = new Runnable(){

            public void run() {
                VmShutdownListener.this.vmShuttingDown = true;
                if (VmShutdownListener.this.logger.isDebugEnabled()) {
                    VmShutdownListener.this.logger.debug((Object)("VM shutdown detected by listener " + name));
                }
            }
        };
        Thread shutdownThread = new Thread(shutdownRunnable, "ShutdownListener-" + name);
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    public boolean isVmShuttingDown() {
        return this.vmShuttingDown;
    }

    public static class VmShutdownException
    extends RuntimeException {
        private static final long serialVersionUID = -5876107469054587072L;
    }
}

