/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml.dynamic;

import java.util.Map;
import org.apache.ibatis.builder.xml.dynamic.DynamicContext;
import org.apache.ibatis.builder.xml.dynamic.ExpressionEvaluator;
import org.apache.ibatis.builder.xml.dynamic.SqlNode;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.session.Configuration;

public class ForEachSqlNode
implements SqlNode {
    public static final String ITEM_PREFIX = "__frch_";
    private ExpressionEvaluator evaluator = new ExpressionEvaluator();
    private String collectionExpression;
    private SqlNode contents;
    private String open;
    private String close;
    private String separator;
    private String item;
    private String index;
    private Configuration configuration;

    public ForEachSqlNode(Configuration configuration, SqlNode contents, String collectionExpression, String index, String item, String open, String close, String separator) {
        this.collectionExpression = collectionExpression;
        this.contents = contents;
        this.open = open;
        this.close = close;
        this.separator = separator;
        this.index = index;
        this.item = item;
        this.configuration = configuration;
    }

    public boolean apply(DynamicContext context) {
        Map<String, Object> bindings = context.getBindings();
        Iterable<?> iterable = this.evaluator.evaluateIterable(this.collectionExpression, bindings);
        boolean first = true;
        this.applyOpen(context);
        int i = 0;
        for (Object o : iterable) {
            DynamicContext oldContext = context;
            if (first) {
                first = false;
                context = new PrefixedContext(context, "");
            } else {
                context = this.separator != null ? new PrefixedContext(context, this.separator) : new PrefixedContext(context, "");
            }
            int uniqueNumber = context.getUniqueNumber();
            this.applyItem(context, o, uniqueNumber);
            this.applyIndex(context, i);
            this.contents.apply(new FilteredDynamicContext(this.configuration, context, this.item, uniqueNumber));
            first = !((PrefixedContext)context).isPrefixApplied();
            context = oldContext;
            ++i;
        }
        this.applyClose(context);
        return true;
    }

    private void applyIndex(DynamicContext context, int i) {
        if (this.index != null) {
            context.bind(this.index, i);
        }
    }

    private void applyItem(DynamicContext context, Object o, int i) {
        if (this.item != null) {
            context.bind(this.item, o);
            context.bind(ForEachSqlNode.itemizeItem(this.item, i), o);
        }
    }

    private void applyOpen(DynamicContext context) {
        if (this.open != null) {
            context.appendSql(this.open);
        }
    }

    private void applyClose(DynamicContext context) {
        if (this.close != null) {
            context.appendSql(this.close);
        }
    }

    private static String itemizeItem(String item, int i) {
        return ITEM_PREFIX + item + "_" + i;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrefixedContext
    extends DynamicContext {
        private DynamicContext delegate;
        private String prefix;
        private boolean prefixApplied;

        public PrefixedContext(DynamicContext delegate, String prefix) {
            super(ForEachSqlNode.this.configuration, null);
            this.delegate = delegate;
            this.prefix = prefix;
            this.prefixApplied = false;
        }

        public boolean isPrefixApplied() {
            return this.prefixApplied;
        }

        @Override
        public Map<String, Object> getBindings() {
            return this.delegate.getBindings();
        }

        @Override
        public void bind(String name, Object value) {
            this.delegate.bind(name, value);
        }

        @Override
        public void appendSql(String sql) {
            if (!this.prefixApplied && sql != null && sql.trim().length() > 0) {
                this.delegate.appendSql(this.prefix);
                this.prefixApplied = true;
            }
            this.delegate.appendSql(sql);
        }

        @Override
        public String getSql() {
            return this.delegate.getSql();
        }

        @Override
        public int getUniqueNumber() {
            return this.delegate.getUniqueNumber();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredDynamicContext
    extends DynamicContext {
        private DynamicContext delegate;
        private int index;
        private String item;

        public FilteredDynamicContext(Configuration configuration, DynamicContext delegate, String item, int i) {
            super(configuration, null);
            this.delegate = delegate;
            this.index = i;
            this.item = item;
        }

        @Override
        public Map<String, Object> getBindings() {
            return this.delegate.getBindings();
        }

        @Override
        public void bind(String name, Object value) {
            this.delegate.bind(name, value);
        }

        @Override
        public String getSql() {
            return this.delegate.getSql();
        }

        @Override
        public void appendSql(String sql) {
            GenericTokenParser parser = new GenericTokenParser("#{", "}", new TokenHandler(){

                public String handleToken(String content) {
                    String newContent = content.replaceFirst(FilteredDynamicContext.this.item, ForEachSqlNode.itemizeItem(FilteredDynamicContext.this.item, FilteredDynamicContext.this.index));
                    return "#{" + newContent + "}";
                }
            });
            this.delegate.appendSql(parser.parse(sql));
        }

        @Override
        public int getUniqueNumber() {
            return this.delegate.getUniqueNumber();
        }
    }
}

