/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.logging.jdbc.BaseJdbcLogger;
import org.apache.ibatis.logging.jdbc.ResultSetLogger;
import org.apache.ibatis.reflection.ExceptionUtil;

public class StatementLogger
extends BaseJdbcLogger
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(Statement.class);
    private Statement statement;

    private StatementLogger(Statement stmt) {
        this.statement = stmt;
    }

    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            if (EXECUTE_METHODS.contains(method.getName())) {
                if (log.isDebugEnabled()) {
                    log.debug("==>  Executing: " + this.removeBreakingWhitespace((String)params[0]));
                }
                if ("executeQuery".equals(method.getName())) {
                    ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                    if (rs != null) {
                        return ResultSetLogger.newInstance(rs);
                    }
                    return null;
                }
                return method.invoke((Object)this.statement, params);
            }
            if ("getResultSet".equals(method.getName())) {
                ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                if (rs != null) {
                    return ResultSetLogger.newInstance(rs);
                }
                return null;
            }
            if ("equals".equals(method.getName())) {
                Object ps = params[0];
                return ps instanceof Proxy && proxy == ps;
            }
            if ("hashCode".equals(method.getName())) {
                return proxy.hashCode();
            }
            return method.invoke((Object)this.statement, params);
        }
        catch (Throwable t) {
            throw ExceptionUtil.unwrapThrowable(t);
        }
    }

    public static Statement newInstance(Statement stmt) {
        StatementLogger handler = new StatementLogger(stmt);
        ClassLoader cl = Statement.class.getClassLoader();
        return (Statement)Proxy.newProxyInstance(cl, new Class[]{Statement.class}, (InvocationHandler)handler);
    }

    public Statement getStatement() {
        return this.statement;
    }
}

