/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.commands.BaseCommand;
import org.apache.ibatis.migration.commands.DownCommand;
import org.apache.ibatis.migration.commands.UpCommand;

public class VersionCommand
extends BaseCommand {
    public VersionCommand(File repository, String environment, boolean force) {
        super(repository, environment, force);
    }

    public void execute(String ... params) {
        this.ensureParamsPassed(params);
        this.ensureNumericParam(params);
        this.ensureVersionExists(params);
        BigDecimal version = new BigDecimal(params[0]);
        Change change = this.getLastAppliedChange();
        if (version.compareTo(change.getId()) > 0) {
            this.printStream.println("Upgrading to: " + version);
            UpCommand up = new UpCommand(this.basePath, this.environment, this.force, true);
            while (!version.equals(change.getId())) {
                up.execute(new String[0]);
                change = this.getLastAppliedChange();
            }
        } else if (version.compareTo(change.getId()) < 0) {
            this.printStream.println("Downgrading to: " + version);
            DownCommand down = new DownCommand(this.basePath, this.environment, this.force);
            while (!version.equals(change.getId())) {
                down.execute(new String[0]);
                change = this.getLastAppliedChange();
            }
        } else {
            this.printStream.println("Already at version: " + version);
        }
        this.printStream.println();
    }

    private void ensureParamsPassed(String ... params) {
        if (this.paramsEmpty(params)) {
            throw new MigrationException("No target version specified for migration.");
        }
    }

    private void ensureNumericParam(String ... params) {
        try {
            new BigDecimal(params[0]);
        }
        catch (Exception e) {
            throw new MigrationException("The version number must be a numeric integer.  " + e, e);
        }
    }

    private void ensureVersionExists(String ... params) {
        List<Change> migrations = this.getMigrations();
        if (!migrations.contains(new Change(new BigDecimal(params[0])))) {
            throw new MigrationException("A migration for the specified version number does not exist.");
        }
    }
}

