/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.type.BigDecimalTypeHandler;
import org.apache.ibatis.type.BigIntegerTypeHandler;
import org.apache.ibatis.type.BlobTypeHandler;
import org.apache.ibatis.type.BooleanTypeHandler;
import org.apache.ibatis.type.ByteArrayTypeHandler;
import org.apache.ibatis.type.ByteTypeHandler;
import org.apache.ibatis.type.ClobTypeHandler;
import org.apache.ibatis.type.DateOnlyTypeHandler;
import org.apache.ibatis.type.DateTypeHandler;
import org.apache.ibatis.type.DoubleTypeHandler;
import org.apache.ibatis.type.EnumTypeHandler;
import org.apache.ibatis.type.FloatTypeHandler;
import org.apache.ibatis.type.IntegerTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.LongTypeHandler;
import org.apache.ibatis.type.MappedTypes;
import org.apache.ibatis.type.NClobTypeHandler;
import org.apache.ibatis.type.NStringTypeHandler;
import org.apache.ibatis.type.ShortTypeHandler;
import org.apache.ibatis.type.SqlDateTypeHandler;
import org.apache.ibatis.type.SqlTimeTypeHandler;
import org.apache.ibatis.type.SqlTimestampTypeHandler;
import org.apache.ibatis.type.StringTypeHandler;
import org.apache.ibatis.type.TimeOnlyTypeHandler;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.UnknownTypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeHandlerRegistry {
    private static final Map<Class<?>, Class<?>> reversePrimitiveMap = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Byte.class, Byte.TYPE);
            this.put(Short.class, Short.TYPE);
            this.put(Integer.class, Integer.TYPE);
            this.put(Long.class, Long.TYPE);
            this.put(Float.class, Float.TYPE);
            this.put(Double.class, Double.TYPE);
            this.put(Boolean.class, Boolean.TYPE);
        }
    };
    private final Map<JdbcType, TypeHandler> JDBC_TYPE_HANDLER_MAP = new EnumMap<JdbcType, TypeHandler>(JdbcType.class);
    private final Map<Class<?>, Map<JdbcType, TypeHandler>> TYPE_HANDLER_MAP = new HashMap();
    private final TypeHandler UNKNOWN_TYPE_HANDLER = new UnknownTypeHandler(this);

    public TypeHandlerRegistry() {
        this.register(Boolean.class, (TypeHandler)new BooleanTypeHandler());
        this.register(Boolean.TYPE, (TypeHandler)new BooleanTypeHandler());
        this.register(JdbcType.BOOLEAN, (TypeHandler)new BooleanTypeHandler());
        this.register(JdbcType.BIT, (TypeHandler)new BooleanTypeHandler());
        this.register(Byte.class, (TypeHandler)new ByteTypeHandler());
        this.register(Byte.TYPE, (TypeHandler)new ByteTypeHandler());
        this.register(JdbcType.TINYINT, (TypeHandler)new ByteTypeHandler());
        this.register(Short.class, (TypeHandler)new ShortTypeHandler());
        this.register(Short.TYPE, (TypeHandler)new ShortTypeHandler());
        this.register(JdbcType.SMALLINT, (TypeHandler)new ShortTypeHandler());
        this.register(Integer.class, (TypeHandler)new IntegerTypeHandler());
        this.register(Integer.TYPE, (TypeHandler)new IntegerTypeHandler());
        this.register(JdbcType.INTEGER, (TypeHandler)new IntegerTypeHandler());
        this.register(Long.class, (TypeHandler)new LongTypeHandler());
        this.register(Long.TYPE, (TypeHandler)new LongTypeHandler());
        this.register(Float.class, (TypeHandler)new FloatTypeHandler());
        this.register(Float.TYPE, (TypeHandler)new FloatTypeHandler());
        this.register(JdbcType.FLOAT, (TypeHandler)new FloatTypeHandler());
        this.register(Double.class, (TypeHandler)new DoubleTypeHandler());
        this.register(Double.TYPE, (TypeHandler)new DoubleTypeHandler());
        this.register(JdbcType.DOUBLE, (TypeHandler)new DoubleTypeHandler());
        this.register(String.class, (TypeHandler)new StringTypeHandler());
        this.register(String.class, JdbcType.CHAR, new StringTypeHandler());
        this.register(String.class, JdbcType.CLOB, new ClobTypeHandler());
        this.register(String.class, JdbcType.VARCHAR, new StringTypeHandler());
        this.register(String.class, JdbcType.LONGVARCHAR, new ClobTypeHandler());
        this.register(String.class, JdbcType.NVARCHAR, new NStringTypeHandler());
        this.register(String.class, JdbcType.NCHAR, new NStringTypeHandler());
        this.register(String.class, JdbcType.NCLOB, new NClobTypeHandler());
        this.register(JdbcType.CHAR, (TypeHandler)new StringTypeHandler());
        this.register(JdbcType.VARCHAR, (TypeHandler)new StringTypeHandler());
        this.register(JdbcType.CLOB, (TypeHandler)new ClobTypeHandler());
        this.register(JdbcType.LONGVARCHAR, (TypeHandler)new ClobTypeHandler());
        this.register(JdbcType.NVARCHAR, (TypeHandler)new NStringTypeHandler());
        this.register(JdbcType.NCHAR, (TypeHandler)new NStringTypeHandler());
        this.register(JdbcType.NCLOB, (TypeHandler)new NClobTypeHandler());
        this.register(BigInteger.class, (TypeHandler)new BigIntegerTypeHandler());
        this.register(JdbcType.BIGINT, (TypeHandler)new LongTypeHandler());
        this.register(BigDecimal.class, (TypeHandler)new BigDecimalTypeHandler());
        this.register(JdbcType.REAL, (TypeHandler)new BigDecimalTypeHandler());
        this.register(JdbcType.DECIMAL, (TypeHandler)new BigDecimalTypeHandler());
        this.register(JdbcType.NUMERIC, (TypeHandler)new BigDecimalTypeHandler());
        this.register(byte[].class, (TypeHandler)new ByteArrayTypeHandler());
        this.register(byte[].class, JdbcType.BLOB, new BlobTypeHandler());
        this.register(byte[].class, JdbcType.LONGVARBINARY, new BlobTypeHandler());
        this.register(JdbcType.LONGVARBINARY, (TypeHandler)new BlobTypeHandler());
        this.register(JdbcType.BLOB, (TypeHandler)new BlobTypeHandler());
        this.register(Object.class, this.UNKNOWN_TYPE_HANDLER);
        this.register(Object.class, JdbcType.OTHER, this.UNKNOWN_TYPE_HANDLER);
        this.register(JdbcType.OTHER, this.UNKNOWN_TYPE_HANDLER);
        this.register(java.util.Date.class, (TypeHandler)new DateTypeHandler());
        this.register(java.util.Date.class, JdbcType.DATE, new DateOnlyTypeHandler());
        this.register(java.util.Date.class, JdbcType.TIME, new TimeOnlyTypeHandler());
        this.register(JdbcType.TIMESTAMP, (TypeHandler)new DateTypeHandler());
        this.register(JdbcType.DATE, (TypeHandler)new DateOnlyTypeHandler());
        this.register(JdbcType.TIME, (TypeHandler)new TimeOnlyTypeHandler());
        this.register(Date.class, (TypeHandler)new SqlDateTypeHandler());
        this.register(Time.class, (TypeHandler)new SqlTimeTypeHandler());
        this.register(Timestamp.class, (TypeHandler)new SqlTimestampTypeHandler());
    }

    public boolean hasTypeHandler(Class<?> javaType) {
        return this.hasTypeHandler(javaType, null);
    }

    public boolean hasTypeHandler(Class<?> javaType, JdbcType jdbcType) {
        return javaType != null && this.getTypeHandler(javaType, jdbcType) != null;
    }

    public TypeHandler getTypeHandler(Class<?> type) {
        return this.getTypeHandler(type, null);
    }

    public TypeHandler getTypeHandler(JdbcType jdbcType) {
        return this.JDBC_TYPE_HANDLER_MAP.get((Object)jdbcType);
    }

    public TypeHandler getTypeHandler(Class<?> type, JdbcType jdbcType) {
        Map<JdbcType, TypeHandler> jdbcHandlerMap = this.TYPE_HANDLER_MAP.get(type);
        TypeHandler handler = null;
        if (jdbcHandlerMap != null && (handler = jdbcHandlerMap.get((Object)jdbcType)) == null) {
            handler = jdbcHandlerMap.get(null);
        }
        if (handler == null && type != null && Enum.class.isAssignableFrom(type)) {
            handler = new EnumTypeHandler(type);
        }
        return handler;
    }

    public TypeHandler getUnkownTypeHandler() {
        return this.UNKNOWN_TYPE_HANDLER;
    }

    public void register(JdbcType jdbcType, TypeHandler handler) {
        this.JDBC_TYPE_HANDLER_MAP.put(jdbcType, handler);
    }

    public void register(Class<?> type, TypeHandler handler) {
        this.register(type, null, handler);
    }

    public void register(Class<?> type, JdbcType jdbcType, TypeHandler handler) {
        Map<JdbcType, TypeHandler> map = this.TYPE_HANDLER_MAP.get(type);
        if (map == null) {
            map = new HashMap<JdbcType, TypeHandler>();
            this.TYPE_HANDLER_MAP.put(type, map);
        }
        map.put(jdbcType, handler);
        if (reversePrimitiveMap.containsKey(type)) {
            this.register(reversePrimitiveMap.get(type), jdbcType, handler);
        }
    }

    public void register(String packageName) {
        ResolverUtil resolverUtil = new ResolverUtil();
        resolverUtil.find(new ResolverUtil.IsA(TypeHandler.class), packageName);
        Set handlerSet = resolverUtil.getClasses();
        for (Class type : handlerSet) {
            TypeHandler handler;
            MappedTypes annotation = type.getAnnotation(MappedTypes.class);
            try {
                handler = (TypeHandler)type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to find a usable constructor for " + type, e);
            }
            if (null == annotation) continue;
            MappedTypes mappedType = annotation;
            for (Class handledType : mappedType.value()) {
                this.register(handledType, handler);
            }
        }
    }
}

