/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.WebScript;

public class AbstractMessageHelper {
    private WebScript webscript;

    public AbstractMessageHelper(WebScript webscript) {
        if (webscript == null) {
            throw new IllegalArgumentException("WebScript must be provided to constructor.");
        }
        this.webscript = webscript;
    }

    protected final String resolveMessage(String id, Object ... args) {
        String result = null;
        ResourceBundle resources = this.webscript.getResources();
        if (resources != null) {
            try {
                result = resources.getString(id);
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        if (result == null) {
            result = I18NUtil.getMessage((String)id);
        }
        if (args.length == 0) {
            if (result == null) {
                result = id;
            }
        } else {
            result = result != null ? MessageFormat.format(result, args) : id;
        }
        return result;
    }
}

