/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import org.springframework.extensions.webscripts.WebScriptException;

public class MediaType {
    private String type;
    private String subtype;
    private String params = "";
    private float quality = 1.0f;

    public MediaType(String mediatype) {
        if (mediatype == null || mediatype.length() == 0) {
            throw new WebScriptException("Invalid mediatype: " + mediatype);
        }
        String[] parts = mediatype.split("/");
        if (parts.length != 2) {
            throw new WebScriptException("Invalid mediatype: " + mediatype + " does not consists of type and subtype");
        }
        this.type = parts[0].trim();
        int paramsIdx = parts[1].indexOf(59);
        if (paramsIdx == -1) {
            this.subtype = parts[1];
        } else {
            int qualityIdx;
            String params = parts[1].substring(paramsIdx);
            String[] qualityParts = params.substring((qualityIdx = params.lastIndexOf(";")) + 1).split("=");
            if (qualityParts.length == 2 && qualityParts[0].trim().equals("q")) {
                this.subtype = parts[1].substring(0, paramsIdx).replace(" ", "");
                this.quality = new Float(qualityParts[1].trim()).floatValue();
                if (qualityIdx > 0) {
                    this.params = params.substring(1, qualityIdx).replace(" ", "");
                }
            } else {
                this.subtype = parts[1].substring(0, paramsIdx).replace(" ", "");
                this.params = params.substring(1).replace(" ", "");
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getParams() {
        return this.params;
    }

    public float getQuality() {
        return this.quality;
    }

    public float compare(MediaType to) {
        boolean paramsWildcard;
        boolean typeWildcard = to.type.equals("*");
        boolean subtypeWildcard = to.subtype.equals("*");
        boolean bl = paramsWildcard = to.params.length() == 0;
        if ((typeWildcard || this.type.equals(to.type)) && (subtypeWildcard || this.subtype.equals(to.subtype)) && (paramsWildcard || this.params.equals(to.params))) {
            return (typeWildcard ? 0.0f : 10.0f) + (subtypeWildcard ? 0.0f : 100.0f) + (paramsWildcard ? 0.0f : 1000.0f) + to.quality;
        }
        return 0.0f;
    }

    private String toMediaType() {
        return this.type + "/" + this.subtype + (this.params.length() == 0 ? "" : ";" + this.params);
    }

    public int hashCode() {
        return this.toMediaType().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof MediaType) {
            return this.type.equals(((MediaType)other).type) && this.subtype.equals(((MediaType)other).subtype) && this.params.equals(((MediaType)other).params);
        }
        return false;
    }

    public String toString() {
        return this.toMediaType() + ";q=" + this.quality;
    }

    public static void main(String[] args) {
        MediaType one = new MediaType("*/*");
        System.out.println(one.toString());
        MediaType two = new MediaType("a/b");
        System.out.println(two.toString());
        MediaType three = new MediaType("a/*");
        System.out.println(three.toString());
        MediaType four = new MediaType("a/*;b=1");
        System.out.println(four.toString());
        MediaType five = new MediaType("a/* ; b=1");
        System.out.println(five.toString());
        System.out.println(four.equals(five));
        MediaType six = new MediaType("a/*;q=0.1");
        System.out.println(six.toString());
        MediaType seven = new MediaType("a/*;q = 0.1");
        System.out.println(seven.toString());
        MediaType eight = new MediaType("a/*; q = 0.1");
        System.out.println(eight.toString());
        MediaType nine = new MediaType("a/*;b=1; q = 0.1");
        System.out.println(nine.toString());
        MediaType ten = new MediaType("a/*;");
        System.out.println(ten.toString());
        MediaType eleven = new MediaType("a/*;b=1;c=2;q=1.0");
        System.out.println(eleven.toString());
        MediaType textHtmlLevel1 = new MediaType("text/html;level=1");
        MediaType textHtml = new MediaType("text/html");
        MediaType textPlain = new MediaType("text/plain");
        MediaType imageJpeg = new MediaType("image/jpeg");
        MediaType textHtmlLevel2 = new MediaType("text/html;level=2");
        MediaType textHtmlLevel3 = new MediaType("text/html;level=3");
        MediaType acceptTextStar = new MediaType("text/*;q=0.3");
        MediaType acceptTextHtml = new MediaType("text/html;q=0.7");
        MediaType acceptTextHtmlLevel1 = new MediaType("text/html;level=1");
        MediaType acceptTextHtmlLevel2 = new MediaType("text/html;level=2;q=0.4");
        MediaType acceptStarStar = new MediaType("*/*;q=0.5");
        MediaType[] negotiated = new MediaType[]{textHtmlLevel1, textHtml, textPlain, imageJpeg, textHtmlLevel2, textHtmlLevel3};
        MediaType[] accept = new MediaType[]{acceptTextStar, acceptTextHtml, acceptTextHtmlLevel1, acceptTextHtmlLevel2, acceptStarStar};
        for (MediaType neg : negotiated) {
            System.out.println("Testing " + neg.toMediaType());
            float q = 0.0f;
            for (MediaType acc : accept) {
                float accq = neg.compare(acc);
                System.out.println(" Compare to " + acc.toString() + " = " + accq);
                if (!(accq > q)) continue;
                q = accq;
            }
            System.out.println(" Result = " + q);
        }
    }
}

