/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import org.springframework.extensions.webscripts.MediaType;

public final class NegotiatedFormat {
    private final MediaType mediaType;
    private final String format;

    public NegotiatedFormat(MediaType mediaType, String format) {
        this.mediaType = mediaType;
        this.format = format;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getFormat() {
        return this.format;
    }

    public static String negotiateFormat(String accept, NegotiatedFormat[] negotiatedFormats) {
        String[] acceptTypes;
        String format = null;
        float match = 0.0f;
        for (String acceptType : acceptTypes = accept.split(",")) {
            MediaType acceptMediaType = new MediaType(acceptType);
            for (NegotiatedFormat negotiatedFormat : negotiatedFormats) {
                float negotiatedMatch = negotiatedFormat.getMediaType().compare(acceptMediaType);
                if (!(negotiatedMatch > match)) continue;
                match = negotiatedMatch;
                format = negotiatedFormat.getFormat();
            }
        }
        return format;
    }
}

