/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.atom;

import java.util.List;
import java.util.Map;
import org.apache.abdera.factory.ExtensionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.webscripts.atom.AbderaServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbderaExtension
implements InitializingBean {
    private AbderaServiceImpl abderaService;
    private String defaultNamespace = null;
    private Map<String, String> qnames = null;
    private List<ExtensionFactory> extensionFactories = null;

    public void setAbderaService(AbderaServiceImpl abderaService) {
        this.abderaService = abderaService;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public void setQNames(Map<String, String> qnames) {
        this.qnames = qnames;
    }

    public void setExtensionFactories(List<ExtensionFactory> extensionFactories) {
        this.extensionFactories = extensionFactories;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.abderaService == null) {
            throw new WebScriptsPlatformException("Abdera Service not specified");
        }
        if (this.qnames != null) {
            for (Map.Entry<String, String> entry : this.qnames.entrySet()) {
                String qname = entry.getValue();
                if (this.defaultNamespace != null && qname.indexOf(123) == -1) {
                    qname = "{" + this.defaultNamespace + "}" + qname;
                }
                this.abderaService.registerQName(entry.getKey(), qname);
            }
        }
        if (this.extensionFactories != null) {
            for (ExtensionFactory extensionFactory : this.extensionFactories) {
                this.abderaService.registerExtensionFactory(extensionFactory);
            }
        }
    }
}

