/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.HttpConnector;
import org.springframework.extensions.webscripts.connector.RemoteClient;

public class AlfrescoConnector
extends HttpConnector {
    private static final String UNAUTHENTICATED_MODE_GUEST = "guest";
    private static final String PARAM_TICKETNAME_ALF_TICKET = "alf_ticket";

    public AlfrescoConnector(RemoteConfigElement.ConnectorDescriptor descriptor, String endpoint) {
        super(descriptor, endpoint);
    }

    protected void applyRequestAuthentication(RemoteClient remoteClient, ConnectorContext context) {
        String alfTicket = null;
        if (context != null) {
            alfTicket = context.getParameters().get(PARAM_TICKETNAME_ALF_TICKET);
        }
        if (this.getCredentials() != null && this.getConnectorSession() != null) {
            alfTicket = this.getConnectorSession().getParameter("alfTicket");
        }
        if (alfTicket != null) {
            remoteClient.setTicket(alfTicket);
            remoteClient.setTicketName(PARAM_TICKETNAME_ALF_TICKET);
        } else {
            String unauthenticatedMode = this.descriptor.getUnauthenticatedMode();
            if (UNAUTHENTICATED_MODE_GUEST.equalsIgnoreCase(unauthenticatedMode)) {
                remoteClient.setTicketName(UNAUTHENTICATED_MODE_GUEST);
                remoteClient.setTicket("true");
            }
        }
    }
}

