/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;

public final class JSONWriter {
    private Writer out;
    private Stack<Boolean> stack = new Stack();

    public JSONWriter(Writer out) {
        this.out = out;
        this.stack.push(Boolean.FALSE);
    }

    public JSONWriter startArray() throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write("[");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        this.stack.push(Boolean.FALSE);
        return this;
    }

    public JSONWriter endArray() throws IOException {
        this.out.write("]");
        this.stack.pop();
        return this;
    }

    public JSONWriter startObject() throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write("{");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        this.stack.push(Boolean.FALSE);
        return this;
    }

    public JSONWriter endObject() throws IOException {
        this.out.write("}");
        this.stack.pop();
        return this;
    }

    public JSONWriter startValue(String name) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        this.stack.push(Boolean.FALSE);
        return this;
    }

    public JSONWriter endValue() {
        this.stack.pop();
        return this;
    }

    public JSONWriter writeValue(String name, String value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": \"");
        this.out.write(JSONWriter.encodeJSONString(value));
        this.out.write(34);
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(String name, int value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.out.write(Integer.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(String name, long value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.out.write(Long.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(String name, float value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.out.write(Float.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(String name, double value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.out.write(Double.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(String name, boolean value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.out.write(Boolean.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(String value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(JSONWriter.encodeJSONString(value));
        this.out.write(34);
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(int value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(Integer.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(long value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(Long.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(float value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(Float.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(double value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(Double.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(boolean value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(Boolean.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeNullValue() throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write("null");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeNullValue(String name) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": null");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public static String encodeJSONString(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        StringBuilder sb = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            String enc = null;
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    enc = "\\\\";
                    break;
                }
                case '\"': {
                    enc = "\\\"";
                    break;
                }
                case '/': {
                    enc = "\\/";
                    break;
                }
                case '\b': {
                    enc = "\\b";
                    break;
                }
                case '\t': {
                    enc = "\\t";
                    break;
                }
                case '\n': {
                    enc = "\\n";
                    break;
                }
                case '\f': {
                    enc = "\\f";
                    break;
                }
                case '\r': {
                    enc = "\\r";
                    break;
                }
                default: {
                    if (c < '\u0080') break;
                    String u = "000" + Integer.toHexString(c);
                    enc = "\\u" + u.substring(u.length() - 4);
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = s.substring(0, i);
                    sb = new StringBuilder(i + 8);
                    sb.append(soFar);
                }
                sb.append(enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }
}

