/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.portlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceURL;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.WebScriptResponseImpl;
import org.springframework.extensions.webscripts.portlet.WebScriptPortletRequest;
import org.springframework.extensions.webscripts.ui.common.StringUtils;

public class WebScriptPortletResponse
extends WebScriptResponseImpl {
    private RenderResponse res;
    private static final String ENCODE_FUNCTION = "{ $name$: function(url) { var out = \"$actionUrl$\"; var argsIndex = url.indexOf(\"?\"); if (argsIndex == -1) {    out += \"&scriptUrl=\" + escape(url); } else {    out += \"&scriptUrl=\" + escape(url.substring(0, argsIndex));    var args = url.substring(argsIndex + 1).split(\"&\");    for (var i=0; i<args.length; i++)    {       out += \"&arg.\" + args[i];    } } return out; } }";
    private static final String ENCODE_RESOURCE_URL_FUNCTION = "{ $name$: function(url) { var out = \"$resourceUrl$\"; var i = out.indexOf(\"__RESOURCEID__\"); out = out.substring(0, i) + url + out.substring(i, out.length); return out; } }";

    WebScriptPortletResponse(Runtime container, RenderResponse res) {
        super(container);
        this.res = res;
    }

    public RenderResponse getRenderResponse() {
        return this.res;
    }

    public void setStatus(int status) {
    }

    public void setHeader(String name, String value) {
    }

    public void addHeader(String name, String value) {
    }

    public void setContentType(String contentType) {
        this.res.setContentType(contentType);
    }

    public void setContentEncoding(String contentEncoding) {
    }

    public void setCache(Cache cache) {
    }

    public void reset() {
        try {
            this.res.reset();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public Writer getWriter() throws IOException {
        return this.res.getWriter();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.res.getPortletOutputStream();
    }

    public String encodeScriptUrl(String url) {
        String[] parameterNames;
        WebScriptPortletRequest req = new WebScriptPortletRequest(this.getRuntime(), null, url, null);
        PortletURL portletUrl = this.res.createActionURL();
        portletUrl.setParameter("scriptUrl", req.getServicePath());
        for (String parameterName : parameterNames = req.getParameterNames()) {
            portletUrl.setParameter("arg." + parameterName, req.getParameter(parameterName));
        }
        return portletUrl.toString();
    }

    public String getEncodeScriptUrlFunction(String name) {
        PortletURL portletUrl = this.res.createActionURL();
        String func = ENCODE_FUNCTION.replace("$name$", name);
        func = func.replace("$actionUrl$", portletUrl.toString());
        return StringUtils.encodeJavascript(func);
    }

    public String encodeResourceUrl(String url) {
        String[] parameterNames;
        WebScriptPortletRequest req = new WebScriptPortletRequest(this.getRuntime(), null, url, null);
        ResourceURL resourceUrl = this.res.createResourceURL();
        resourceUrl.setResourceID(url);
        resourceUrl.setParameter("scriptUrl", req.getServicePath());
        for (String parameterName : parameterNames = req.getParameterNames()) {
            resourceUrl.setParameter("arg." + parameterName, req.getParameter(parameterName));
        }
        return resourceUrl.toString();
    }

    public String getEncodeResourceUrlFunction(String name) {
        ResourceURL resourceUrl = this.res.createResourceURL();
        resourceUrl.setResourceID("__RESOURCEID__");
        String func = ENCODE_FUNCTION.replace("$name$", name);
        func = func.replace("$resourceUrl$", resourceUrl.toString());
        return StringUtils.encodeJavascript(func);
    }
}

