/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.CredentialsImpl;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class EndPointProxyServlet
extends HttpServlet {
    private static final String USER_ID = "_alf_USER_ID";
    private static final String PARAM_ALF_TICKET = "alf_ticket";
    private static Log logger = LogFactory.getLog(EndPointProxyServlet.class);
    private static final long serialVersionUID = -176412355613122789L;
    protected RemoteConfigElement config;
    protected ConnectorService connectorService;

    public void init() throws ServletException {
        super.init();
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        ConfigService configService = (ConfigService)context.getBean("web.config");
        this.config = (RemoteConfigElement)configService.getConfig((Object)"Remote").getConfigElement("remote");
        this.connectorService = (ConnectorService)context.getBean("connector.service");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String uri = req.getRequestURI().substring(req.getContextPath().length());
        StringTokenizer t = new StringTokenizer(uri, "/");
        String servletName = t.nextToken();
        if (!t.hasMoreTokens()) {
            throw new IllegalArgumentException("Proxy URL did not specify endpoint id.");
        }
        String endpointId = t.nextToken();
        StringBuilder buf = new StringBuilder(64);
        if (t.hasMoreTokens()) {
            do {
                buf.append('/');
                buf.append(t.nextToken());
            } while (t.hasMoreTokens());
        } else {
            buf.append('/');
        }
        try {
            ConnectorContext context;
            Connector connector;
            RemoteConfigElement.EndpointDescriptor descriptor = this.config.getEndpointDescriptor(endpointId);
            if (descriptor == null || descriptor.getUnsecure()) {
                throw new WebScriptsPlatformException("Invalid EndPoint Id: " + endpointId);
            }
            String ticket = req.getParameter(PARAM_ALF_TICKET);
            String userId = (String)req.getSession().getAttribute(USER_ID);
            if (userId != null) {
                connector = this.connectorService.getConnector(endpointId, userId, req.getSession());
            } else if (ticket != null || descriptor.getIdentity() == RemoteConfigElement.IdentityType.NONE || descriptor.getIdentity() == RemoteConfigElement.IdentityType.DECLARED || descriptor.getExternalAuth()) {
                connector = this.connectorService.getConnector(endpointId, req.getSession());
            } else if (descriptor.getBasicAuth()) {
                String authorization = req.getHeader("Authorization");
                if (authorization == null || authorization.length() == 0) {
                    res.setStatus(401, "No USER_ID found in session and requested endpoint requires authentication.");
                    res.setHeader("WWW-Authenticate", "Basic realm=\"Alfresco\"");
                    return;
                }
                String[] authParts = authorization.split(" ");
                if (!authParts[0].equalsIgnoreCase("basic")) {
                    throw new WebScriptsPlatformException("Authorization '" + authParts[0] + "' not supported.");
                }
                String[] values = new String(Base64.decode((String)authParts[1])).split(":");
                if (values.length != 2) throw new WebScriptsPlatformException("Authorization request did not provide user/pass.");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authenticating (BASIC HTTP) user " + values[0]));
                }
                connector = this.connectorService.getConnector(endpointId, values[0], req.getSession());
                CredentialsImpl credentials = new CredentialsImpl(endpointId);
                credentials.setProperty("cleartextUsername", values[0]);
                credentials.setProperty("cleartextPassword", values[1]);
                connector.setCredentials(credentials);
            } else {
                res.setStatus(401, "No USER_ID found in session and requested endpoint requires authentication.");
                return;
            }
            if (ticket == null) {
                context = new ConnectorContext();
            } else {
                HashMap<String, String> params = new HashMap<String, String>(1, 1.0f);
                params.put(PARAM_ALF_TICKET, ticket);
                context = new ConnectorContext(params, null);
            }
            context.setContentType(req.getContentType());
            context.setMethod(HttpMethod.valueOf(req.getMethod().toUpperCase()));
            String q = req.getQueryString();
            String url = String.valueOf(buf.toString()) + (q != null && q.length() != 0 ? "?" + q : "");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"EndPointProxyServlet preparing to proxy:");
                logger.debug((Object)(" - endpointId: " + endpointId));
                logger.debug((Object)(" - userId: " + userId));
                logger.debug((Object)(" - connector: " + connector));
                logger.debug((Object)(" - method: " + (Object)((Object)context.getMethod())));
                logger.debug((Object)(" - url: " + url));
            }
            Response response = connector.call(url, context, req, res);
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)("Return code: " + response.getStatus().getCode()));
            if (response.getStatus().getCode() != 500) return;
            logger.debug((Object)("Error detected: " + response.getStatus().getMessage() + "\n" + response.getStatus().getException().toString()));
            return;
        }
        catch (Throwable err) {
            throw new WebScriptsPlatformException("Error during endpoint proxy processing: " + err.getMessage(), err);
        }
    }
}

