/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.ui.common;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlFormRendererBase;
import org.springframework.extensions.webscripts.ui.common.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSFUtils {
    private JSFUtils() {
    }

    public static void outputAttribute(ResponseWriter out, Object attr, String mapping) throws IOException {
        if (attr != null) {
            out.write(32);
            out.write(mapping);
            out.write("=\"");
            out.write(attr.toString());
            out.write(34);
        }
    }

    public static String getActionHiddenFieldName(FacesContext context, UIComponent component) {
        return JSFUtils.getParentForm(context, component).getClientId(context) + ':' + "act";
    }

    public static void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (component.isRendered()) {
            component.encodeBegin(context);
            if (component.getRendersChildren()) {
                component.encodeChildren(context);
            } else if (component.getChildCount() != 0) {
                Iterator i = component.getChildren().iterator();
                while (i.hasNext()) {
                    JSFUtils.encodeRecursive(context, (UIComponent)i.next());
                }
            }
            component.encodeEnd(context);
        }
    }

    public static String generateFormSubmit(FacesContext context, UIComponent component, String fieldId, String fieldValue) {
        return JSFUtils.generateFormSubmit(context, component, fieldId, fieldValue, false, null);
    }

    public static String generateFormSubmit(FacesContext context, UIComponent component, String fieldId, String fieldValue, Map<String, String> params) {
        return JSFUtils.generateFormSubmit(context, component, fieldId, fieldValue, false, params);
    }

    public static String generateFormSubmit(FacesContext context, UIComponent component, String fieldId, String fieldValue, boolean valueIsParam, Map<String, String> params) {
        UIForm form = JSFUtils.getParentForm(context, component);
        if (form == null) {
            throw new IllegalStateException("Must nest components inside UIForm to generate form submit!");
        }
        String formClientId = form.getClientId(context);
        StringBuilder buf = new StringBuilder(200);
        buf.append("document.forms['");
        buf.append(formClientId);
        buf.append("']['");
        buf.append(fieldId);
        buf.append("'].value=");
        if (!valueIsParam) {
            buf.append("'");
        }
        buf.append(fieldValue);
        if (!valueIsParam) {
            buf.append("'");
        }
        buf.append(";");
        if (params != null) {
            for (String name : params.keySet()) {
                buf.append("document.forms['");
                buf.append(formClientId);
                buf.append("']['");
                buf.append(name);
                buf.append("'].value='");
                buf.append(StringUtils.replace(params.get(name), "'", "\\'"));
                buf.append("';");
                HtmlFormRendererBase.addHiddenCommandParameter((FacesContext)context, (UIComponent)form, (String)name);
            }
        }
        buf.append("document.forms['");
        buf.append(formClientId);
        buf.append("'].submit();");
        if (!valueIsParam) {
            buf.append("return false;");
        }
        HtmlFormRendererBase.addHiddenCommandParameter((FacesContext)context, (UIComponent)form, (String)fieldId);
        return buf.toString();
    }

    public static String generateFormSubmit(FacesContext context, UIComponent component) {
        UIForm form = JSFUtils.getParentForm(context, component);
        if (form == null) {
            throw new IllegalStateException("Must nest components inside UIForm to generate form submit!");
        }
        String formClientId = form.getClientId(context);
        StringBuilder buf = new StringBuilder(48);
        buf.append("document.forms['");
        buf.append(formClientId);
        buf.append("'].submit()");
        buf.append(";return false;");
        return buf.toString();
    }

    public static String buildImageTag(FacesContext context, String image, int width, int height, String alt, String onclick) {
        return JSFUtils.buildImageTag(context, image, width, height, alt, onclick, null);
    }

    public static String buildImageTag(FacesContext context, String image, int width, int height, String alt, String onclick, String verticalAlign) {
        StringBuilder styleBuf;
        StringBuilder buf = new StringBuilder(200);
        String style = "border-width:0px;";
        buf.append("<img src='").append(context.getExternalContext().getRequestContextPath()).append(image).append("' width='").append(width).append("' height='").append(height).append("'");
        if (alt != null) {
            alt = StringUtils.encode(alt);
            buf.append(" alt='").append(alt).append("' title='").append(alt).append("'");
        } else {
            buf.append(" alt=''");
        }
        if (verticalAlign != null) {
            styleBuf = new StringBuilder(40);
            styleBuf.append(style).append("vertical-align:").append(verticalAlign).append(";");
            style = styleBuf.toString();
        }
        if (onclick != null) {
            buf.append(" onclick=\"").append(onclick).append('\"');
            styleBuf = new StringBuilder(style.length() + 16);
            styleBuf.append(style).append("cursor:pointer;");
            style = styleBuf.toString();
        }
        buf.append(" style='").append(style).append("'/>");
        return buf.toString();
    }

    public static String buildImageTag(FacesContext context, String image, int width, int height, String alt) {
        return JSFUtils.buildImageTag(context, image, width, height, alt, null);
    }

    public static String buildImageTag(FacesContext context, String image, String alt) {
        return JSFUtils.buildImageTag(context, image, alt, null);
    }

    public static String buildImageTag(FacesContext context, String image, String alt, String verticalAlign) {
        StringBuilder buf = new StringBuilder(128);
        buf.append("<img src='").append(context.getExternalContext().getRequestContextPath()).append(image).append("' ");
        String style = "border-width:0px;";
        if (alt != null) {
            alt = StringUtils.encode(alt);
            buf.append(" alt='").append(alt).append("' title='").append(alt).append("'");
        } else {
            buf.append(" alt=''");
        }
        if (verticalAlign != null) {
            StringBuilder styleBuf = new StringBuilder(40);
            styleBuf.append(style).append("vertical-align:").append(verticalAlign).append(";");
            style = styleBuf.toString();
        }
        buf.append(" style='").append(style).append("'/>");
        return buf.toString();
    }

    public static UIForm getParentForm(FacesContext context, UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return (UIForm)parent;
    }

    public static UIComponent getParentNamingContainer(FacesContext context, UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof NamingContainer); parent = parent.getParent()) {
        }
        return parent;
    }

    public static boolean isComponentDisabledOrReadOnly(UIComponent component) {
        Object readOnlyAttr;
        boolean disabled = false;
        boolean readOnly = false;
        Object disabledAttr = component.getAttributes().get("disabled");
        if (disabledAttr != null) {
            disabled = disabledAttr.equals(Boolean.TRUE);
        }
        if (!disabled && (readOnlyAttr = component.getAttributes().get("readonly")) != null) {
            readOnly = readOnlyAttr.equals(Boolean.TRUE);
        }
        return disabled || readOnly;
    }

    public static void processActionMethod(FacesContext context, MethodBinding method, ActionEvent event) {
        try {
            method.invoke(context, new Object[]{event});
        }
        catch (EvaluationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof AbortProcessingException) {
                throw (AbortProcessingException)cause;
            }
            throw e;
        }
    }
}

