/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary.constraint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.repo.dictionary.constraint.AbstractConstraint;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfValuesConstraint
extends AbstractConstraint {
    private static final String LOV_CONSTRAINT_VALUE = "listconstraint";
    public static final String CONSTRAINT_TYPE = "LIST";
    public static final String CASE_SENSITIVE_PARAM = "caseSensitive";
    public static final String ALLOWED_VALUES_PARAM = "allowedValues";
    public static final String SORTED_PARAM = "sorted";
    private static final String ERR_NO_VALUES = "d_dictionary.constraint.list_of_values.no_values";
    private static final String ERR_NON_STRING = "d_dictionary.constraint.string_length.non_string";
    private static final String ERR_INVALID_VALUE = "d_dictionary.constraint.list_of_values.invalid_value";
    private List<String> allowedValues;
    private List<String> allowedValuesUpper;
    protected boolean caseSensitive = true;
    protected boolean sorted = false;

    @Override
    public String getType() {
        return CONSTRAINT_TYPE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("ListOfValuesConstraint").append("[ allowedValues=").append(this.allowedValues).append(", caseSensitive=").append(this.caseSensitive).append(", sorted=").append(this.sorted).append("]");
        return sb.toString();
    }

    public List<String> getAllowedValues() {
        List<String> rawValues = this.getRawAllowedValues();
        if (this.sorted) {
            ArrayList<String> values = new ArrayList<String>(rawValues);
            Collections.sort(values);
            return values;
        }
        return rawValues;
    }

    protected List<String> getRawAllowedValues() {
        return this.allowedValues;
    }

    public String getDisplayLabel(String constraintAllowableValue) {
        if (!this.allowedValues.contains(constraintAllowableValue)) {
            return null;
        }
        String key = LOV_CONSTRAINT_VALUE;
        key = key + "." + this.getShortName();
        key = key + "." + constraintAllowableValue;
        String message = I18NUtil.getMessage((String)(key = StringUtils.replace((String)key, (String)":", (String)"_")), (Locale)I18NUtil.getLocale());
        return message == null ? constraintAllowableValue : message;
    }

    public void setAllowedValues(List allowedValues) {
        if (allowedValues == null) {
            throw new DictionaryException(ERR_NO_VALUES);
        }
        int valueCount = allowedValues.size();
        if (valueCount == 0) {
            throw new DictionaryException(ERR_NO_VALUES);
        }
        this.allowedValues = Collections.unmodifiableList(allowedValues);
        this.allowedValuesUpper = new ArrayList<String>(valueCount);
        for (String allowedValue : this.allowedValues) {
            this.allowedValuesUpper.add(allowedValue.toUpperCase());
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.checkPropertyNotNull(ALLOWED_VALUES_PARAM, this.allowedValues);
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put(CASE_SENSITIVE_PARAM, this.caseSensitive);
        params.put(ALLOWED_VALUES_PARAM, this.allowedValues);
        params.put(SORTED_PARAM, this.sorted);
        return params;
    }

    @Override
    protected void evaluateSingleValue(Object value) {
        String valueStr = null;
        try {
            valueStr = DefaultTypeConverter.INSTANCE.convert(String.class, value);
        }
        catch (TypeConversionException e) {
            throw new ConstraintException(ERR_NON_STRING, value);
        }
        if (this.caseSensitive ? !this.allowedValues.contains(valueStr) : !this.allowedValuesUpper.contains(valueStr.toUpperCase())) {
            throw new ConstraintException(ERR_INVALID_VALUE, value);
        }
    }
}

