/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.impl.lucene.index.CachingIndexReader;
import org.alfresco.repo.search.impl.lucene.query.CachingTermPositions;
import org.alfresco.repo.search.impl.lucene.query.ContainerScorer;
import org.alfresco.repo.search.impl.lucene.query.LeafScorerException;
import org.alfresco.repo.search.impl.lucene.query.StructuredFieldPosition;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafScorer
extends Scorer {
    private static Log s_logger = LogFactory.getLog(LeafScorer.class);
    private int counter;
    private int countInCounter;
    int min = -1;
    int max = -1;
    boolean more = true;
    Scorer containerScorer;
    StructuredFieldPosition[] sfps;
    float freq = 0.0f;
    HashMap<String, Counter> parentIds = new HashMap();
    HashMap<String, List<String>> categories = new HashMap();
    HashMap<String, Counter> selfIds = null;
    boolean hasSelfScorer;
    IndexReader reader;
    BitSet allNodesCandiates = new BitSet();
    TermPositions level0;
    HashSet<String> selfLinks = new HashSet();
    BitSet selfDocs = new BitSet();
    private TermPositions root;
    private int rootDoc;
    private boolean repeat;
    private DictionaryService dictionaryService;
    private int[] parents;
    private int[] self;
    private int[] cats;
    private boolean matchAllLeaves;
    private boolean followParentInLevel0;

    public LeafScorer(Weight weight, TermPositions root, TermPositions level0, ContainerScorer containerScorer, StructuredFieldPosition[] sfps, boolean followParentInLevel0, HashMap<String, Counter> selfIds, IndexReader reader, Similarity similarity, byte[] norms, DictionaryService dictionaryService, boolean repeat) {
        super(similarity);
        this.root = root;
        this.containerScorer = containerScorer;
        this.sfps = sfps;
        if (selfIds == null) {
            this.selfIds = new HashMap();
            this.hasSelfScorer = false;
        } else {
            this.selfIds = selfIds;
            this.hasSelfScorer = true;
        }
        this.reader = reader;
        this.level0 = level0;
        this.dictionaryService = dictionaryService;
        this.repeat = repeat;
        this.followParentInLevel0 = followParentInLevel0;
        this.matchAllLeaves = this.allNodes();
        try {
            this.initialise();
        }
        catch (IOException e) {
            throw new LeafScorerException("IO Error:", e);
        }
    }

    private String getPathLinkId(IndexReader reader, int n) throws IOException {
        if (reader instanceof CachingIndexReader) {
            CachingIndexReader cachingIndexReader = (CachingIndexReader)reader;
            return cachingIndexReader.getPathLinkId(n);
        }
        Document document = reader.document(n);
        Field[] fields = document.getFields("ID");
        if (fields != null) {
            Field id = fields[fields.length - 1];
            return id == null ? null : id.stringValue();
        }
        return null;
    }

    private String getIsCategory(IndexReader reader, int n) throws IOException {
        if (reader instanceof CachingIndexReader) {
            CachingIndexReader cachingIndexReader = (CachingIndexReader)reader;
            return cachingIndexReader.getIsCategory(n);
        }
        Document document = reader.document(n);
        Field isCategory = document.getField("ISCATEGORY");
        return isCategory == null ? null : isCategory.stringValue();
    }

    private String getPath(IndexReader reader, int n) throws IOException {
        if (reader instanceof CachingIndexReader) {
            CachingIndexReader cachingIndexReader = (CachingIndexReader)reader;
            return cachingIndexReader.getPath(n);
        }
        Document document = reader.document(n);
        Field path = document.getField("PATH");
        return path == null ? null : path.stringValue();
    }

    private String getType(IndexReader reader, int n) throws IOException {
        if (reader instanceof CachingIndexReader) {
            CachingIndexReader cachingIndexReader = (CachingIndexReader)reader;
            return cachingIndexReader.getType(n);
        }
        Document document = reader.document(n);
        Field path = document.getField("TYPE");
        return path == null ? null : path.stringValue();
    }

    private String[] getParents(IndexReader reader, int n) throws IOException {
        if (reader instanceof CachingIndexReader) {
            CachingIndexReader cachingIndexReader = (CachingIndexReader)reader;
            return cachingIndexReader.getParents(n);
        }
        Document document = reader.document(n);
        Field[] fields = document.getFields("PARENT");
        if (fields != null) {
            String[] answer = new String[fields.length];
            int i = 0;
            for (Field field : fields) {
                answer[i++] = field == null ? null : field.stringValue();
            }
            return answer;
        }
        return null;
    }

    private String[] getlinkAspects(IndexReader reader, int n) throws IOException {
        if (reader instanceof CachingIndexReader) {
            CachingIndexReader cachingIndexReader = (CachingIndexReader)reader;
            return cachingIndexReader.getLinkAspects(n);
        }
        Document document = reader.document(n);
        Field[] fields = document.getFields("LINKASPECT");
        if (fields != null) {
            String[] answer = new String[fields.length];
            int i = 0;
            for (Field field : fields) {
                answer[i++] = field == null ? null : field.stringValue();
            }
            return answer;
        }
        return null;
    }

    private void initialise() throws IOException {
        Counter counter;
        String id;
        int doc;
        if (this.containerScorer != null) {
            this.parentIds.clear();
            while (this.containerScorer.next()) {
                List<String> list;
                String isCategory;
                doc = this.containerScorer.doc();
                id = this.getPathLinkId(this.reader, doc);
                counter = this.parentIds.get(id);
                if (counter == null) {
                    counter = new Counter();
                    this.parentIds.put(id, counter);
                }
                ++counter.count;
                if (!this.hasSelfScorer) {
                    counter = this.selfIds.get(id);
                    if (counter == null) {
                        counter = new Counter();
                        this.selfIds.put(id, counter);
                    }
                    ++counter.count;
                }
                if ((isCategory = this.getIsCategory(this.reader, doc)) == null) continue;
                String pathString = this.getPath(this.reader, doc);
                if (pathString.length() > 0 && pathString.charAt(0) == '/') {
                    pathString = pathString.substring(1);
                }
                if ((list = this.categories.get(id)) == null) {
                    list = new ArrayList<String>();
                    this.categories.put(id, list);
                }
                list.add(pathString);
            }
        } else if (this.level0 != null) {
            this.parentIds.clear();
            while (this.level0.next()) {
                doc = this.level0.doc();
                id = this.getPathLinkId(this.reader, doc);
                if (id == null) continue;
                counter = this.parentIds.get(id);
                if (counter == null) {
                    counter = new Counter();
                    this.parentIds.put(id, counter);
                }
                ++counter.count;
                if (this.hasSelfScorer) continue;
                counter = this.selfIds.get(id);
                if (counter == null) {
                    counter = new Counter();
                    this.selfIds.put(id, counter);
                }
                ++counter.count;
            }
            if (this.parentIds.size() > 1) {
                throw new LeafScorerException("More than one root node in index: " + this.parentIds.size());
            }
            if (this.parentIds.size() == 0 && s_logger.isWarnEnabled()) {
                s_logger.warn((Object)"Index has no root node.  Check that the correct index locations are being used.");
            }
        }
        if (this.matchAllLeaves) {
            int position = 0;
            this.parents = new int[10000];
            ArrayList<String> ordered = new ArrayList<String>(this.parentIds.size());
            ordered.addAll(this.parentIds.keySet());
            Collections.sort(ordered);
            for (String parent : ordered) {
                Counter counter2 = this.parentIds.get(parent);
                TermPositions tp = this.reader.termPositions(new Term("PARENT", parent));
                while (tp.next()) {
                    if (this.level0 == null || this.followParentInLevel0) {
                        this.allNodesCandiates.set(tp.doc());
                    }
                    int l = tp.freq();
                    for (int i = 0; i < l; ++i) {
                        for (int j = 0; j < counter2.count; ++j) {
                            this.parents[position++] = tp.doc();
                            if (position != this.parents.length) continue;
                            int[] old = this.parents;
                            this.parents = new int[old.length * 2];
                            System.arraycopy(old, 0, this.parents, 0, old.length);
                        }
                    }
                }
                tp.close();
            }
            int[] old = this.parents;
            this.parents = new int[position];
            System.arraycopy(old, 0, this.parents, 0, position);
            Arrays.sort(this.parents);
            position = 0;
            this.self = new int[10000];
            ordered = new ArrayList(this.selfIds.size());
            ordered.addAll(this.selfIds.keySet());
            Collections.sort(ordered);
            this.reader.termDocs(new Term("ISNODE", "T"));
            TermDocs leafTp = null;
            for (String id2 : ordered) {
                TermPositions tp = this.reader.termPositions(new Term("ID", id2));
                while (tp.next()) {
                    int target = tp.doc();
                    if (leafTp == null) {
                        leafTp = this.reader.termDocs(new Term("ISNODE", "T"));
                    } else {
                        leafTp.seek(new Term("ISNODE", "T"));
                    }
                    leafTp.skipTo(target);
                    if (leafTp.doc() == target || this.level0 != null) {
                        this.allNodesCandiates.set(tp.doc());
                    }
                    Counter counter3 = this.selfIds.get(id2);
                    for (int i = 0; i < counter3.count; ++i) {
                        this.self[position++] = tp.doc();
                        if (position != this.self.length) continue;
                        old = this.self;
                        this.self = new int[old.length * 2];
                        System.arraycopy(old, 0, this.self, 0, old.length);
                    }
                }
                tp.close();
            }
            if (leafTp != null) {
                leafTp.close();
            }
            old = this.self;
            this.self = new int[position];
            System.arraycopy(old, 0, this.self, 0, position);
            Arrays.sort(this.self);
            position = 0;
            this.cats = new int[10000];
            ordered = new ArrayList(this.categories.size());
            ordered.addAll(this.categories.keySet());
            Collections.sort(ordered);
            for (String catid : ordered) {
                for (QName apsectQName : this.dictionaryService.getAllAspects()) {
                    AspectDefinition aspDef = this.dictionaryService.getAspect(apsectQName);
                    if (!this.isCategorised(aspDef)) continue;
                    for (PropertyDefinition propDef : aspDef.getProperties().values()) {
                        if (!propDef.getDataType().getName().equals(DataTypeDefinition.CATEGORY)) continue;
                        TermPositions tp = this.reader.termPositions(new Term("@" + propDef.getName().toString(), catid));
                        while (tp.next()) {
                            this.allNodesCandiates.set(tp.doc());
                            int l = tp.freq();
                            for (int i = 0; i < l; ++i) {
                                this.cats[position++] = tp.doc();
                                if (position != this.cats.length) continue;
                                old = this.cats;
                                this.cats = new int[old.length * 2];
                                System.arraycopy(old, 0, this.cats, 0, old.length);
                            }
                        }
                        tp.close();
                    }
                }
            }
            old = this.cats;
            this.cats = new int[position];
            System.arraycopy(old, 0, this.cats, 0, position);
            Arrays.sort(this.cats);
            TermPositions tp = this.reader.termPositions(new Term("ISROOT", "T"));
            while (tp.next()) {
                this.allNodesCandiates.set(tp.doc());
            }
            tp.close();
        }
    }

    public boolean next() throws IOException {
        if (this.repeat && this.countInCounter < this.counter) {
            ++this.countInCounter;
            return true;
        }
        this.countInCounter = 1;
        this.counter = 0;
        if (this.matchAllLeaves) {
            while (this.more) {
                this.max = this.allNodesCandiates.nextSetBit(this.max + 1);
                if (this.max != -1) {
                    if (!this.check()) continue;
                    return true;
                }
                this.doClose();
                this.more = false;
                return false;
            }
        }
        if (!this.more) {
            return false;
        }
        if (this.max == -1) {
            this.doNextOnAll();
            if (this.found()) {
                return true;
            }
        }
        return this.findNext();
    }

    private void doClose() throws IOException {
        if (this.sfps != null) {
            for (StructuredFieldPosition sfp : this.sfps) {
                CachingTermPositions ctp = sfp.getCachingTermPositions();
                if (ctp == null) continue;
                ctp.close();
            }
        }
        if (this.level0 != null) {
            this.level0.close();
        }
        if (this.root != null) {
            this.root.close();
        }
    }

    private boolean allNodes() {
        if (this.sfps.length == 0) {
            return true;
        }
        for (StructuredFieldPosition sfp : this.sfps) {
            if (sfp.getCachingTermPositions() == null) continue;
            return false;
        }
        return true;
    }

    private boolean findNext() throws IOException {
        while (this.more) {
            this.move();
            if (!this.found()) continue;
            return true;
        }
        this.doClose();
        return false;
    }

    private void skipToMax() throws IOException {
        int l = this.sfps.length;
        for (int i = 0; i < l; ++i) {
            if (i == 0) {
                this.min = this.max;
            }
            if (this.sfps[i].getCachingTermPositions() == null || this.sfps[i].getCachingTermPositions().doc() >= this.max) continue;
            if (this.sfps[i].getCachingTermPositions().skipTo(this.max)) {
                int current = this.sfps[i].getCachingTermPositions().doc();
                this.adjustMinMax(current, false);
                continue;
            }
            this.more = false;
            return;
        }
        if (this.root.doc() < this.max) {
            if (this.root.skipTo(this.max)) {
                this.rootDoc = this.root.doc();
            } else {
                this.more = false;
                return;
            }
        }
    }

    private void move() throws IOException {
        if (this.min == this.max) {
            this.doNextOnAll();
        } else {
            this.skipToMax();
        }
    }

    private void doNextOnAll() throws IOException {
        boolean first = true;
        int l = this.sfps.length;
        for (int i = 0; i < l; ++i) {
            if (this.sfps[i].getCachingTermPositions() == null) continue;
            if (this.sfps[i].getCachingTermPositions().next()) {
                int current = this.sfps[i].getCachingTermPositions().doc();
                this.adjustMinMax(current, first);
                first = false;
                continue;
            }
            this.more = false;
            return;
        }
        if (!this.root.next()) {
            this.more = false;
            return;
        }
        this.rootDoc = this.root.doc();
        if (this.root.doc() < this.max) {
            if (this.root.skipTo(this.max)) {
                this.rootDoc = this.root.doc();
            } else {
                this.more = false;
                return;
            }
        }
    }

    private void adjustMinMax(int doc, boolean setMin) {
        if (this.max < doc) {
            this.max = doc;
        }
        if (setMin) {
            this.min = doc;
        } else if (this.min > doc) {
            this.min = doc;
        }
    }

    private boolean found() throws IOException {
        if (this.sfps.length == 0) {
            return true;
        }
        if (!this.more) {
            return false;
        }
        if (this.min != this.max) {
            return false;
        }
        if (this.rootDoc != this.max) {
            return false;
        }
        return this.check();
    }

    private boolean check() throws IOException {
        if (this.matchAllLeaves) {
            int i;
            int l;
            int position;
            this.counter = 0;
            StructuredFieldPosition last = this.sfps[this.sfps.length - 1];
            if (last.linkSelf() && this.self != null && this.sfps[1].linkSelf() && (position = Arrays.binarySearch(this.self, this.max)) >= 0 && !this.selfDocs.get(this.max)) {
                this.selfDocs.set(this.max);
                while (position > -1 && this.self[position] == this.max) {
                    --position;
                }
                l = this.self.length;
                for (i = position + 1; i < l && this.self[i] == this.max; ++i) {
                    ++this.counter;
                }
            }
            if (!this.selfDocs.get(this.max) && last.linkParent()) {
                if (this.parents != null && (position = Arrays.binarySearch(this.parents, this.max)) >= 0) {
                    while (position > -1 && this.parents[position] == this.max) {
                        --position;
                    }
                    l = this.parents.length;
                    for (i = position + 1; i < l && this.parents[i] == this.max; ++i) {
                        ++this.counter;
                    }
                }
                if (this.cats != null && (position = Arrays.binarySearch(this.cats, this.max)) >= 0) {
                    while (position > -1 && this.cats[position] == this.max) {
                        --position;
                    }
                    l = this.cats.length;
                    for (i = position + 1; i < l && this.cats[i] == this.max; ++i) {
                        ++this.counter;
                    }
                }
            }
            return this.counter > 0;
        }
        int count = this.root.freq();
        int start = 0;
        int end = -1;
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                start = 0;
                end = this.root.nextPosition();
            } else {
                start = end + 1;
                end = this.root.nextPosition();
            }
            this.check(start, end, i);
        }
        return this.counter > 0;
    }

    private void check(int start, int end, int position) throws IOException {
        int offset = 0;
        int l = this.sfps.length;
        for (int i = 0; i < l; ++i) {
            if ((offset = this.sfps[i].matches(start, end, offset)) != -1) continue;
            return;
        }
        if (offset == -1) {
            return;
        }
        if (this.sfps[this.sfps.length - 1].isTerminal() && offset != 2) {
            return;
        }
        String[] parentFields = this.getParents(this.reader, this.doc());
        String[] linkFields = null;
        if (this.categories.size() > 0) {
            linkFields = this.getlinkAspects(this.reader, this.doc());
        }
        String parentID = null;
        String linkAspect = null;
        if (parentFields != null && parentFields.length > position && parentFields[position] != null) {
            parentID = parentFields[position];
        }
        if (linkFields != null && linkFields.length > position && linkFields[position] != null) {
            linkAspect = linkFields[position];
        }
        this.containersIncludeCurrent(parentID, linkAspect);
    }

    private void containersIncludeCurrent(String parentID, String aspectQName) throws IOException {
        if (this.containerScorer != null || this.level0 != null) {
            Counter counter;
            if (this.sfps.length == 0) {
                return;
            }
            String id = this.getPathLinkId(this.reader, this.doc());
            StructuredFieldPosition last = this.sfps[this.sfps.length - 1];
            if (last.linkSelf() && this.selfIds.containsKey(id) && (counter = this.selfIds.get(id)) != null && !this.selfLinks.contains(id)) {
                this.counter += counter.count;
                this.selfLinks.add(id);
                return;
            }
            if (parentID != null && parentID.length() > 0 && last.linkParent() && !this.selfLinks.contains(id)) {
                if (this.categories.containsKey(parentID)) {
                    QName classRef;
                    AspectDefinition aspDef;
                    Counter counter2;
                    QName typeRef;
                    String type = this.getType(this.reader, this.doc());
                    if (type != null && this.isCategory(typeRef = QName.createQName(type)) && (counter2 = this.parentIds.get(parentID)) != null) {
                        this.counter += counter2.count;
                        return;
                    }
                    if (aspectQName != null && this.isCategorised(aspDef = this.dictionaryService.getAspect(classRef = QName.createQName(aspectQName)))) {
                        for (PropertyDefinition propDef : aspDef.getProperties().values()) {
                            Document document;
                            Field[] categoryFields;
                            if (!propDef.getDataType().getName().equals(DataTypeDefinition.CATEGORY) || (categoryFields = (document = this.reader.document(this.doc())).getFields("@" + propDef.getName())) == null) continue;
                            for (Field categoryField : categoryFields) {
                                if (categoryField == null || categoryField.stringValue() == null || !categoryField.stringValue().endsWith(parentID)) continue;
                                int count = 0;
                                List<String> paths = this.categories.get(parentID);
                                if (paths != null) {
                                    for (String path : paths) {
                                        if (path.indexOf(aspectQName) == -1) continue;
                                        ++count;
                                    }
                                }
                                this.counter += count;
                                return;
                            }
                        }
                    }
                } else {
                    counter = this.parentIds.get(parentID);
                    if (counter != null) {
                        this.counter += counter.count;
                        return;
                    }
                }
            }
            return;
        }
    }

    private boolean isCategory(QName classRef) {
        if (classRef == null) {
            return false;
        }
        TypeDefinition current = this.dictionaryService.getType(classRef);
        while (current != null) {
            if (current.getName().equals(ContentModel.TYPE_CATEGORY)) {
                return true;
            }
            QName parentName = current.getParentName();
            if (parentName == null) break;
            current = this.dictionaryService.getType(parentName);
        }
        return false;
    }

    private boolean isCategorised(AspectDefinition aspDef) {
        if (aspDef == null) {
            return false;
        }
        AspectDefinition current = aspDef;
        while (current != null) {
            if (current.getName().equals(ContentModel.ASPECT_CLASSIFIABLE)) {
                return true;
            }
            QName parentName = current.getParentName();
            if (parentName == null) break;
            current = this.dictionaryService.getAspect(parentName);
        }
        return false;
    }

    public int doc() {
        return this.max;
    }

    public float score() throws IOException {
        return this.repeat ? 1.0f : (float)this.counter;
    }

    public boolean skipTo(int target) throws IOException {
        this.countInCounter = 1;
        this.counter = 0;
        if (this.matchAllLeaves) {
            this.max = this.allNodesCandiates.nextSetBit(target > this.max ? target : this.max + 1);
            if (this.max != -1) {
                this.root.skipTo(this.max);
                if (this.check()) {
                    return true;
                }
                while (this.more) {
                    this.max = this.allNodesCandiates.nextSetBit(this.max + 1);
                    if (this.max != -1) {
                        this.root.skipTo(this.max);
                        if (!this.check()) continue;
                        return true;
                    }
                    this.more = false;
                    return false;
                }
            } else {
                this.more = false;
                return false;
            }
        }
        this.max = target;
        return this.findNext();
    }

    public Explanation explain(int doc) throws IOException {
        Explanation tfExplanation = new Explanation();
        while (this.next() && this.doc() < doc) {
        }
        float phraseFreq = this.doc() == doc ? this.freq : 0.0f;
        tfExplanation.setValue(this.getSimilarity().tf(phraseFreq));
        tfExplanation.setDescription("tf(phraseFreq=" + phraseFreq + ")");
        return tfExplanation;
    }

    static class Counter {
        int count = 0;

        Counter() {
        }

        public String toString() {
            return "count = " + this.count;
        }
    }
}

