/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.AbstractVFSContext;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.plugins.vfs.helpers.PathTokenizer;
import org.jboss.virtual.spi.Options;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VFSContextFactory;
import org.jboss.virtual.spi.VFSContextFactoryLocator;
import org.jboss.virtual.spi.VirtualFileHandler;

public abstract class AbstractVirtualFileHandler
implements VirtualFileHandler {
    protected static final Logger log = Logger.getLogger(AbstractVirtualFileHandler.class);
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("rootURI", URI.class), new ObjectStreamField("parent", VirtualFileHandler.class), new ObjectStreamField("name", String.class), new ObjectStreamField("vfsUrl", URL.class)};
    private VFSContext context;
    private VirtualFileHandler parent;
    private String name;
    private URL vfsUrl;
    private transient String vfsPath;
    private transient String localVfsPath;
    private transient AtomicInteger references = new AtomicInteger(0);
    protected transient long cachedLastModified;
    private transient URL vfsUrlCached;

    protected AbstractVirtualFileHandler(VFSContext context, VirtualFileHandler parent, String name) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.context = context;
        this.parent = parent;
        this.name = VFSUtils.fixName(name);
        this.vfsPath = null;
    }

    protected void checkParentExists() {
        if (this.parent == null) {
            throw new IllegalArgumentException("Parent must exist!");
        }
    }

    protected URL getChildVfsUrl(String childPath, boolean isDirectory) throws IOException, URISyntaxException {
        this.checkParentExists();
        URL parentVfsUrl = this.getParent().toVfsUrl();
        String vfsUrlString = parentVfsUrl.toString();
        if (vfsUrlString.length() > 0 && !vfsUrlString.endsWith("/")) {
            vfsUrlString = vfsUrlString + "/";
        }
        vfsUrlString = vfsUrlString + childPath;
        if (isDirectory && !vfsUrlString.endsWith("/")) {
            vfsUrlString = vfsUrlString + "/";
        }
        return new URL(vfsUrlString);
    }

    protected String getChildPathName(String childPath, boolean isDirectory) throws IOException {
        this.checkParentExists();
        String childPathName = this.getParent().getPathName();
        if (childPathName.length() > 0 && !childPathName.endsWith("/")) {
            childPathName = childPathName + "/";
        }
        childPathName = childPathName + childPath;
        if (isDirectory && !childPathName.endsWith("/")) {
            childPathName = childPathName + "/";
        }
        return childPathName;
    }

    public boolean isArchive() throws IOException {
        return false;
    }

    public boolean hasBeenModified() throws IOException {
        boolean hasBeenModified = false;
        long last = this.getLastModified();
        if (this.cachedLastModified != last) {
            hasBeenModified = this.cachedLastModified != 0L;
            this.cachedLastModified = last;
        }
        return hasBeenModified;
    }

    public String getName() {
        return this.name;
    }

    public String getPathName() {
        if (this.vfsPath == null) {
            StringBuilder pathName = new StringBuilder();
            this.initPath(pathName);
            this.vfsPath = pathName.toString();
        }
        return this.vfsPath;
    }

    public void setPathName(String path) {
        this.vfsPath = path;
    }

    public String getLocalPathName() {
        if (this.localVfsPath == null) {
            this.localVfsPath = this.readLocalPathName();
        }
        return this.localVfsPath;
    }

    private String readLocalPathName() {
        try {
            VirtualFileHandler handler = this.getLocalVFSContext().getRoot();
            String rootPathName = handler.getPathName();
            String pathName = this.getPathName();
            int len = rootPathName.length();
            if (len == 0) {
                return pathName;
            }
            if (rootPathName.length() < pathName.length()) {
                return pathName.substring(len + 1);
            }
            return "";
        }
        catch (IOException ex) {
            log.warn((Object)("Failed to compose local path name: context: " + this.getLocalVFSContext() + ", name: " + this.getName()), (Throwable)ex);
            return this.getPathName();
        }
    }

    public URL toURL() throws MalformedURLException, URISyntaxException {
        return this.toURI().toURL();
    }

    public URL toVfsUrl() throws MalformedURLException, URISyntaxException {
        if (this.vfsUrlCached == null) {
            if (this.isTemporary()) {
                try {
                    VFSContext context = this.getVFSContext();
                    String path = this.getPathName();
                    Options options = context.getOptions();
                    VirtualFileHandler oldRoot = options.getOption(VirtualFileHandler.class);
                    if (oldRoot == null) {
                        StringBuffer buf = new StringBuffer();
                        URI rootURI = context.getRootURI();
                        URI copyURI = new URI(rootURI.getScheme(), rootURI.getHost(), rootURI.getPath(), null);
                        buf.append(copyURI.toURL().toExternalForm());
                        if (path != null && path.length() > 0) {
                            if (buf.charAt(buf.length() - 1) != '/') {
                                buf.append('/');
                            }
                            buf.append(path);
                        }
                        if (buf.charAt(buf.length() - 1) != '/' && !this.isLeaf()) {
                            buf.append('/');
                        }
                        this.vfsUrlCached = new URL(buf.toString());
                    }
                    VirtualFileHandler handler = oldRoot.getChild(path);
                    if (handler == null) {
                        URL oldRootURL = oldRoot.toVfsUrl();
                        if (path != null && path.length() > 0) {
                            String oldRootURLString = oldRootURL.toExternalForm();
                            if (!oldRootURLString.endsWith("/") && !path.startsWith("/")) {
                                oldRootURLString = oldRootURLString + "/";
                            }
                            this.vfsUrlCached = new URL(oldRootURLString + path);
                        } else {
                            this.vfsUrlCached = oldRootURL;
                        }
                        log.warn((Object)("No such existing handler, falling back to old root + path: " + this.vfsUrlCached));
                    }
                    this.vfsUrlCached = handler.toVfsUrl();
                }
                catch (IOException e) {
                    throw new MalformedURLException(e.getMessage());
                }
            } else {
                this.vfsUrlCached = this.toInternalVfsUrl();
            }
        }
        return this.vfsUrlCached;
    }

    protected URL toInternalVfsUrl() throws MalformedURLException, URISyntaxException {
        return this.vfsUrl;
    }

    public URL getRealURL() throws IOException, URISyntaxException {
        return this.toURL();
    }

    protected URL getVfsUrl() {
        return this.vfsUrl;
    }

    protected void setVfsUrl(URL vfsUrl) {
        this.vfsUrl = vfsUrl;
    }

    private boolean initPath(StringBuilder pathName) {
        if (this.context.getRootPeer() != null && this.initPeerPath(pathName)) {
            return true;
        }
        if (this.parent != null) {
            if (this.parent instanceof AbstractVirtualFileHandler) {
                AbstractVirtualFileHandler handler = (AbstractVirtualFileHandler)this.parent;
                if (handler.initPath(pathName)) {
                    pathName.append('/');
                }
            } else {
                pathName.append(this.parent.getPathName());
            }
            pathName.append(this.getName());
            return true;
        }
        return false;
    }

    private boolean initPeerPath(StringBuilder pathName) {
        VirtualFileHandler grandParent = null;
        if (this.parent != null) {
            try {
                grandParent = this.parent.getParent();
            }
            catch (IOException ex) {
                log.warn((Object)("AbstractVirtualFileHandler.initPath failed: ctx: " + this.context + ", parent: " + this.parent + " name: " + this.name), (Throwable)ex);
            }
        }
        if (grandParent == null) {
            VirtualFileHandler peer = this.context.getRootPeer();
            if (peer instanceof AbstractVirtualFileHandler) {
                AbstractVirtualFileHandler handler = (AbstractVirtualFileHandler)peer;
                if (handler.initPath(pathName) && this.parent != null) {
                    pathName.append('/');
                }
            } else {
                pathName.append(peer.getPathName());
            }
            if (this.parent != null) {
                pathName.append(this.getName());
            }
            return true;
        }
        return false;
    }

    public VirtualFile getVirtualFile() {
        this.checkClosed();
        this.increment();
        return new VirtualFile(this);
    }

    public VirtualFileHandler getParent() throws IOException {
        AbstractVFSContext avfc;
        VirtualFileHandler peer;
        this.checkClosed();
        if (this.parent == null && this.context instanceof AbstractVFSContext && (peer = (avfc = (AbstractVFSContext)this.context).getRootPeer()) != null) {
            return peer.getParent();
        }
        return this.parent;
    }

    public VFSContext getVFSContext() {
        AbstractVFSContext avfs;
        VirtualFileHandler peer;
        this.checkClosed();
        if (this.context instanceof AbstractVFSContext && (peer = (avfs = (AbstractVFSContext)this.context).getRootPeer()) != null) {
            return peer.getVFSContext();
        }
        return this.context;
    }

    public VFSContext getLocalVFSContext() {
        return this.context;
    }

    protected int increment() {
        return this.references.incrementAndGet();
    }

    protected int decrement() {
        return this.references.decrementAndGet();
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.references.get() < 0) {
            throw new IllegalStateException("Closed " + this.toStringLocal());
        }
    }

    protected int getReferences() {
        return this.references.get();
    }

    public void cleanup() {
    }

    protected boolean isTemporary() {
        Options options = this.getVFSContext().getOptions();
        return options.getBooleanOption("IS_TEMP_FILE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.getReferences() == 1) {
                this.doClose();
            }
        }
        finally {
            this.references.decrementAndGet();
        }
    }

    protected void doClose() {
    }

    public boolean delete(int gracePeriod) throws IOException {
        VirtualFileHandler parent = this.getParent();
        return parent != null && parent.removeChild(this.getName());
    }

    public VirtualFileHandler structuredFindChild(String path) throws IOException {
        this.checkClosed();
        List<String> tokens = PathTokenizer.getTokens(path);
        if (tokens == null || tokens.size() == 0) {
            return this;
        }
        VirtualFileHandler current = this;
        for (int i = 0; i < tokens.size(); ++i) {
            if (current == null) {
                return null;
            }
            String token = tokens.get(i);
            if (PathTokenizer.isCurrentToken(token)) continue;
            if (PathTokenizer.isReverseToken(token)) {
                VirtualFileHandler parent = current.getParent();
                if (parent == null) {
                    throw new IOException("Using reverse path on top file handler: " + current + ", " + path);
                }
                current = parent;
                continue;
            }
            if (current.isLeaf()) {
                return null;
            }
            if (current instanceof StructuredVirtualFileHandler) {
                StructuredVirtualFileHandler structured = (StructuredVirtualFileHandler)((Object)current);
                current = structured.createChildHandler(token);
                continue;
            }
            String remainingPath = PathTokenizer.getRemainingPath(tokens, i);
            return current.getChild(remainingPath);
        }
        return current;
    }

    public VirtualFileHandler simpleFindChild(String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        if (path.length() == 0) {
            return this;
        }
        String appliedPath = PathTokenizer.applySpecialPaths(path);
        List<VirtualFileHandler> children = this.getChildren(false);
        for (VirtualFileHandler child : children) {
            if (!child.getName().equals(appliedPath)) continue;
            return child;
        }
        return null;
    }

    public void replaceChild(VirtualFileHandler original, VirtualFileHandler replacement) {
        this.internalReplaceChild(original, replacement);
        if (replacement instanceof AbstractVirtualFileHandler) {
            AbstractVirtualFileHandler avfh = (AbstractVirtualFileHandler)replacement;
            avfh.parent = this;
        }
    }

    protected void internalReplaceChild(VirtualFileHandler original, VirtualFileHandler replacement) {
        throw new UnsupportedOperationException("Replacement is unsupported: " + this.toString());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append('@');
        buffer.append(System.identityHashCode(this));
        buffer.append("[path=").append(this.getPathName());
        buffer.append(" context=").append(this.getVFSContext().getRootURI());
        buffer.append(" real=").append(this.safeToURLString());
        buffer.append(']');
        return buffer.toString();
    }

    public String toStringLocal() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append('@');
        buffer.append(System.identityHashCode(this));
        buffer.append("[path=").append(this.getLocalPathName());
        buffer.append(" context=").append(this.context.getRootURI());
        buffer.append(']');
        return buffer.toString();
    }

    public int hashCode() {
        return this.getPathName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof VirtualFileHandler)) {
            return false;
        }
        VirtualFileHandler other = (VirtualFileHandler)obj;
        if (!this.getVFSContext().equals(other.getVFSContext())) {
            return false;
        }
        return this.getPathName().equals(other.getPathName());
    }

    private String safeToURLString() {
        try {
            return this.toURI().toString();
        }
        catch (URISyntaxException ignored) {
            return "<unknown>";
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("rootURI", this.getLocalVFSContext().getRootURI());
        fields.put("parent", this.parent);
        fields.put("name", this.name);
        fields.put("vfsUrl", this.vfsUrl);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        URI rootURI = (URI)fields.get("rootURI", null);
        this.parent = (VirtualFileHandler)fields.get("parent", null);
        this.name = (String)fields.get("name", null);
        VFSContextFactory factory = VFSContextFactoryLocator.getFactory(rootURI);
        this.context = factory.getVFS(rootURI);
        this.references = new AtomicInteger(0);
        this.vfsUrl = (URL)fields.get("vfsUrl", null);
    }
}

