/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.jboss.virtual.spi.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOptions
implements Options {
    private transient Map<String, Object> options;

    @Override
    public int size() {
        return this.options == null ? 0 : this.options.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(Options other) {
        if (other == null) {
            throw new IllegalArgumentException("Null other options");
        }
        if (other.size() == 0) {
            return;
        }
        Map<String, Object> map = other.getOptions(Object.class);
        DefaultOptions defaultOptions = this;
        synchronized (defaultOptions) {
            if (this.options == null) {
                this.options = new HashMap<String, Object>();
            }
            this.options.putAll(map);
        }
    }

    @Override
    public <T> Map<String, T> getOptions(Class<T> exactType) {
        if (exactType == null) {
            throw new IllegalArgumentException("Null exact type");
        }
        HashMap<String, T> result = new HashMap<String, T>();
        if (this.options != null && !this.options.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.options.entrySet()) {
                Object value = entry.getValue();
                if (!exactType.isInstance(value)) continue;
                result.put(entry.getKey(), exactType.cast(value));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOption(String name, Object option) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (option == null) {
            return;
        }
        DefaultOptions defaultOptions = this;
        synchronized (defaultOptions) {
            if (this.options == null) {
                this.options = new HashMap<String, Object>();
            }
            this.options.put(name, option);
        }
    }

    @Override
    public void addOptions(Map<String, ?> map) {
        if (map == null) {
            throw new IllegalArgumentException("Null map");
        }
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.addOption(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOption(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        DefaultOptions defaultOptions = this;
        synchronized (defaultOptions) {
            if (this.options == null) {
                return;
            }
            this.options.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getOption(String name) {
        Object result;
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        DefaultOptions defaultOptions = this;
        synchronized (defaultOptions) {
            if (this.options == null) {
                return null;
            }
            result = this.options.get(name);
        }
        if (result == null) {
            return null;
        }
        if (result instanceof Future) {
            try {
                return ((Future)result).get();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Error getting option from future " + result, e);
            }
        }
        return result;
    }

    @Override
    public <T> T getOption(Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        return this.getOption(expectedType.getName(), expectedType);
    }

    @Override
    public <T> T getOption(String name, Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        Object result = this.getOption(name);
        if (result == null) {
            return null;
        }
        return expectedType.cast(result);
    }

    @Override
    public boolean getBooleanOption(String name) {
        Object option = this.getOption(name);
        if (option != null) {
            if (option instanceof Boolean) {
                return (Boolean)option;
            }
            return Boolean.parseBoolean(option.toString());
        }
        return false;
    }
}

