/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config.source;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigDeployment;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.ConfigSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConfigSource
implements ConfigSource {
    private static final Log logger = LogFactory.getLog(BaseConfigSource.class);
    private List<String> sourceStrings = new ArrayList<String>();

    protected BaseConfigSource() {
    }

    protected BaseConfigSource(List<String> sourceStrings) {
        for (String sourceString : sourceStrings) {
            this.addSourceString(sourceString);
        }
    }

    protected void addSourceString(String sourceString) {
        if (sourceString == null || sourceString.trim().length() == 0) {
            throw new ConfigException("Invalid source value: " + sourceString);
        }
        this.sourceStrings.add(sourceString);
    }

    @Override
    public final List<ConfigDeployment> getConfigDeployments() {
        int size = this.sourceStrings.size();
        if (size == 0) {
            throw new ConfigException("No sources provided: " + this.sourceStrings);
        }
        ArrayList<ConfigDeployment> configDeployments = new ArrayList<ConfigDeployment>(size);
        for (String sourceString : this.sourceStrings) {
            InputStream is;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieving input stream for source: " + sourceString));
            }
            if ((is = this.getInputStream(sourceString)) == null) continue;
            configDeployments.add(new ConfigDeployment(sourceString, is));
        }
        return configDeployments;
    }

    protected abstract InputStream getInputStream(String var1);
}

