/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.impl.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.alfresco.deployment.impl.DeploymentException;
import org.alfresco.deployment.impl.server.ReaderManagement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReaderManagementPool
implements ReaderManagement {
    private static Log logger = LogFactory.getLog(ReaderManagementPool.class);
    private ExecutorService pool = Executors.newCachedThreadPool();
    private boolean finished = false;
    Map<String, ReaderJob> fJobs = new HashMap<String, ReaderJob>();

    @Override
    public synchronized void addCopyThread(InputStream is, OutputStream os, String token) {
        ReaderJob worker = new ReaderJob(is, os);
        this.pool.execute(worker);
        this.fJobs.put(token, worker);
    }

    @Override
    public synchronized void closeCopyThread(String token) throws IOException {
        ReaderJob worker = this.fJobs.get(token);
        if (worker == null) {
            throw new DeploymentException("Closed unknown file.");
        }
        this.fJobs.remove(token);
        try {
            worker.join();
            if (worker.getException() != null) {
                throw worker.getException();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class ReaderJob
    implements Runnable {
        InputStream input;
        OutputStream output;
        IOException exception = null;

        public ReaderJob(InputStream input, OutputStream output) {
            this.input = input;
            this.output = output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] b = new byte[1000];
            int len = 0;
            try {
                while (len >= 0) {
                    len = this.input.read(b, 0, b.length);
                    if (len <= 0 || this.exception != null) continue;
                    try {
                        this.output.write(b, 0, len);
                    }
                    catch (IOException e) {
                        this.exception = e;
                    }
                }
            }
            catch (IOException e) {
                this.exception = e;
            }
            finally {
                try {
                    this.output.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Unable to close content stream", (Throwable)e);
                }
                ReaderJob readerJob = this;
                synchronized (readerJob) {
                    ReaderManagementPool.this.finished = true;
                    logger.debug((Object)"notifying");
                    this.notifyAll();
                }
            }
        }

        public IOException getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void join() throws InterruptedException {
            ReaderJob readerJob = this;
            synchronized (readerJob) {
                if (ReaderManagementPool.this.finished) {
                    return;
                }
                logger.debug((Object)"waiting for the reader to finish");
                this.wait();
            }
        }
    }
}

