/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.util.Arrays;
import junit.framework.TestCase;
import org.alfresco.encryption.DecryptingInputStream;
import org.alfresco.encryption.EncryptingOutputStream;

public class EncryptingOutputStreamTest
extends TestCase {
    public void testEncrypt() throws Exception {
        int bytesRead;
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        byte[] seed = ((Object)((Object)this)).getClass().getName().getBytes("UTF-8");
        random.setSeed(seed);
        keyGen.initialize(1024, random);
        KeyPair pair = keyGen.generateKeyPair();
        ByteArrayOutputStream buff = new ByteArrayOutputStream(2048);
        EncryptingOutputStream encrypting = new EncryptingOutputStream(buff, pair.getPublic(), random);
        ByteArrayOutputStream plainText1 = new ByteArrayOutputStream(2048);
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(((Object)((Object)this)).getClass().getSimpleName() + ".class");
        byte[] inbuff = new byte[17];
        while ((bytesRead = in.read(inbuff)) != -1) {
            ((OutputStream)encrypting).write(inbuff, 0, bytesRead);
            plainText1.write(inbuff, 0, bytesRead);
        }
        in.close();
        ((OutputStream)encrypting).close();
        plainText1.close();
        DecryptingInputStream decrypting = new DecryptingInputStream(new ByteArrayInputStream(buff.toByteArray()), pair.getPrivate());
        ByteArrayOutputStream plainText2 = new ByteArrayOutputStream(2048);
        while ((bytesRead = ((InputStream)decrypting).read(inbuff)) != -1) {
            plainText2.write(inbuff, 0, bytesRead);
        }
        EncryptingOutputStreamTest.assertTrue((boolean)Arrays.equals(plainText1.toByteArray(), plainText2.toByteArray()));
    }
}

