/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class ReadWriteLockExecuter<T> {
    private ReentrantReadWriteLock.ReadLock readLock;
    private ReentrantReadWriteLock.WriteLock writeLock;

    public ReadWriteLockExecuter() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    protected abstract T getWithReadLock() throws Throwable;

    protected abstract T getWithWriteLock() throws Throwable;

    public T execute() {
        T ret = null;
        this.readLock.lock();
        try {
            ret = this.getWithReadLock();
            if (ret != null) {
                T t = ret;
                return t;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception during 'getWithReadLock'", e);
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            T e = this.getWithWriteLock();
            return e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception during 'getWithWriteLock'", e);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

