/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.collections;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Function;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CollectionUtilsTest {
    private static Set<String> stooges;
    private static Map<String, Integer> primes;
    private static Map<String, Integer> squares;
    private static Map<String, Integer> nullMap;

    @Before
    public void initData() {
        stooges = new HashSet<String>();
        stooges.add("Larry");
        stooges.add("Curly");
        stooges.add("Moe");
        primes = new HashMap<String, Integer>();
        primes.put("two", 2);
        primes.put("three", 3);
        primes.put("five", 5);
        squares = new HashMap<String, Integer>();
        squares.put("one", 1);
        squares.put("two", 4);
        squares.put("three", 9);
    }

    @Test
    public void varArgsAsSet() {
        Assert.assertEquals(stooges, CollectionUtils.asSet(String.class, "Larry", "Curly", "Moe"));
    }

    @Test
    public void nullSafeMergeMaps() {
        Assert.assertNull(CollectionUtils.nullSafeMerge(nullMap, nullMap, true));
        Assert.assertEquals(Collections.emptyMap(), CollectionUtils.nullSafeMerge(nullMap, nullMap));
        Assert.assertEquals(primes, CollectionUtils.nullSafeMerge(nullMap, primes));
        Assert.assertEquals(primes, CollectionUtils.nullSafeMerge(primes, nullMap));
        HashMap<String, Integer> primesAndSquares = new HashMap<String, Integer>();
        primesAndSquares.putAll(primes);
        primesAndSquares.putAll(squares);
        Assert.assertEquals(primesAndSquares, CollectionUtils.nullSafeMerge(primes, squares));
    }

    @Test
    public void collectionFiltering() throws Exception {
        HashMap<String, Integer> nerdsBirthdays = new HashMap<String, Integer>();
        nerdsBirthdays.put("Alan Turing", 1912);
        nerdsBirthdays.put("Charles Babbage", 1791);
        nerdsBirthdays.put("Matthew Smith", 1966);
        nerdsBirthdays.put("Paul Dirac", 1902);
        nerdsBirthdays.put("Robert Boyle", 1627);
        nerdsBirthdays.put("Robert Hooke", 1635);
        nerdsBirthdays.put("J. Robert Oppenheimer", 1904);
        KeySubstringFilter johnFilter = new KeySubstringFilter("John");
        Assert.assertEquals((long)0L, (long)CollectionUtils.filterKeys(nerdsBirthdays, johnFilter).size());
        KeySubstringFilter robertFilter = new KeySubstringFilter("Robert");
        Assert.assertEquals((long)3L, (long)CollectionUtils.filterKeys(nerdsBirthdays, robertFilter).size());
    }

    private static final class KeySubstringFilter
    implements Function<String, Boolean> {
        private final String substring;

        public KeySubstringFilter(String substring) {
            this.substring = substring;
        }

        @Override
        public Boolean apply(String value) {
            return value.contains(this.substring);
        }
    }
}

