/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;

public class CMISUtils {
    public static <T> T copy(T source) {
        Object target = null;
        try {
            CopyOutputStream cos = new CopyOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(cos);
            out.writeObject(source);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(cos.getInputStream());
            target = in.readObject();
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Object copy failed!", (Throwable)e);
        }
        return (T)target;
    }

    private static class CopyInputStream
    extends InputStream {
        protected byte[] buf = null;
        protected int count = 0;
        protected int pos = 0;

        public CopyInputStream(byte[] buf, int count) {
            this.buf = buf;
            this.count = count;
        }

        @Override
        public final int available() {
            return this.count - this.pos;
        }

        @Override
        public final int read() {
            return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
        }

        @Override
        public final int read(byte[] b, int off, int len) {
            if (this.pos >= this.count) {
                return -1;
            }
            if (this.pos + len > this.count) {
                len = this.count - this.pos;
            }
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        @Override
        public final long skip(long n) {
            if ((long)this.pos + n > (long)this.count) {
                n = this.count - this.pos;
            }
            if (n < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + n);
            return n;
        }
    }

    private static class CopyOutputStream
    extends OutputStream {
        protected byte[] buf = null;
        protected int size = 0;

        public CopyOutputStream() {
            this(16384);
        }

        public CopyOutputStream(int initSize) {
            this.buf = new byte[initSize];
        }

        private void verifyBufferSize(int sz) {
            if (sz > this.buf.length) {
                byte[] old = this.buf;
                this.buf = new byte[Math.max(sz, 2 * this.buf.length)];
                System.arraycopy(old, 0, this.buf, 0, old.length);
                Object var2_2 = null;
            }
        }

        @Override
        public final void write(byte[] b) {
            this.verifyBufferSize(this.size + b.length);
            System.arraycopy(b, 0, this.buf, this.size, b.length);
            this.size += b.length;
        }

        @Override
        public final void write(byte[] b, int off, int len) {
            this.verifyBufferSize(this.size + len);
            System.arraycopy(b, off, this.buf, this.size, len);
            this.size += len;
        }

        @Override
        public final void write(int b) {
            this.verifyBufferSize(this.size + 1);
            this.buf[this.size++] = (byte)b;
        }

        public InputStream getInputStream() {
            return new CopyInputStream(this.buf, this.size);
        }
    }
}

