/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import java.util.Collection;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.mapping.AbstractLuceneBuilder;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class ObjectIdLuceneBuilder
extends AbstractLuceneBuilder {
    private DictionaryService dictionaryService;

    public ObjectIdLuceneBuilder(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public String getLuceneFieldName() {
        return "ID";
    }

    private String getValueAsString(Serializable value) {
        Object converted = DefaultTypeConverter.INSTANCE.convert(this.dictionaryService.getDataType(DataTypeDefinition.NODE_REF), (Object)value);
        String asString = DefaultTypeConverter.INSTANCE.convert(String.class, converted);
        return asString;
    }

    @Override
    public Query buildLuceneEquality(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        String[] split = stringValue.split(";");
        if (split.length == 1) {
            return lqp.getFieldQuery(field, stringValue, AnalysisMode.IDENTIFIER, luceneFunction);
        }
        if (split[1].equalsIgnoreCase("PWC")) {
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        BooleanQuery query = new BooleanQuery();
        BooleanQuery part1 = new BooleanQuery();
        part1.add(lqp.getFieldQuery(field, split[0], AnalysisMode.IDENTIFIER, luceneFunction), BooleanClause.Occur.MUST);
        part1.add(lqp.getFieldQuery("@" + ContentModel.PROP_VERSION_LABEL.toString(), split[1], AnalysisMode.IDENTIFIER, luceneFunction), BooleanClause.Occur.MUST);
        query.add((Query)part1, BooleanClause.Occur.SHOULD);
        if (split[1].equals("1.0")) {
            BooleanQuery part2 = new BooleanQuery();
            part2.add(lqp.getFieldQuery(field, split[0], AnalysisMode.IDENTIFIER, luceneFunction), BooleanClause.Occur.MUST);
            part2.add(lqp.getFieldQuery("ASPECT", ContentModel.ASPECT_VERSIONABLE.toString(), AnalysisMode.IDENTIFIER, luceneFunction), BooleanClause.Occur.MUST_NOT);
            query.add((Query)part2, BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    @Override
    public Query buildLuceneExists(AbstractLuceneQueryParser lqp, Boolean not) throws ParseException {
        if (not.booleanValue()) {
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        return new MatchAllDocsQuery();
    }

    @Override
    public Query buildLuceneGreaterThan(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        throw new CmisInvalidArgumentException("Property cmis:objectId can not be used in a 'greater than' comparison");
    }

    @Override
    public Query buildLuceneGreaterThanOrEquals(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        throw new CmisInvalidArgumentException("Property cmis:objectId can not be used in a 'greater than or equals' comparison");
    }

    @Override
    public Query buildLuceneIn(AbstractLuceneQueryParser lqp, Collection<Serializable> values, Boolean not, PredicateMode mode) throws ParseException {
        Collection<?> converted = DefaultTypeConverter.INSTANCE.convert(this.dictionaryService.getDataType(DataTypeDefinition.NODE_REF), values);
        Collection<String> asStrings = DefaultTypeConverter.INSTANCE.convert(String.class, values);
        if (asStrings.size() == 0) {
            if (not.booleanValue()) {
                return new MatchAllDocsQuery();
            }
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        if (asStrings.size() == 1) {
            String value = asStrings.iterator().next();
            if (not.booleanValue()) {
                BooleanQuery booleanQuery = new BooleanQuery();
                booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
                booleanQuery.add(this.buildLuceneEquality(lqp, (Serializable)((Object)value), mode, LuceneFunction.FIELD), BooleanClause.Occur.MUST_NOT);
                return booleanQuery;
            }
            return this.buildLuceneEquality(lqp, (Serializable)((Object)value), mode, LuceneFunction.FIELD);
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        if (not.booleanValue()) {
            booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        }
        for (String value : asStrings) {
            Query any = this.buildLuceneEquality(lqp, (Serializable)((Object)value), mode, LuceneFunction.FIELD);
            if (not.booleanValue()) {
                booleanQuery.add(any, BooleanClause.Occur.MUST_NOT);
                continue;
            }
            booleanQuery.add(any, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    @Override
    public Query buildLuceneInequality(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        BooleanQuery booleanQuery = new BooleanQuery();
        booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        booleanQuery.add(this.buildLuceneEquality(lqp, value, mode, LuceneFunction.FIELD), BooleanClause.Occur.MUST_NOT);
        return booleanQuery;
    }

    @Override
    public Query buildLuceneLessThan(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        throw new CmisInvalidArgumentException("Property cmis:objectId can not be used in a 'less than' comparison");
    }

    @Override
    public Query buildLuceneLessThanOrEquals(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        throw new CmisInvalidArgumentException("Property cmis:objectId can not be used in a 'less than or equals' comparison");
    }

    @Override
    public Query buildLuceneLike(AbstractLuceneQueryParser lqp, Serializable value, Boolean not) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        if (not.booleanValue()) {
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
            booleanQuery.add(lqp.getLikeQuery(field, stringValue, AnalysisMode.IDENTIFIER), BooleanClause.Occur.MUST_NOT);
            return booleanQuery;
        }
        return lqp.getLikeQuery(field, stringValue, AnalysisMode.IDENTIFIER);
    }

    @Override
    public String getLuceneSortField(AbstractLuceneQueryParser lqp) {
        return this.getLuceneFieldName();
    }
}

