/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.FileContentReader;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigLookupContext;
import org.springframework.extensions.config.ConfigService;

public class MimetypeMap
implements MimetypeService {
    public static final String PREFIX_TEXT = "text/";
    public static final String EXTENSION_BINARY = "bin";
    public static final String MIMETYPE_TEXT_PLAIN = "text/plain";
    public static final String MIMETYPE_TEXT_MEDIAWIKI = "text/mediawiki";
    public static final String MIMETYPE_TEXT_CSS = "text/css";
    public static final String MIMETYPE_TEXT_CSV = "text/csv";
    public static final String MIMETYPE_TEXT_JAVASCRIPT = "text/javascript";
    public static final String MIMETYPE_XML = "text/xml";
    public static final String MIMETYPE_HTML = "text/html";
    public static final String MIMETYPE_XHTML = "application/xhtml+xml";
    public static final String MIMETYPE_PDF = "application/pdf";
    public static final String MIMETYPE_JSON = "application/json";
    public static final String MIMETYPE_WORD = "application/msword";
    public static final String MIMETYPE_EXCEL = "application/vnd.ms-excel";
    public static final String MIMETYPE_BINARY = "application/octet-stream";
    public static final String MIMETYPE_PPT = "application/vnd.ms-powerpoint";
    public static final String MIMETYPE_APP_DWG = "application/dwg";
    public static final String MIMETYPE_IMG_DWG = "image/vnd.dwg";
    public static final String MIMETYPE_VIDEO_AVI = "video/x-msvideo";
    public static final String MIMETYPE_VIDEO_QUICKTIME = "video/quicktime";
    public static final String MIMETYPE_VIDEO_WMV = "video/x-ms-wmv";
    public static final String MIMETYPE_VIDEO_3GP = "video/3gpp";
    public static final String MIMETYPE_VIDEO_3GP2 = "video/3gpp2";
    public static final String MIMETYPE_FLASH = "application/x-shockwave-flash";
    public static final String MIMETYPE_VIDEO_FLV = "video/x-flv";
    public static final String MIMETYPE_APPLICATION_FLA = "application/x-fla";
    public static final String MIMETYPE_VIDEO_MPG = "video/mpeg";
    public static final String MIMETYPE_VIDEO_MP4 = "video/mp4";
    public static final String MIMETYPE_IMAGE_GIF = "image/gif";
    public static final String MIMETYPE_IMAGE_JPEG = "image/jpeg";
    public static final String MIMETYPE_IMAGE_RGB = "image/x-rgb";
    public static final String MIMETYPE_IMAGE_SVG = "image/svg+xml";
    public static final String MIMETYPE_IMAGE_PNG = "image/png";
    public static final String MIMETYPE_IMAGE_TIFF = "image/tiff";
    public static final String MIMETYPE_APPLICATION_EPS = "application/eps";
    public static final String MIMETYPE_JAVASCRIPT = "application/x-javascript";
    public static final String MIMETYPE_ZIP = "application/zip";
    public static final String MIMETYPE_OPENSEARCH_DESCRIPTION = "application/opensearchdescription+xml";
    public static final String MIMETYPE_ATOM = "application/atom+xml";
    public static final String MIMETYPE_RSS = "application/rss+xml";
    public static final String MIMETYPE_RFC822 = "message/rfc822";
    public static final String MIMETYPE_OUTLOOK_MSG = "application/vnd.ms-outlook";
    public static final String MIMETYPE_VISIO = "application/vnd.visio";
    public static final String MIMETYPE_APPLICATION_ILLUSTRATOR = "application/illustrator";
    public static final String MIMETYPE_APPLICATION_PHOTOSHOP = "application/photoshop";
    public static final String MIMETYPE_OPENDOCUMENT_TEXT = "application/vnd.oasis.opendocument.text";
    public static final String MIMETYPE_OPENDOCUMENT_TEXT_TEMPLATE = "application/vnd.oasis.opendocument.text-template";
    public static final String MIMETYPE_OPENDOCUMENT_GRAPHICS = "application/vnd.oasis.opendocument.graphics";
    public static final String MIMETYPE_OPENDOCUMENT_GRAPHICS_TEMPLATE = "application/vnd.oasis.opendocument.graphics-template";
    public static final String MIMETYPE_OPENDOCUMENT_PRESENTATION = "application/vnd.oasis.opendocument.presentation";
    public static final String MIMETYPE_OPENDOCUMENT_PRESENTATION_TEMPLATE = "application/vnd.oasis.opendocument.presentation-template";
    public static final String MIMETYPE_OPENDOCUMENT_SPREADSHEET = "application/vnd.oasis.opendocument.spreadsheet";
    public static final String MIMETYPE_OPENDOCUMENT_SPREADSHEET_TEMPLATE = "application/vnd.oasis.opendocument.spreadsheet-template";
    public static final String MIMETYPE_OPENDOCUMENT_CHART = "application/vnd.oasis.opendocument.chart";
    public static final String MIMETYPE_OPENDOCUMENT_CHART_TEMPLATE = "applicationvnd.oasis.opendocument.chart-template";
    public static final String MIMETYPE_OPENDOCUMENT_IMAGE = "application/vnd.oasis.opendocument.image";
    public static final String MIMETYPE_OPENDOCUMENT_IMAGE_TEMPLATE = "applicationvnd.oasis.opendocument.image-template";
    public static final String MIMETYPE_OPENDOCUMENT_FORMULA = "application/vnd.oasis.opendocument.formula";
    public static final String MIMETYPE_OPENDOCUMENT_FORMULA_TEMPLATE = "applicationvnd.oasis.opendocument.formula-template";
    public static final String MIMETYPE_OPENDOCUMENT_TEXT_MASTER = "application/vnd.oasis.opendocument.text-master";
    public static final String MIMETYPE_OPENDOCUMENT_TEXT_WEB = "application/vnd.oasis.opendocument.text-web";
    public static final String MIMETYPE_OPENDOCUMENT_DATABASE = "application/vnd.oasis.opendocument.database";
    public static final String MIMETYPE_OPENOFFICE1_WRITER = "application/vnd.sun.xml.writer";
    public static final String MIMETYPE_OPENOFFICE1_CALC = "application/vnd.sun.xml.calc";
    public static final String MIMETYPE_OPENOFFICE1_DRAW = "application/vnd.sun.xml.draw";
    public static final String MIMETYPE_OPENOFFICE1_IMPRESS = "application/vnd.sun.xml.impress";
    public static final String MIMETYPE_OPENXML_WORDPROCESSING = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final String MIMETYPE_OPENXML_SPREADSHEET = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String MIMETYPE_OPENXML_PRESENTATION = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    public static final String MIMETYPE_STAROFFICE5_DRAW = "application/vnd.stardivision.draw";
    public static final String MIMETYPE_STAROFFICE5_CALC = "application/vnd.stardivision.calc";
    public static final String MIMETYPE_STAROFFICE5_IMPRESS = "application/vnd.stardivision.impress";
    public static final String MIMETYPE_STAROFFICE5_IMPRESS_PACKED = "application/vnd.stardivision.impress-packed";
    public static final String MIMETYPE_STAROFFICE5_CHART = "application/vnd.stardivision.chart";
    public static final String MIMETYPE_STAROFFICE5_WRITER = "application/vnd.stardivision.writer";
    public static final String MIMETYPE_STAROFFICE5_WRITER_GLOBAL = "application/vnd.stardivision.writer-global";
    public static final String MIMETYPE_STAROFFICE5_MATH = "application/vnd.stardivision.math";
    public static final String MIMETYPE_IWORK_KEYNOTE = "application/vnd.apple.keynote";
    public static final String MIMETYPE_IWORK_NUMBERS = "application/vnd.apple.numbers";
    public static final String MIMETYPE_IWORK_PAGES = "application/vnd.apple.pages";
    public static final String MIMETYPE_WORDPERFECT = "application/wordperfect";
    public static final String MIMETYPE_MP3 = "audio/mpeg";
    public static final String MIMETYPE_AUDIO_MP4 = "audio/mp4";
    public static final String MIMETYPE_VORBIS = "audio/vorbis";
    public static final String MIMETYPE_FLAC = "audio/x-flac";
    public static final String MIMETYPE_ACP = "application/acp";
    private static final String CONFIG_AREA = "mimetype-map";
    private static final String CONFIG_CONDITION = "Mimetype Map";
    private static final String ELEMENT_MIMETYPES = "mimetypes";
    private static final String ATTR_MIMETYPE = "mimetype";
    private static final String ATTR_DISPLAY = "display";
    private static final String ATTR_DEFAULT = "default";
    private static final String ATTR_TEXT = "text";
    private static final Log logger = LogFactory.getLog(MimetypeMap.class);
    private ConfigService configService;
    private ContentCharsetFinder contentCharsetFinder;
    private TikaConfig tikaConfig;
    private Detector detector;
    private List<String> mimetypes;
    private Map<String, String> extensionsByMimetype;
    private Map<String, String> mimetypesByExtension;
    private Map<String, String> displaysByMimetype;
    private Map<String, String> displaysByExtension;
    private Set<String> textMimetypes;

    public MimetypeMap() {
    }

    @Deprecated
    public MimetypeMap(ConfigService configService) {
        logger.warn((Object)"MimetypeMap(ConfigService configService) has been deprecated.  Use the default constructor and property 'configService'");
        this.configService = configService;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    @Override
    public ContentCharsetFinder getContentCharsetFinder() {
        return this.contentCharsetFinder;
    }

    public void setContentCharsetFinder(ContentCharsetFinder contentCharsetFinder) {
        this.contentCharsetFinder = contentCharsetFinder;
    }

    public void setTikaConfig(TikaConfig tikaConfig) {
        this.tikaConfig = tikaConfig;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"configService", (Object)this.configService);
        PropertyCheck.mandatory((Object)this, (String)"contentCharsetFinder", (Object)this.contentCharsetFinder);
        if (this.tikaConfig == null) {
            logger.warn((Object)"TikaConfig spring parameter not supplied, using default config");
            this.setTikaConfig(TikaConfig.getDefaultConfig());
        }
        this.detector = new DefaultDetector(this.tikaConfig.getMimeRepository());
        this.mimetypes = new ArrayList<String>(40);
        this.extensionsByMimetype = new HashMap<String, String>(59);
        this.mimetypesByExtension = new HashMap<String, String>(59);
        this.displaysByMimetype = new HashMap<String, String>(59);
        this.displaysByExtension = new HashMap<String, String>(59);
        this.textMimetypes = new HashSet<String>(23);
        Config config = this.configService.getConfig((Object)CONFIG_CONDITION, new ConfigLookupContext(CONFIG_AREA));
        ConfigElement mimetypesElement = config.getConfigElement(ELEMENT_MIMETYPES);
        List mimetypes = mimetypesElement.getChildren();
        int count = 0;
        for (ConfigElement mimetypeElement : mimetypes) {
            boolean prevIsText;
            String isTextStr;
            boolean isText;
            String mimetypeDisplay;
            ++count;
            String mimetype = mimetypeElement.getAttribute(ATTR_MIMETYPE);
            if (mimetype == null || mimetype.length() == 0) {
                logger.warn((Object)("Ignoring empty mimetype " + count));
                continue;
            }
            boolean replacement = this.mimetypes.contains(mimetype = mimetype.toLowerCase());
            if (!replacement) {
                this.mimetypes.add(mimetype);
            }
            if ((mimetypeDisplay = mimetypeElement.getAttribute(ATTR_DISPLAY)) != null && mimetypeDisplay.length() > 0) {
                String prev = this.displaysByMimetype.put(mimetype, mimetypeDisplay);
                if (replacement && prev != null && !mimetypeDisplay.equals(prev)) {
                    logger.warn((Object)("Replacing " + mimetype + " " + ATTR_DISPLAY + " value '" + prev + "' with '" + mimetypeDisplay + "'"));
                }
            }
            boolean bl = isText = Boolean.parseBoolean(isTextStr = mimetypeElement.getAttribute(ATTR_TEXT)) || mimetype.startsWith(PREFIX_TEXT);
            boolean bl2 = replacement ? this.textMimetypes.contains(mimetype) : (prevIsText = !isText);
            if (isText != prevIsText) {
                if (isText) {
                    this.textMimetypes.add(mimetype);
                } else if (replacement) {
                    this.textMimetypes.remove(mimetype);
                }
                if (replacement) {
                    logger.warn((Object)("Replacing " + mimetype + " " + ATTR_TEXT + " value " + (prevIsText ? "'true' with 'false'" : "'false' with 'true'")));
                }
            }
            List extensions = mimetypeElement.getChildren();
            for (ConfigElement extensionElement : extensions) {
                String extension = extensionElement.getValue();
                if (extension == null || extension.length() == 0) {
                    logger.warn((Object)("Ignoring empty extension for mimetype: " + mimetype));
                    continue;
                }
                extension = extension.toLowerCase();
                this.mimetypesByExtension.put(extension, mimetype);
                String extensionDisplay = extensionElement.getAttribute(ATTR_DISPLAY);
                String prev = this.displaysByExtension.get(extension);
                if (prev == null && (extensionDisplay == null || extensionDisplay.length() == 0) && mimetypeDisplay != null && mimetypeDisplay.length() > 0) {
                    extensionDisplay = mimetypeDisplay;
                }
                if (extensionDisplay != null) {
                    this.displaysByExtension.put(extension, extensionDisplay);
                    if (prev != null && !extensionDisplay.equals(prev)) {
                        logger.warn((Object)("Replacing " + mimetype + " extension " + ATTR_DISPLAY + " value '" + prev + "' with '" + extensionDisplay + "'"));
                    }
                }
                String prevExtension = this.extensionsByMimetype.get(mimetype);
                String isDefaultStr = extensionElement.getAttribute(ATTR_DEFAULT);
                boolean isDefault = Boolean.parseBoolean(isDefaultStr) || prevExtension == null;
                if (!isDefault) continue;
                this.extensionsByMimetype.put(mimetype, extension);
                if (prevExtension == null || extension.equals(prevExtension)) continue;
                logger.warn((Object)("Replacing " + mimetype + " default extension '" + prevExtension + "' with '" + extension + "'"));
            }
            if (extensions.size() != 0) continue;
            logger.warn((Object)("No extensions defined for mimetype: " + mimetype));
        }
        this.mimetypes = Collections.unmodifiableList(this.mimetypes);
        this.extensionsByMimetype = Collections.unmodifiableMap(this.extensionsByMimetype);
        this.mimetypesByExtension = Collections.unmodifiableMap(this.mimetypesByExtension);
        this.displaysByMimetype = Collections.unmodifiableMap(this.displaysByMimetype);
        this.displaysByExtension = Collections.unmodifiableMap(this.displaysByExtension);
    }

    @Override
    public String getExtension(String mimetype) {
        String extension = this.extensionsByMimetype.get(mimetype);
        return extension == null ? EXTENSION_BINARY : extension;
    }

    @Override
    public String getMimetype(String extension) {
        String mimetype = MIMETYPE_BINARY;
        if (extension != null && this.mimetypesByExtension.containsKey(extension = extension.toLowerCase())) {
            mimetype = this.mimetypesByExtension.get(extension);
        }
        return mimetype;
    }

    @Override
    public Map<String, String> getDisplaysByExtension() {
        return this.displaysByExtension;
    }

    @Override
    public Map<String, String> getDisplaysByMimetype() {
        return this.displaysByMimetype;
    }

    @Override
    public Map<String, String> getExtensionsByMimetype() {
        return this.extensionsByMimetype;
    }

    @Override
    public List<String> getMimetypes() {
        return this.mimetypes;
    }

    @Override
    public Map<String, String> getMimetypesByExtension() {
        return this.mimetypesByExtension;
    }

    @Override
    public boolean isText(String mimetype) {
        return this.textMimetypes.contains(mimetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaType detectType(String filename, ContentReader reader) {
        MediaType type;
        Metadata metadata = new Metadata();
        if (filename != null) {
            metadata.add("resourceName", filename);
        }
        TikaInputStream inp = null;
        if (reader != null) {
            if (reader instanceof FileContentReader) {
                try {
                    inp = TikaInputStream.get((File)((FileContentReader)reader).getFile());
                }
                catch (FileNotFoundException e) {
                    logger.warn((Object)("No backing file found for ContentReader " + e));
                    return null;
                }
            } else {
                inp = TikaInputStream.get((InputStream)reader.getContentInputStream());
            }
        }
        try {
            type = this.detector.detect(inp, metadata);
            logger.debug((Object)(reader + " detected by Tika as being " + type.toString()));
        }
        catch (Exception e) {
            logger.warn((Object)"Error identifying content type of problem document", (Throwable)e);
            MediaType mediaType = null;
            return mediaType;
        }
        finally {
            if (inp != null) {
                try {
                    inp.close();
                }
                catch (Exception e) {}
            }
        }
        return type;
    }

    @Override
    public String getMimetypeIfNotMatches(ContentReader reader) {
        MediaType type = this.detectType(null, reader);
        if (type == null) {
            return null;
        }
        if (type.toString().equals(reader.getMimetype())) {
            return null;
        }
        MediaType claimed = MediaType.parse((String)reader.getMimetype());
        if (this.tikaConfig.getMediaTypeRegistry().isSpecializationOf(claimed, type) || this.tikaConfig.getMediaTypeRegistry().isSpecializationOf(type, claimed)) {
            return null;
        }
        return type.toString();
    }

    @Override
    public String guessMimetype(String filename) {
        String extension;
        int index;
        String mimetype = MIMETYPE_BINARY;
        if (filename != null && filename.length() > 0 && (index = filename.lastIndexOf(46)) > -1 && index < filename.length() - 1 && this.mimetypesByExtension.containsKey(extension = filename.substring(index + 1).toLowerCase())) {
            mimetype = this.mimetypesByExtension.get(extension);
        }
        return mimetype;
    }

    @Override
    public String guessMimetype(String filename, ContentReader reader) {
        String tikaType;
        if (reader != null && reader.getMimetype() != null && !reader.getMimetype().equals(MIMETYPE_BINARY)) {
            return reader.getMimetype();
        }
        MediaType type = this.detectType(filename, reader);
        String filenameGuess = this.guessMimetype(filename);
        if (type == null || MediaType.OCTET_STREAM.equals((Object)type)) {
            return filenameGuess;
        }
        if (MediaType.TEXT_PLAIN.equals((Object)type) || MediaType.APPLICATION_XML.equals((Object)type)) {
            return filenameGuess;
        }
        if (type.hasParameters()) {
            type = type.getBaseType();
        }
        if (this.mimetypes.contains(tikaType = type.toString())) {
            return tikaType;
        }
        SortedSet aliases = this.tikaConfig.getMediaTypeRegistry().getAliases(type);
        for (MediaType alias : aliases) {
            String aliasType = alias.toString();
            if (!this.mimetypes.contains(aliasType)) continue;
            return aliasType;
        }
        logger.info((Object)("Tika detected a type of " + tikaType + " for file " + filename + " which Alfresco doesn't know about. Consider " + " adding that type to your configuration"));
        return tikaType;
    }
}

