/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene.functions;

import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.impl.functions.Descendant;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;

public class LuceneDescendant
extends Descendant
implements LuceneQueryBuilderComponent {
    @Override
    public Query addComponent(Set<String> selectors, Map<String, Argument> functionArgs, LuceneQueryBuilderContext luceneContext, FunctionEvaluationContext functionContext) throws ParseException {
        AbstractLuceneQueryParser lqp = luceneContext.getLuceneQueryParser();
        Argument argument = functionArgs.get("Ancestor");
        String id = (String)((Object)argument.getValue(functionContext));
        argument = functionArgs.get("Selector");
        if (argument != null) {
            String selector = (String)((Object)argument.getValue(functionContext));
            if (!selectors.contains(selector)) {
                throw new QueryModelException("Unkown selector " + selector);
            }
        } else if (selectors.size() > 1) {
            throw new QueryModelException("Selector must be specified for child constraint (IN_TREE) and join");
        }
        if (!NodeRef.isNodeRef(id)) {
            throw new QueryModelException("Invalid Object Id " + id);
        }
        NodeRef nodeRef = new NodeRef(id);
        if (functionContext.getNodeService() != null) {
            if (!functionContext.getNodeService().exists(nodeRef)) {
                throw new QueryModelException("Object does not exist: " + id);
            }
            Path path = functionContext.getNodeService().getPath(nodeRef);
            StringBuilder builder = new StringBuilder(path.toPrefixString(luceneContext.getNamespacePrefixResolver()));
            builder.append("//*");
            Query query = lqp.getFieldQuery("PATH", builder.toString());
            return query;
        }
        Query query = lqp.getFieldQuery("ANCESTOR", nodeRef.toString());
        return query;
    }
}

