/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.repository.EntityRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.commons.logging.Log;

public final class NodeRef
implements EntityRef,
Serializable {
    private static final long serialVersionUID = 3760844584074227768L;
    private static final String URI_FILLER = "/";
    private static final Pattern nodeRefPattern;
    private final StoreRef storeRef;
    private final String id;

    public NodeRef(String protocol, String identifier, String id) {
        this(new StoreRef(protocol, identifier), id);
    }

    public NodeRef(StoreRef storeRef, String id) {
        if (storeRef == null) {
            throw new IllegalArgumentException("Store reference may not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Node id may not be null");
        }
        this.storeRef = storeRef;
        this.id = id;
    }

    public NodeRef(String nodeRef) {
        int lastForwardSlash = nodeRef.lastIndexOf(47);
        if (lastForwardSlash == -1) {
            throw new AlfrescoRuntimeException("Invalid node ref - does not contain forward slash: " + nodeRef);
        }
        this.storeRef = new StoreRef(nodeRef.substring(0, lastForwardSlash));
        this.id = nodeRef.substring(lastForwardSlash + 1);
    }

    public String toString() {
        return this.storeRef.toString() + URI_FILLER + this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeRef) {
            NodeRef that = (NodeRef)obj;
            return this.id.equals(that.id) && this.storeRef.equals(that.storeRef);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public final StoreRef getStoreRef() {
        return this.storeRef;
    }

    public final String getId() {
        return this.id;
    }

    public static boolean isNodeRef(String nodeRef) {
        Matcher matcher = nodeRefPattern.matcher(nodeRef);
        return matcher.matches();
    }

    public static List<NodeRef> getNodeRefs(String values) {
        return NodeRef.getNodeRefs(values, null);
    }

    public static List<NodeRef> getNodeRefs(String values, Log logger) {
        if (values == null || values.length() == 0) {
            return Collections.emptyList();
        }
        String[] nodeRefIds = values.split(",");
        ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>(nodeRefIds.length);
        for (String nodeRefString : nodeRefIds) {
            String nodeRefId = nodeRefString.trim();
            if (NodeRef.isNodeRef(nodeRefId)) {
                NodeRef nodeRef = new NodeRef(nodeRefId);
                nodeRefs.add(nodeRef);
                continue;
            }
            if (logger == null) continue;
            NodeRef.logNodeRefError(nodeRefId, logger);
        }
        return nodeRefs;
    }

    private static void logNodeRefError(String nodeRefId, Log logger) {
        if (logger.isWarnEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Target Node: ").append(nodeRefId);
            msg.append(" is not a valid NodeRef and has been ignored.");
            logger.warn((Object)msg.toString());
        }
    }

    static {
        try {
            Introspector.getBeanInfo(NodeRef.class);
        }
        catch (IntrospectionException e) {
            throw new ExceptionInInitializerError(e);
        }
        nodeRefPattern = Pattern.compile(".+://.+/.+");
    }

    public static class Status {
        private final NodeRef nodeRef;
        private final String changeTxnId;
        private final Long dbTxnId;
        private final boolean deleted;

        public Status(NodeRef nodeRef, String changeTxnId, Long dbTxnId, boolean deleted) {
            this.nodeRef = nodeRef;
            this.changeTxnId = changeTxnId;
            this.dbTxnId = dbTxnId;
            this.deleted = deleted;
        }

        public NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public String getChangeTxnId() {
            return this.changeTxnId;
        }

        public Long getDbTxnId() {
            return this.dbTxnId;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append("Status[").append("changeTxnId=").append(this.changeTxnId).append(", dbTxnId=").append(this.dbTxnId).append(", deleted=").append(this.deleted).append("]");
            return sb.toString();
        }
    }
}

