/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.namespace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;

public class DynamicNamespacePrefixResolver
implements NamespaceService {
    private NamespacePrefixResolver delegate;
    private HashMap<String, String> map = new HashMap();

    public DynamicNamespacePrefixResolver(NamespacePrefixResolver delegate) {
        this.delegate = delegate;
    }

    public DynamicNamespacePrefixResolver() {
        this(null);
    }

    @Override
    public void registerNamespace(String prefix, String uri) {
        this.map.put(prefix, uri);
    }

    @Override
    public void unregisterNamespace(String prefix) {
        this.map.remove(prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) throws NamespaceException {
        String uri = this.map.get(prefix);
        if (uri == null && this.delegate != null) {
            uri = this.delegate.getNamespaceURI(prefix);
        }
        return uri;
    }

    @Override
    public Collection<String> getPrefixes(String namespaceURI) throws NamespaceException {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String key : this.map.keySet()) {
            String uri = this.map.get(key);
            if (uri == null || !uri.equals(namespaceURI)) continue;
            prefixes.add(key);
        }
        if (this.delegate != null) {
            for (String prefix : this.delegate.getPrefixes(namespaceURI)) {
                if (this.map.containsKey(prefix)) continue;
                prefixes.add(prefix);
            }
        }
        return prefixes;
    }

    @Override
    public Collection<String> getPrefixes() {
        HashSet<String> prefixes = new HashSet<String>();
        if (this.delegate != null) {
            prefixes.addAll(this.delegate.getPrefixes());
        }
        prefixes.addAll(this.map.keySet());
        return prefixes;
    }

    @Override
    public Collection<String> getURIs() {
        HashSet<String> uris = new HashSet<String>();
        if (this.delegate != null) {
            uris.addAll(this.delegate.getURIs());
        }
        uris.addAll(this.map.keySet());
        return uris;
    }
}

