/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.changelog;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.cmis.CMISCapabilityChanges;
import org.alfresco.cmis.CMISChangeEvent;
import org.alfresco.cmis.CMISChangeLog;
import org.alfresco.cmis.CMISChangeLogService;
import org.alfresco.cmis.CMISChangeType;
import org.alfresco.cmis.CMISInvalidArgumentException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.audit.model.AuditModelRegistryImpl;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.springframework.context.ApplicationContext;

public class CMISChangeLogServiceTest
extends TestCase {
    private static final String CMIS_AUTHORITY = "cmis";
    private static final String CHANGE_PREFIX = "Changed";
    private static final String INVALID_CHANGE_TOKEN = "<Invalid Change Token>";
    private static final String[] NAME_PARTS = new String[]{"TestDocument (", ").txt", "TestFolder (", ")"};
    private static int TOTAL_AMOUNT = 31;
    private static int CREATED_AMOUNT = 18;
    private static final int THE_HALFT_OF_CREATED_AMOUNT = CREATED_AMOUNT / 2;
    private static final Map<CMISChangeType, Integer> EXPECTED_AMOUNTS = new HashMap<CMISChangeType, Integer>();
    private AuditModelRegistryImpl auditSubsystem;
    private CMISChangeLogService changeLogService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private PermissionService permissionService;
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;
    private RetryingTransactionHelper retryingTransactionHelper;
    private UserTransaction testTX;
    private int actualCount = 0;
    private Map<CMISChangeType, Integer> actualAmounts = new HashMap<CMISChangeType, Integer>();
    private List<NodeRef> created = null;
    private List<NodeRef> deleted = null;

    private void disableAudit() {
        this.auditSubsystem.stop();
        this.auditSubsystem.setProperty("audit.enabled", "true");
        this.auditSubsystem.setProperty("audit.cmischangelog.enabled", "false");
    }

    private void enableAudit() {
        this.auditSubsystem.stop();
        this.auditSubsystem.setProperty("audit.enabled", "true");
        this.auditSubsystem.setProperty("audit.cmischangelog.enabled", "true");
    }

    public void testServiceWithDisabledAuditing() throws Exception {
        this.disableAudit();
        String lastChangeLogToken = this.changeLogService.getLastChangeLogToken();
        this.createTestData(EXPECTED_AMOUNTS, false);
        CMISChangeLogServiceTest.assertEquals((Object)((Object)CMISCapabilityChanges.NONE), (Object)((Object)this.changeLogService.getCapability()));
        try {
            this.changeLogService.getChangeLogEvents(lastChangeLogToken, null);
            CMISChangeLogServiceTest.fail((String)"Changes Logging was not enabled but no one Change Log Service method thrown exception");
        }
        catch (Exception e) {
            CMISChangeLogServiceTest.assertTrue((String)"Invalid exception type from Change Log Service method call with desabled Changes Logging", (boolean)(e instanceof AlfrescoRuntimeException));
        }
    }

    public void testEnabledAuditing() throws Exception {
        this.enableAudit();
        String logToken = this.changeLogService.getLastChangeLogToken();
        this.createTestData(EXPECTED_AMOUNTS, false);
        CMISChangeLogServiceTest.assertEquals((Object)((Object)CMISCapabilityChanges.OBJECTIDSONLY), (Object)((Object)this.changeLogService.getCapability()));
        CMISChangeLog changeLog = this.changeLogService.getChangeLogEvents(logToken, null);
        this.assertChangeLog(logToken, changeLog);
        this.assertChangeEvents(logToken, changeLog, null, FoldersAppearing.NOT_EXPECTED);
    }

    private void assertChangeLog(String logToken, CMISChangeLog changeLog) {
        CMISChangeLogServiceTest.assertNotNull((String)("'" + logToken + "' Change Log Token has no descriptor"), (Object)changeLog);
        CMISChangeLogServiceTest.assertNotNull((String)("Event Etries for '" + logToken + "' Change Log Token are undefined"), changeLog.getChangeEvents());
        CMISChangeLogServiceTest.assertFalse((String)("Descriptor for '" + logToken + "' Change Log Token has no any Event Entry"), (boolean)changeLog.getChangeEvents().isEmpty());
    }

    private Pair<List<NodeRef>, List<NodeRef>> createTestData(Map<CMISChangeType, Integer> requiredAmounts, boolean withFolders) {
        this.changeLogService.getLastChangeLogToken();
        this.created = new LinkedList<NodeRef>();
        this.deleted = new LinkedList<NodeRef>();
        Pair result = new Pair(this.created, this.deleted);
        NodeRef parentNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        SecureRandom randomizer = new SecureRandom();
        for (CMISChangeType key : requiredAmounts.keySet()) {
            Integer amount = requiredAmounts.get((Object)key);
            for (int i = 0; i < amount; ++i) {
                boolean folder = withFolders && 0 == Math.abs(randomizer.nextInt()) % amount % 2;
                QName objectType = folder ? ContentModel.TYPE_FOLDER : ContentModel.TYPE_CONTENT;
                FileInfo object = this.fileFolderService.create(parentNodeRef, this.generateName(randomizer, folder), objectType);
                this.created.add(object.getNodeRef());
                this.addOneToAmount(this.actualAmounts, CMISChangeType.CREATED);
                switch (key) {
                    case DELETED: {
                        this.nodeService.deleteNode(object.getNodeRef());
                        this.deleted.add(object.getNodeRef());
                        this.addOneToAmount(this.actualAmounts, CMISChangeType.DELETED);
                        break;
                    }
                    case SECURITY: {
                        this.permissionService.setPermission(object.getNodeRef(), CMIS_AUTHORITY, "ExecuteContent", true);
                        this.addOneToAmount(this.actualAmounts, CMISChangeType.SECURITY);
                        break;
                    }
                    case UPDATED: {
                        StringBuilder nameBuilder = new StringBuilder(CHANGE_PREFIX);
                        nameBuilder.append(this.nodeService.getProperty(object.getNodeRef(), ContentModel.PROP_NAME));
                        this.nodeService.setProperty(object.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)nameBuilder.toString()));
                        this.addOneToAmount(this.actualAmounts, CMISChangeType.UPDATED);
                    }
                }
                ++this.actualCount;
            }
        }
        return result;
    }

    private void deleteTestData() {
        if (this.created != null) {
            for (NodeRef object : this.created) {
                if (!this.nodeService.exists(object) || AccessStatus.ALLOWED != this.permissionService.hasPermission(object, "Delete")) continue;
                this.nodeService.deleteNode(object);
            }
        }
    }

    private String generateName(SecureRandom randomizer, boolean folder) {
        StringBuilder nameBuilder = new StringBuilder();
        int i = folder ? 2 : 0;
        nameBuilder.append(NAME_PARTS[i++]).append(Math.abs(randomizer.nextInt())).append(NAME_PARTS[i++]);
        return nameBuilder.toString();
    }

    private void assertChangeEvents(String logToken, CMISChangeLog changeLog, Integer maxItems, FoldersAppearing foldersAppearing) {
        HashMap<CMISChangeType, Integer> logAmounts = new HashMap<CMISChangeType, Integer>();
        boolean folderWasFound = false;
        int idx = 0;
        for (CMISChangeEvent event : changeLog.getChangeEvents()) {
            if (logToken != null && ++idx == 1) continue;
            CMISChangeLogServiceTest.assertNotNull((String)("One of the Change Log Event Enries is undefined for '" + logToken + "' Change Log Token"), (Object)event);
            CMISChangeLogServiceTest.assertNotNull((String)("Change Event Entry Id of one of the Change Entries is undefined for '" + logToken + "' Change Log Token"), (Object)event.getChangedNode());
            CMISChangeLogServiceTest.assertNotNull((String)("Change Event Change Type of one of the Change Entries is undefined for '" + logToken + "' Change Log Token"), (Object)((Object)event.getChangeType()));
            CMISChangeLogServiceTest.assertTrue((String)("Unexpected Object Id='" + event.getChangedNode().toString() + "' from Change Log Token Entries list for '" + logToken + "' Change Log Token"), (boolean)this.created.contains(event.getChangedNode()));
            if (!this.deleted.contains(event.getChangedNode())) {
                folderWasFound = folderWasFound || this.fileFolderService.getFileInfo(event.getChangedNode()).isFolder();
                CMISChangeLogServiceTest.assertTrue((String)("Object from Change Event Entries list is marked as '" + event.getChangeType().toString() + "' but does not exist for '" + logToken + "' Change Log Token"), (boolean)this.nodeService.exists(event.getChangedNode()));
            } else {
                CMISChangeLogServiceTest.assertTrue((String)"Object has been deleted", (boolean)this.deleted.contains(event.getChangedNode()));
                CMISChangeLogServiceTest.assertFalse((String)("Object from Change Event Entries list is marked as 'DELETED' but it still exist for '" + logToken + "' Change Log Token"), (boolean)this.nodeService.exists(event.getChangedNode()));
            }
            this.addOneToAmount(logAmounts, event.getChangeType());
        }
        if (FoldersAppearing.MUST_APPEAR == foldersAppearing) {
            CMISChangeLogServiceTest.assertTrue((String)"No one Folder Object was returned", (boolean)folderWasFound);
        } else if (FoldersAppearing.NOT_EXPECTED == foldersAppearing) {
            CMISChangeLogServiceTest.assertFalse((String)"Some Folder Object was found", (boolean)folderWasFound);
        }
        if (null == maxItems || maxItems >= TOTAL_AMOUNT) {
            for (CMISChangeType key : this.actualAmounts.keySet()) {
                Integer actualAmount = this.actualAmounts.get((Object)key);
                Integer logAmount = (Integer)logAmounts.get((Object)key);
                CMISChangeLogServiceTest.assertTrue((String)("Invalid Entries amount for '" + key.toString() + "' Change Type. Actual amount: " + actualAmount + ", but log amount: " + logAmount), (boolean)actualAmount.equals(logAmount));
            }
        }
    }

    private void addOneToAmount(Map<CMISChangeType, Integer> mappedAmounts, CMISChangeType changeType) {
        Integer amount = mappedAmounts.get((Object)changeType);
        amount = null == amount ? Integer.valueOf(1) : Integer.valueOf(amount + 1);
        mappedAmounts.put(changeType, amount);
    }

    public void testEnabledAuditingForMaxItems() throws Exception {
        this.enableAudit();
        String logToken = this.changeLogService.getLastChangeLogToken();
        this.createTestData(EXPECTED_AMOUNTS, false);
        CMISChangeLogServiceTest.assertEquals((Object)((Object)CMISCapabilityChanges.OBJECTIDSONLY), (Object)((Object)this.changeLogService.getCapability()));
        CMISChangeLog changeLog = this.changeLogService.getChangeLogEvents(logToken, THE_HALFT_OF_CREATED_AMOUNT);
        this.assertChangeLog(logToken, changeLog);
        this.assertChangeEvents(logToken, changeLog, THE_HALFT_OF_CREATED_AMOUNT, FoldersAppearing.NOT_EXPECTED);
        CMISChangeLogServiceTest.assertEquals((int)THE_HALFT_OF_CREATED_AMOUNT, (int)changeLog.getChangeEvents().size());
        CMISChangeLogServiceTest.assertTrue((String)"Not all Change Log Entries were requested but result set is indicating that no one more Entry is avilable", (boolean)changeLog.hasMoreItems());
        changeLog = this.changeLogService.getChangeLogEvents(logToken, TOTAL_AMOUNT + (logToken == null ? 0 : 1));
        this.assertChangeEvents(logToken, changeLog, TOTAL_AMOUNT, FoldersAppearing.NOT_EXPECTED);
        CMISChangeLogServiceTest.assertFalse((String)"All Change Log Entries were requested but result set is indicating that some more Entry(s) are available", (boolean)changeLog.hasMoreItems());
    }

    public void testReceivingChangeEventsForInvalidChangeToken() throws Exception {
        this.enableAudit();
        try {
            this.changeLogService.getChangeLogEvents(INVALID_CHANGE_TOKEN, null);
            CMISChangeLogServiceTest.fail((String)"Change Events were received normally for Invalid Change Log Token");
        }
        catch (Exception e) {
            CMISChangeLogServiceTest.assertTrue((String)"Invalid exception type from Change Log Service method call with enabled Changes Logging", (boolean)(e instanceof CMISInvalidArgumentException));
        }
        this.disableAudit();
        try {
            this.changeLogService.getChangeLogEvents(INVALID_CHANGE_TOKEN, null);
            CMISChangeLogServiceTest.fail((String)"Changes Logging was not enabled but not one Change Log Service method thrown exception");
        }
        catch (Exception e) {
            CMISChangeLogServiceTest.assertTrue((String)"Invalid exception type from Change Log Service method call with desabled Changes Logging", (boolean)(e instanceof AlfrescoRuntimeException));
        }
    }

    public void testReceivingOfChangeEventsExpectingFolders() throws Exception {
        this.enableAudit();
        String changeToken = this.changeLogService.getLastChangeLogToken();
        this.createTestData(EXPECTED_AMOUNTS, true);
        CMISChangeLog changeLogEvents = this.changeLogService.getChangeLogEvents(changeToken, null);
        this.assertChangeLog(changeToken, changeLogEvents);
        this.assertChangeEvents(changeToken, changeLogEvents, null, FoldersAppearing.MUST_APPEAR);
    }

    public void testReceivingOfChangeEventsExpectingFoldersAndBoundedByMaxItems() throws Exception {
        this.enableAudit();
        String changeToken = this.changeLogService.getLastChangeLogToken();
        this.createTestData(EXPECTED_AMOUNTS, true);
        CMISChangeLog changeLogEvents = this.changeLogService.getChangeLogEvents(changeToken, 15);
        CMISChangeLogServiceTest.assertTrue((String)"Not all Change Event Entries were requested but result set indicates that no more Entry(s) available", (boolean)changeLogEvents.hasMoreItems());
        this.assertChangeLog(changeToken, changeLogEvents);
        this.assertChangeEvents(changeToken, changeLogEvents, 15, FoldersAppearing.MAY_APPEAR);
        changeLogEvents = this.changeLogService.getChangeLogEvents(changeToken, TOTAL_AMOUNT + (changeToken == null ? 0 : 1));
        this.assertChangeLog(changeToken, changeLogEvents);
        this.assertChangeEvents(changeToken, changeLogEvents, TOTAL_AMOUNT, FoldersAppearing.MUST_APPEAR);
        CMISChangeLogServiceTest.assertFalse((String)"All Change Event Entries were requested but results indicating that some more Entry(s) available", (boolean)changeLogEvents.hasMoreItems());
    }

    public void setUp() throws Exception {
        ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
        this.changeLogService = (CMISChangeLogService)applicationContext.getBean("CMISChangeLogService");
        this.nodeService = (NodeService)applicationContext.getBean("NodeService");
        this.permissionService = (PermissionService)applicationContext.getBean("PermissionService");
        this.fileFolderService = (FileFolderService)applicationContext.getBean("FileFolderService");
        this.transactionService = (TransactionService)applicationContext.getBean("transactionComponent");
        this.authenticationComponent = (AuthenticationComponent)applicationContext.getBean("authenticationComponent");
        this.retryingTransactionHelper = (RetryingTransactionHelper)applicationContext.getBean("retryingTransactionHelper");
        this.auditSubsystem = (AuditModelRegistryImpl)applicationContext.getBean("Audit");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> initAudit = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Exception {
                CMISChangeLogServiceTest.this.auditSubsystem.stop();
                CMISChangeLogServiceTest.this.auditSubsystem.setProperty("audit.enabled", "true");
                CMISChangeLogServiceTest.this.auditSubsystem.setProperty("audit.cmischangelog.enabled", "true");
                CMISChangeLogServiceTest.this.auditSubsystem.start();
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction(initAudit, false, true);
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    protected void tearDown() throws Exception {
        this.deleteTestData();
        if (this.testTX.getStatus() == 0) {
            this.testTX.rollback();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        this.auditSubsystem.destroy();
    }

    static {
        EXPECTED_AMOUNTS.put(CMISChangeType.CREATED, 5);
        EXPECTED_AMOUNTS.put(CMISChangeType.DELETED, 3);
        EXPECTED_AMOUNTS.put(CMISChangeType.SECURITY, 4);
        EXPECTED_AMOUNTS.put(CMISChangeType.UPDATED, 6);
    }

    private static enum FoldersAppearing {
        NOT_EXPECTED,
        MAY_APPEAR,
        MUST_APPEAR;

    }
}

