/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.io.Serializable;
import org.alfresco.cmis.mapping.AbstractSimpleProperty;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

public class ContentStreamLengthProperty
extends AbstractSimpleProperty {
    public ContentStreamLengthProperty(ServiceRegistry serviceRegistry) {
        super(serviceRegistry, "cmis:contentStreamLength");
    }

    @Override
    public Serializable getValue(NodeRef nodeRef) {
        Serializable value = this.getServiceRegistry().getNodeService().getProperty(nodeRef, ContentModel.PROP_CONTENT);
        if (value != null) {
            ContentData contentData = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)value);
            return Long.valueOf(contentData.getSize());
        }
        return Long.valueOf(0L);
    }

    @Override
    public String getLuceneFieldName() {
        StringBuilder field = new StringBuilder(128);
        field.append("@");
        field.append(ContentModel.PROP_CONTENT);
        field.append(".size");
        return field.toString();
    }

    @Override
    protected String getValueAsString(Serializable value) {
        Object converted = DefaultTypeConverter.INSTANCE.convert(this.getServiceRegistry().getDictionaryService().getDataType(DataTypeDefinition.LONG), (Object)value);
        String asString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, converted);
        return asString;
    }

    @Override
    protected QName getQNameForExists() {
        return ContentModel.PROP_CONTENT;
    }

    @Override
    protected DataTypeDefinition getInDataType() {
        return this.getServiceRegistry().getDictionaryService().getDataType(DataTypeDefinition.LONG);
    }
}

