/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.email.server.AliasableAspect;
import org.alfresco.email.server.handler.EmailMessageHandler;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.email.EmailDelivery;
import org.alfresco.service.cmr.email.EmailMessage;
import org.alfresco.service.cmr.email.EmailMessageException;
import org.alfresco.service.cmr.email.EmailService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

public class EmailServiceImpl
implements EmailService {
    private static final String ERR_INBOUND_EMAIL_DISABLED = "email.server.err.inbound_mail_disabled";
    private static final String ERR_INVALID_SUBJECT = "email.server.err.invalid_subject";
    private static final String ERR_ACCESS_DENIED = "email.server.err.access_denied";
    private static final String ERR_UNKNOWN_SOURCE_ADDRESS = "email.server.err.unknown_source_address";
    private static final String ERR_USER_NOT_EMAIL_CONTRIBUTOR = "email.server.err.user_not_email_contributor";
    private static final String ERR_INVALID_NODE_ADDRESS = "email.server.err.invalid_node_address";
    private static final String ERR_HANDLER_NOT_FOUND = "email.server.err.handler_not_found";
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private SearchService searchService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private AuthorityService authorityService;
    private DictionaryService dictionaryService;
    private AttributeService attributeService;
    private String emailContributorsAuthority = "EMAIL_CONTRIBUTORS";
    private static Log logger = LogFactory.getLog(EmailServiceImpl.class);
    private boolean emailInboundEnabled;
    private String unknownUser;
    private Map<String, EmailMessageHandler> emailMessageHandlerMap;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.getDictionaryService());
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"authorityService", (Object)this.authorityService);
        PropertyCheck.mandatory((Object)this, (String)"emailMessageHandlerMap", this.emailMessageHandlerMap);
        PropertyCheck.mandatory((Object)this, (String)"attributeService", (Object)this.getAttributeService());
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public Map<String, EmailMessageHandler> getEmailMessageHandlerMap() {
        return this.emailMessageHandlerMap;
    }

    public void setEmailMessageHandlerMap(Map<String, EmailMessageHandler> emailMessageHandlerMap) {
        this.emailMessageHandlerMap = emailMessageHandlerMap;
    }

    public void setUnknownUser(String unknownUser) {
        this.unknownUser = unknownUser;
    }

    public void setEmailInboundEnabled(boolean mailInboundEnabled) {
        this.emailInboundEnabled = mailInboundEnabled;
    }

    @Override
    public void importMessage(EmailDelivery delivery, EmailMessage message) {
        this.processMessage(delivery, null, message);
    }

    @Override
    public void importMessage(EmailDelivery delivery, NodeRef nodeRef, EmailMessage message) {
        this.processMessage(delivery, nodeRef, message);
    }

    private void processMessage(final EmailDelivery delivery, final NodeRef nodeRef, final EmailMessage message) {
        if (!this.emailInboundEnabled) {
            throw new EmailMessageException(ERR_INBOUND_EMAIL_DISABLED, new Object[0]);
        }
        try {
            String username;
            final RetryingTransactionHelper.RetryingTransactionCallback<String> getUsernameCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                @Override
                public String execute() throws Throwable {
                    String userName = null;
                    userName = EmailServiceImpl.this.getUsername(delivery.getFrom());
                    if (userName == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("unable to find user for from: " + delivery.getFrom() + ",trying message.from next"));
                        }
                        userName = EmailServiceImpl.this.getUsername(message.getFrom());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("userName = : " + userName));
                    }
                    if (userName == null) {
                        if (EmailServiceImpl.this.unknownUser.isEmpty()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("unable to find user for from: " + message.getFrom()));
                            }
                            throw new EmailMessageException(EmailServiceImpl.ERR_UNKNOWN_SOURCE_ADDRESS, message.getFrom());
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"unable to find user for from - return anonymous: ");
                        }
                        userName = EmailServiceImpl.this.unknownUser;
                    }
                    if (userName == null || !EmailServiceImpl.this.isEmailContributeUser(userName)) {
                        throw new EmailMessageException(EmailServiceImpl.ERR_USER_NOT_EMAIL_CONTRIBUTOR, userName);
                    }
                    return userName;
                }
            };
            AuthenticationUtil.RunAsWork<String> getUsernameRunAsWork = new AuthenticationUtil.RunAsWork<String>(){

                public String doWork() throws Exception {
                    return (String)EmailServiceImpl.this.retryingTransactionHelper.doInTransaction(getUsernameCallback, false);
                }
            };
            if (delivery.getAuth() != null) {
                username = delivery.getAuth();
                logger.debug((Object)("user has already authenticated as:" + username));
            } else {
                username = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)getUsernameRunAsWork, (String)"System");
            }
            final RetryingTransactionHelper.RetryingTransactionCallback<Object> processMessageCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    String recipient = delivery.getRecipient();
                    NodeRef targetNodeRef = null;
                    targetNodeRef = nodeRef == null ? EmailServiceImpl.this.getTargetNode(recipient) : nodeRef;
                    EmailMessageHandler messageHandler = EmailServiceImpl.this.getMessageHandler(targetNodeRef);
                    messageHandler.processMessage(targetNodeRef, message);
                    return null;
                }
            };
            AuthenticationUtil.RunAsWork<Object> processMessageRunAsWork = new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    return EmailServiceImpl.this.retryingTransactionHelper.doInTransaction(processMessageCallback, false);
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)processMessageRunAsWork, (String)username);
        }
        catch (EmailMessageException e) {
            throw e;
        }
        catch (AccessDeniedException e) {
            throw new EmailMessageException(ERR_ACCESS_DENIED, delivery.getFrom(), delivery.getRecipient());
        }
        catch (IntegrityException e) {
            throw new EmailMessageException(ERR_INVALID_SUBJECT, new Object[0]);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Email message processing failed", e);
        }
    }

    private EmailMessageHandler getMessageHandler(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        QName nodeTypeQName = this.nodeService.getType(nodeRef);
        String prefixedNodeTypeStr = nodeTypeQName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        EmailMessageHandler handler = this.emailMessageHandlerMap.get(prefixedNodeTypeStr);
        if (handler == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("did not find a handler for type:" + prefixedNodeTypeStr));
            }
            TypeDefinition typeDef = this.dictionaryService.getType(nodeTypeQName);
            while (typeDef != null) {
                String prefixedSubTypeStr;
                QName parentName = typeDef.getParentName();
                if (parentName != null && (handler = this.emailMessageHandlerMap.get(prefixedSubTypeStr = parentName.toPrefixString((NamespacePrefixResolver)this.namespaceService))) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("found a handler for a subtype:" + prefixedSubTypeStr));
                    }
                    return handler;
                }
                typeDef = this.dictionaryService.getType(parentName);
            }
        }
        if (handler == null) {
            throw new EmailMessageException(ERR_HANDLER_NOT_FOUND, prefixedNodeTypeStr);
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeRef getTargetNode(String recipient) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getTarget node for" + recipient));
        }
        if (recipient == null || recipient.length() == 0) {
            throw new EmailMessageException(ERR_INVALID_NODE_ADDRESS, recipient);
        }
        String[] parts = recipient.split("@");
        if (parts.length != 2) {
            throw new EmailMessageException(ERR_INVALID_NODE_ADDRESS, recipient);
        }
        String alias = parts[0];
        NodeRef ref = (NodeRef)this.getAttributeService().getAttribute(new Serializable[]{"AliasableAspect", "Alias", AliasableAspect.normaliseAlias(alias)});
        if (ref != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("found email alias via attribute service alias =" + alias));
            }
            return ref;
        }
        StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
        ResultSet resultSet = null;
        try {
            String query = "@sys\\:node-dbid:" + parts[0];
            resultSet = this.searchService.query(storeRef, "lucene", query);
            if (resultSet.length() > 0) {
                NodeRef nodeRef = resultSet.getNodeRef(0);
                return nodeRef;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        throw new EmailMessageException(ERR_INVALID_NODE_ADDRESS, recipient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUsername(String from) {
        String userName;
        block10: {
            userName = null;
            if (from == null || from.length() == 0) {
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getUsername from: " + from));
            }
            StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
            String query = "TYPE:cm\\:person +@cm\\:email:\"" + from + "\"";
            ResultSet resultSet = this.searchService.query(storeRef, "lucene", query);
            try {
                if (resultSet.length() == 0) {
                    String string = null;
                    return string;
                }
                NodeRef userNode = resultSet.getNodeRef(0);
                if (this.nodeService.exists(userNode)) {
                    userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_USERNAME));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("found username: " + userName));
                    }
                    break block10;
                }
                throw new EmailMessageException(ERR_UNKNOWN_SOURCE_ADDRESS, from);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        return userName;
    }

    private boolean isEmailContributeUser(String userName) {
        return this.authorityService.getAuthoritiesForUser(userName).contains(this.authorityService.getName(AuthorityType.GROUP, this.getEmailContributorsAuthority()));
    }

    public void setEmailContributorsAuthority(String emailContributorsAuthority) {
        this.emailContributorsAuthority = emailContributorsAuthority;
    }

    public String getEmailContributorsAuthority() {
        return this.emailContributorsAuthority;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public AttributeService getAttributeService() {
        return this.attributeService;
    }
}

