/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SealedObject;
import org.alfresco.encryption.MissingKeyException;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodePropertyEntity;
import org.alfresco.repo.domain.node.NodePropertyKey;
import org.alfresco.repo.domain.node.NodePropertyValue;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.node.encryption.MetadataEncryptor;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;

public class ReEncryptor
implements ApplicationContextAware {
    private static Log logger = LogFactory.getLog(ReEncryptor.class);
    private NodeDAO nodeDAO;
    private DictionaryDAO dictionaryDAO;
    private QNameDAO qnameDAO;
    private MetadataEncryptor metadataEncryptor;
    private ApplicationContext applicationContext;
    private TransactionService transactionService;
    private RetryingTransactionHelper transactionHelper;
    private int numThreads;
    private int chunkSize;
    private boolean splitTxns = true;
    private static final QName LOCK = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"OrphanReaper");
    private JobLockService jobLockService;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
        this.transactionHelper = transactionService.getRetryingTransactionHelper();
    }

    public void setMetadataEncryptor(MetadataEncryptor metadataEncryptor) {
        this.metadataEncryptor = metadataEncryptor;
    }

    public MetadataEncryptor getMetadataEncryptor() {
        return this.metadataEncryptor;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void setSplitTxns(boolean splitTxns) {
        this.splitTxns = splitTxns;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    private String getLock(long time) {
        try {
            return this.jobLockService.getLock(LOCK, time);
        }
        catch (LockAcquisitionException e) {
            return null;
        }
    }

    private void refreshLock(String lockToken, long time) {
        if (lockToken == null) {
            throw new IllegalArgumentException("Must provide existing lockToken");
        }
        this.jobLockService.refreshLock(lockToken, LOCK, time);
    }

    protected void reEncryptProperties(final List<NodePropertyEntity> properties, final String lockToken) {
        final Iterator<NodePropertyEntity> it = properties.iterator();
        BatchProcessor.BatchProcessWorker<NodePropertyEntity> worker = new BatchProcessor.BatchProcessWorker<NodePropertyEntity>(){

            @Override
            public String getIdentifier(NodePropertyEntity entity) {
                return String.valueOf(entity.getNodeId());
            }

            @Override
            public void beforeProcess() throws Throwable {
                ReEncryptor.this.refreshLock(lockToken, (long)ReEncryptor.this.chunkSize * 100L);
            }

            @Override
            public void afterProcess() throws Throwable {
            }

            @Override
            public void process(NodePropertyEntity entity) throws Throwable {
                NodePropertyValue nodePropValue = entity.getValue();
                Serializable value = nodePropValue.getSerializableValue();
                if (value instanceof SealedObject) {
                    SealedObject sealed = (SealedObject)value;
                    NodePropertyKey propertyKey = entity.getKey();
                    QName propertyQName = (QName)ReEncryptor.this.qnameDAO.getQName(propertyKey.getQnameId()).getSecond();
                    Serializable decrypted = ReEncryptor.this.metadataEncryptor.decrypt(propertyQName, sealed);
                    Serializable resealed = ReEncryptor.this.metadataEncryptor.encrypt(propertyQName, decrypted);
                    ReEncryptor.this.nodeDAO.setNodeProperties(entity.getNodeId(), Collections.singletonMap(propertyQName, resealed));
                } else {
                    NodePropertyKey nodeKey = entity.getKey();
                    QName propertyQName = (QName)ReEncryptor.this.qnameDAO.getQName(nodeKey.getQnameId()).getSecond();
                    logger.warn((Object)("Encountered an encrypted property that is not a SealedObject, for node id " + entity.getNodeId() + ", property " + propertyQName));
                }
            }
        };
        BatchProcessWorkProvider<NodePropertyEntity> provider = new BatchProcessWorkProvider<NodePropertyEntity>(){

            @Override
            public int getTotalEstimatedWorkSize() {
                return properties.size();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection<NodePropertyEntity> getNextWork() {
                ArrayList<NodePropertyEntity> sublist = new ArrayList<NodePropertyEntity>(ReEncryptor.this.chunkSize);
                Iterator iterator = it;
                synchronized (iterator) {
                    for (int count = 0; it.hasNext() && count < ReEncryptor.this.chunkSize; ++count) {
                        sublist.add((NodePropertyEntity)it.next());
                    }
                }
                return sublist;
            }
        };
        new BatchProcessor<NodePropertyEntity>("Reencryptor", this.transactionHelper, provider, this.numThreads, this.chunkSize, (ApplicationEventPublisher)this.applicationContext, logger, 100).process(worker, this.splitTxns);
    }

    public int bootstrapReEncrypt() throws MissingKeyException {
        if (!this.metadataEncryptor.backupKeyAvailable("metadata")) {
            throw new MissingKeyException("Backup key store is either not present or does not contain a metadata encryption key");
        }
        return this.reEncrypt();
    }

    public int reEncrypt() throws MissingKeyException {
        if (!this.metadataEncryptor.keyAvailable("metadata")) {
            throw new MissingKeyException("Main key store is either not present or does not contain a metadata encryption key");
        }
        if (!this.metadataEncryptor.backupKeyAvailable("metadata")) {
            throw new MissingKeyException("Backup key store is either not present or does not contain a metadata encryption key");
        }
        int numProps = this.reEncryptImpl();
        return numProps;
    }

    protected int reEncryptImpl() {
        RetryingTransactionHelper.RetryingTransactionCallback<String> txnWork = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Exception {
                String lockToken = ReEncryptor.this.getLock(20000L);
                return lockToken;
            }
        };
        String lockToken = this.transactionService.getRetryingTransactionHelper().doInTransaction(txnWork, false, true);
        if (lockToken == null) {
            logger.warn((Object)"Can't get lock. Assume multiple re-encryptors ...");
            return 0;
        }
        Collection propertyDefs = this.dictionaryDAO.getPropertiesOfDataType(DataTypeDefinition.ENCRYPTED);
        List<NodePropertyEntity> properties = this.nodeDAO.selectProperties(propertyDefs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found " + properties.size() + " properties to re-encrypt..."));
        }
        this.reEncryptProperties(properties, lockToken);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"...done re-encrypting.");
        }
        return properties.size();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

